package software.amazon.awscdk.services.cognito;

/**
 * The Type of Threat Protection Enabled for Custom Authentication.
 * <p>
 * This feature only functions if your FeaturePlan is set to FeaturePlan.PLUS
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.237Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CustomThreatProtectionMode")
public enum CustomThreatProtectionMode {
    /**
     * Cognito automatically takes preventative actions in response to different levels of risk that you configure for your user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FULL_FUNCTION,
    /**
     * Cognito gathers metrics on detected risks, but doesn't take automatic action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUDIT_ONLY,
}
