package software.amazon.awscdk.services.cognito;

/**
 * A reference to a LogDeliveryConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * LogDeliveryConfigurationReference logDeliveryConfigurationReference = LogDeliveryConfigurationReference.builder()
 *         .logDeliveryConfigurationId("logDeliveryConfigurationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.260Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.LogDeliveryConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(LogDeliveryConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogDeliveryConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the LogDeliveryConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogDeliveryConfigurationId();

    /**
     * @return a {@link Builder} of {@link LogDeliveryConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogDeliveryConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogDeliveryConfigurationReference> {
        java.lang.String logDeliveryConfigurationId;

        /**
         * Sets the value of {@link LogDeliveryConfigurationReference#getLogDeliveryConfigurationId}
         * @param logDeliveryConfigurationId The Id of the LogDeliveryConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurationId(java.lang.String logDeliveryConfigurationId) {
            this.logDeliveryConfigurationId = logDeliveryConfigurationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogDeliveryConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogDeliveryConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogDeliveryConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDeliveryConfigurationReference {
        private final java.lang.String logDeliveryConfigurationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDeliveryConfigurationId = software.amazon.jsii.Kernel.get(this, "logDeliveryConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDeliveryConfigurationId = java.util.Objects.requireNonNull(builder.logDeliveryConfigurationId, "logDeliveryConfigurationId is required");
        }

        @Override
        public final java.lang.String getLogDeliveryConfigurationId() {
            return this.logDeliveryConfigurationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDeliveryConfigurationId", om.valueToTree(this.getLogDeliveryConfigurationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.LogDeliveryConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogDeliveryConfigurationReference.Jsii$Proxy that = (LogDeliveryConfigurationReference.Jsii$Proxy) o;

            return this.logDeliveryConfigurationId.equals(that.logDeliveryConfigurationId);
        }

        @Override
        public final int hashCode() {
            int result = this.logDeliveryConfigurationId.hashCode();
            return result;
        }
    }
}
