package software.amazon.awscdk.services.cognito;

/**
 * A reference to a UserPoolUserToGroupAttachment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * UserPoolUserToGroupAttachmentReference userPoolUserToGroupAttachmentReference = UserPoolUserToGroupAttachmentReference.builder()
 *         .groupName("groupName")
 *         .username("username")
 *         .userPoolId("userPoolId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.314Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolUserToGroupAttachmentReference")
@software.amazon.jsii.Jsii.Proxy(UserPoolUserToGroupAttachmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolUserToGroupAttachmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GroupName of the UserPoolUserToGroupAttachment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupName();

    /**
     * The Username of the UserPoolUserToGroupAttachment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * The UserPoolId of the UserPoolUserToGroupAttachment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * @return a {@link Builder} of {@link UserPoolUserToGroupAttachmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolUserToGroupAttachmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolUserToGroupAttachmentReference> {
        java.lang.String groupName;
        java.lang.String username;
        java.lang.String userPoolId;

        /**
         * Sets the value of {@link UserPoolUserToGroupAttachmentReference#getGroupName}
         * @param groupName The GroupName of the UserPoolUserToGroupAttachment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolUserToGroupAttachmentReference#getUsername}
         * @param username The Username of the UserPoolUserToGroupAttachment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolUserToGroupAttachmentReference#getUserPoolId}
         * @param userPoolId The UserPoolId of the UserPoolUserToGroupAttachment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolUserToGroupAttachmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolUserToGroupAttachmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolUserToGroupAttachmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolUserToGroupAttachmentReference {
        private final java.lang.String groupName;
        private final java.lang.String username;
        private final java.lang.String userPoolId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupName = java.util.Objects.requireNonNull(builder.groupName, "groupName is required");
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupName", om.valueToTree(this.getGroupName()));
            data.set("username", om.valueToTree(this.getUsername()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolUserToGroupAttachmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolUserToGroupAttachmentReference.Jsii$Proxy that = (UserPoolUserToGroupAttachmentReference.Jsii$Proxy) o;

            if (!groupName.equals(that.groupName)) return false;
            if (!username.equals(that.username)) return false;
            return this.userPoolId.equals(that.userPoolId);
        }

        @Override
        public final int hashCode() {
            int result = this.groupName.hashCode();
            result = 31 * result + (this.username.hashCode());
            result = 31 * result + (this.userPoolId.hashCode());
            return result;
        }
    }
}
