package software.amazon.awscdk.services.config;

/**
 * The maximum frequency at which the AWS Config rule runs evaluations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * // https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * ManagedRule.Builder.create(this, "AccessKeysRotated")
 *         .identifier(ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED)
 *         .inputParameters(Map.of(
 *                 "maxAccessKeyAge", 60))
 *         // default is 24 hours
 *         .maximumExecutionFrequency(MaximumExecutionFrequency.TWELVE_HOURS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.455Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.MaximumExecutionFrequency")
public enum MaximumExecutionFrequency {
    /**
     * 1 hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_HOUR,
    /**
     * 3 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_HOURS,
    /**
     * 6 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIX_HOURS,
    /**
     * 12 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWELVE_HOURS,
    /**
     * 24 hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWENTY_FOUR_HOURS,
}
