package software.amazon.awscdk.services.config;

/**
 * A reference to a OrganizationConfigRule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * OrganizationConfigRuleReference organizationConfigRuleReference = OrganizationConfigRuleReference.builder()
 *         .organizationConfigRuleId("organizationConfigRuleId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.455Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.OrganizationConfigRuleReference")
@software.amazon.jsii.Jsii.Proxy(OrganizationConfigRuleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OrganizationConfigRuleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the OrganizationConfigRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationConfigRuleId();

    /**
     * @return a {@link Builder} of {@link OrganizationConfigRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OrganizationConfigRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OrganizationConfigRuleReference> {
        java.lang.String organizationConfigRuleId;

        /**
         * Sets the value of {@link OrganizationConfigRuleReference#getOrganizationConfigRuleId}
         * @param organizationConfigRuleId The Id of the OrganizationConfigRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationConfigRuleId(java.lang.String organizationConfigRuleId) {
            this.organizationConfigRuleId = organizationConfigRuleId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OrganizationConfigRuleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OrganizationConfigRuleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OrganizationConfigRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationConfigRuleReference {
        private final java.lang.String organizationConfigRuleId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.organizationConfigRuleId = software.amazon.jsii.Kernel.get(this, "organizationConfigRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.organizationConfigRuleId = java.util.Objects.requireNonNull(builder.organizationConfigRuleId, "organizationConfigRuleId is required");
        }

        @Override
        public final java.lang.String getOrganizationConfigRuleId() {
            return this.organizationConfigRuleId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("organizationConfigRuleId", om.valueToTree(this.getOrganizationConfigRuleId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.OrganizationConfigRuleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OrganizationConfigRuleReference.Jsii$Proxy that = (OrganizationConfigRuleReference.Jsii$Proxy) o;

            return this.organizationConfigRuleId.equals(that.organizationConfigRuleId);
        }

        @Override
        public final int hashCode() {
            int result = this.organizationConfigRuleId.hashCode();
            return result;
        }
    }
}
