package software.amazon.awscdk.services.connectcampaignsv2;

/**
 * A reference to a Campaign resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaignsv2.*;
 * CampaignReference campaignReference = CampaignReference.builder()
 *         .campaignArn("campaignArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.634Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CampaignReference")
@software.amazon.jsii.Jsii.Proxy(CampaignReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CampaignReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the Campaign resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCampaignArn();

    /**
     * @return a {@link Builder} of {@link CampaignReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CampaignReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CampaignReference> {
        java.lang.String campaignArn;

        /**
         * Sets the value of {@link CampaignReference#getCampaignArn}
         * @param campaignArn The Arn of the Campaign resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignArn(java.lang.String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CampaignReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CampaignReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CampaignReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignReference {
        private final java.lang.String campaignArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.campaignArn = software.amazon.jsii.Kernel.get(this, "campaignArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.campaignArn = java.util.Objects.requireNonNull(builder.campaignArn, "campaignArn is required");
        }

        @Override
        public final java.lang.String getCampaignArn() {
            return this.campaignArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("campaignArn", om.valueToTree(this.getCampaignArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CampaignReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CampaignReference.Jsii$Proxy that = (CampaignReference.Jsii$Proxy) o;

            return this.campaignArn.equals(that.campaignArn);
        }

        @Override
        public final int hashCode() {
            int result = this.campaignArn.hashCode();
            return result;
        }
    }
}
