package software.amazon.awscdk.services.connectcampaignsv2;

/**
 * Properties for defining a <code>CfnCampaign</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaignsv2.*;
 * Object agentlessConfig;
 * CfnCampaignProps cfnCampaignProps = CfnCampaignProps.builder()
 *         .channelSubtypeConfig(ChannelSubtypeConfigProperty.builder()
 *                 .email(EmailChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(EmailOutboundConfigProperty.builder()
 *                                 .connectSourceEmailAddress("connectSourceEmailAddress")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 // the properties below are optional
 *                                 .sourceEmailAddressDisplayName("sourceEmailAddressDisplayName")
 *                                 .build())
 *                         .outboundMode(EmailOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .sms(SmsChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(SmsOutboundConfigProperty.builder()
 *                                 .connectSourcePhoneNumberArn("connectSourcePhoneNumberArn")
 *                                 .wisdomTemplateArn("wisdomTemplateArn")
 *                                 .build())
 *                         .outboundMode(SmsOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .build())
 *                 .telephony(TelephonyChannelSubtypeConfigProperty.builder()
 *                         .defaultOutboundConfig(TelephonyOutboundConfigProperty.builder()
 *                                 .connectContactFlowId("connectContactFlowId")
 *                                 // the properties below are optional
 *                                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
 *                                         .enableAnswerMachineDetection(false)
 *                                         // the properties below are optional
 *                                         .awaitAnswerMachinePrompt(false)
 *                                         .build())
 *                                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                                 .build())
 *                         .outboundMode(TelephonyOutboundModeProperty.builder()
 *                                 .agentlessConfig(agentlessConfig)
 *                                 .predictiveConfig(PredictiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .previewConfig(PreviewConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .timeoutConfig(TimeoutConfigProperty.builder()
 *                                                 .durationInSeconds(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .agentActions(List.of("agentActions"))
 *                                         .build())
 *                                 .progressiveConfig(ProgressiveConfigProperty.builder()
 *                                         .bandwidthAllocation(123)
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .capacity(123)
 *                         .connectQueueId("connectQueueId")
 *                         .build())
 *                 .build())
 *         .connectInstanceId("connectInstanceId")
 *         .name("name")
 *         // the properties below are optional
 *         .communicationLimitsOverride(CommunicationLimitsConfigProperty.builder()
 *                 .allChannelsSubtypes(CommunicationLimitsProperty.builder()
 *                         .communicationLimitList(List.of(CommunicationLimitProperty.builder()
 *                                 .frequency(123)
 *                                 .maxCountPerRecipient(123)
 *                                 .unit("unit")
 *                                 .build()))
 *                         .build())
 *                 .instanceLimitsHandling("instanceLimitsHandling")
 *                 .build())
 *         .communicationTimeConfig(CommunicationTimeConfigProperty.builder()
 *                 .localTimeZoneConfig(LocalTimeZoneConfigProperty.builder()
 *                         .defaultTimeZone("defaultTimeZone")
 *                         .localTimeZoneDetection(List.of("localTimeZoneDetection"))
 *                         .build())
 *                 // the properties below are optional
 *                 .email(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .sms(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .telephony(TimeWindowProperty.builder()
 *                         .openHours(OpenHoursProperty.builder()
 *                                 .dailyHours(List.of(DailyHourProperty.builder()
 *                                         .key("key")
 *                                         .value(List.of(TimeRangeProperty.builder()
 *                                                 .endTime("endTime")
 *                                                 .startTime("startTime")
 *                                                 .build()))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .restrictedPeriods(RestrictedPeriodsProperty.builder()
 *                                 .restrictedPeriodList(List.of(RestrictedPeriodProperty.builder()
 *                                         .endDate("endDate")
 *                                         .startDate("startDate")
 *                                         // the properties below are optional
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .connectCampaignFlowArn("connectCampaignFlowArn")
 *         .schedule(ScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .startTime("startTime")
 *                 // the properties below are optional
 *                 .refreshFrequency("refreshFrequency")
 *                 .build())
 *         .source(SourceProperty.builder()
 *                 .customerProfilesSegmentArn("customerProfilesSegmentArn")
 *                 .eventTrigger(EventTriggerProperty.builder()
 *                         .customerProfilesDomainArn("customerProfilesDomainArn")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.660Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaignsv2.CfnCampaignProps")
@software.amazon.jsii.Jsii.Proxy(CfnCampaignProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCampaignProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains channel subtype configuration for an outbound campaign.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-channelsubtypeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getChannelSubtypeConfig();

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * You can find the <code>instanceId</code> in the ARN of the instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectinstanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceId();

    /**
     * The name of the outbound campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Communication limits configuration for an outbound campaign.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationlimitsoverride</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationLimitsOverride() {
        return null;
    }

    /**
     * Contains communication time configuration for an outbound campaign.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-communicationtimeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCommunicationTimeConfig() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-connectcampaignflowarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectCampaignFlowArn() {
        return null;
    }

    /**
     * Contains the schedule configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * Contains source configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-source</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaignsv2-campaign.html#cfn-connectcampaignsv2-campaign-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCampaignProps> {
        java.lang.Object channelSubtypeConfig;
        java.lang.String connectInstanceId;
        java.lang.String name;
        java.lang.Object communicationLimitsOverride;
        java.lang.Object communicationTimeConfig;
        java.lang.String connectCampaignFlowArn;
        java.lang.Object schedule;
        java.lang.Object source;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCampaignProps#getChannelSubtypeConfig}
         * @param channelSubtypeConfig Contains channel subtype configuration for an outbound campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(software.amazon.awscdk.IResolvable channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getChannelSubtypeConfig}
         * @param channelSubtypeConfig Contains channel subtype configuration for an outbound campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtypeConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ChannelSubtypeConfigProperty channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getConnectInstanceId}
         * @param connectInstanceId The identifier of the Amazon Connect instance. This parameter is required.
         *                          You can find the <code>instanceId</code> in the ARN of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceId(java.lang.String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getName}
         * @param name The name of the outbound campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCommunicationLimitsOverride}
         * @param communicationLimitsOverride Communication limits configuration for an outbound campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(software.amazon.awscdk.IResolvable communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCommunicationLimitsOverride}
         * @param communicationLimitsOverride Communication limits configuration for an outbound campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationLimitsOverride(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationLimitsConfigProperty communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCommunicationTimeConfig}
         * @param communicationTimeConfig Contains communication time configuration for an outbound campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(software.amazon.awscdk.IResolvable communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCommunicationTimeConfig}
         * @param communicationTimeConfig Contains communication time configuration for an outbound campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder communicationTimeConfig(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.CommunicationTimeConfigProperty communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getConnectCampaignFlowArn}
         * @param connectCampaignFlowArn The Amazon Resource Name (ARN) of the Amazon Connect campaign flow associated with the outbound campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectCampaignFlowArn(java.lang.String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSchedule}
         * @param schedule Contains the schedule configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSchedule}
         * @param schedule Contains the schedule configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSource}
         * @param source Contains source configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.IResolvable source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSource}
         * @param source Contains source configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.connectcampaignsv2.CfnCampaign.SourceProperty source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCampaignProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCampaignProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCampaignProps {
        private final java.lang.Object channelSubtypeConfig;
        private final java.lang.String connectInstanceId;
        private final java.lang.String name;
        private final java.lang.Object communicationLimitsOverride;
        private final java.lang.Object communicationTimeConfig;
        private final java.lang.String connectCampaignFlowArn;
        private final java.lang.Object schedule;
        private final java.lang.Object source;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelSubtypeConfig = software.amazon.jsii.Kernel.get(this, "channelSubtypeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectInstanceId = software.amazon.jsii.Kernel.get(this, "connectInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.communicationLimitsOverride = software.amazon.jsii.Kernel.get(this, "communicationLimitsOverride", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.communicationTimeConfig = software.amazon.jsii.Kernel.get(this, "communicationTimeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectCampaignFlowArn = software.amazon.jsii.Kernel.get(this, "connectCampaignFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelSubtypeConfig = java.util.Objects.requireNonNull(builder.channelSubtypeConfig, "channelSubtypeConfig is required");
            this.connectInstanceId = java.util.Objects.requireNonNull(builder.connectInstanceId, "connectInstanceId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.communicationLimitsOverride = builder.communicationLimitsOverride;
            this.communicationTimeConfig = builder.communicationTimeConfig;
            this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
            this.schedule = builder.schedule;
            this.source = builder.source;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getChannelSubtypeConfig() {
            return this.channelSubtypeConfig;
        }

        @Override
        public final java.lang.String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getCommunicationLimitsOverride() {
            return this.communicationLimitsOverride;
        }

        @Override
        public final java.lang.Object getCommunicationTimeConfig() {
            return this.communicationTimeConfig;
        }

        @Override
        public final java.lang.String getConnectCampaignFlowArn() {
            return this.connectCampaignFlowArn;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.Object getSource() {
            return this.source;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelSubtypeConfig", om.valueToTree(this.getChannelSubtypeConfig()));
            data.set("connectInstanceId", om.valueToTree(this.getConnectInstanceId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCommunicationLimitsOverride() != null) {
                data.set("communicationLimitsOverride", om.valueToTree(this.getCommunicationLimitsOverride()));
            }
            if (this.getCommunicationTimeConfig() != null) {
                data.set("communicationTimeConfig", om.valueToTree(this.getCommunicationTimeConfig()));
            }
            if (this.getConnectCampaignFlowArn() != null) {
                data.set("connectCampaignFlowArn", om.valueToTree(this.getConnectCampaignFlowArn()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaignsv2.CfnCampaignProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCampaignProps.Jsii$Proxy that = (CfnCampaignProps.Jsii$Proxy) o;

            if (!channelSubtypeConfig.equals(that.channelSubtypeConfig)) return false;
            if (!connectInstanceId.equals(that.connectInstanceId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.communicationLimitsOverride != null ? !this.communicationLimitsOverride.equals(that.communicationLimitsOverride) : that.communicationLimitsOverride != null) return false;
            if (this.communicationTimeConfig != null ? !this.communicationTimeConfig.equals(that.communicationTimeConfig) : that.communicationTimeConfig != null) return false;
            if (this.connectCampaignFlowArn != null ? !this.connectCampaignFlowArn.equals(that.connectCampaignFlowArn) : that.connectCampaignFlowArn != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelSubtypeConfig.hashCode();
            result = 31 * result + (this.connectInstanceId.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.communicationLimitsOverride != null ? this.communicationLimitsOverride.hashCode() : 0);
            result = 31 * result + (this.communicationTimeConfig != null ? this.communicationTimeConfig.hashCode() : 0);
            result = 31 * result + (this.connectCampaignFlowArn != null ? this.connectCampaignFlowArn.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
