package software.amazon.awscdk.services.databrew;

/**
 * A reference to a Ruleset resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * RulesetReference rulesetReference = RulesetReference.builder()
 *         .rulesetName("rulesetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.RulesetReference")
@software.amazon.jsii.Jsii.Proxy(RulesetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RulesetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the Ruleset resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRulesetName();

    /**
     * @return a {@link Builder} of {@link RulesetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RulesetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RulesetReference> {
        java.lang.String rulesetName;

        /**
         * Sets the value of {@link RulesetReference#getRulesetName}
         * @param rulesetName The Name of the Ruleset resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rulesetName(java.lang.String rulesetName) {
            this.rulesetName = rulesetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RulesetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RulesetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RulesetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RulesetReference {
        private final java.lang.String rulesetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rulesetName = software.amazon.jsii.Kernel.get(this, "rulesetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rulesetName = java.util.Objects.requireNonNull(builder.rulesetName, "rulesetName is required");
        }

        @Override
        public final java.lang.String getRulesetName() {
            return this.rulesetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rulesetName", om.valueToTree(this.getRulesetName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.RulesetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RulesetReference.Jsii$Proxy that = (RulesetReference.Jsii$Proxy) o;

            return this.rulesetName.equals(that.rulesetName);
        }

        @Override
        public final int hashCode() {
            int result = this.rulesetName.hashCode();
            return result;
        }
    }
}
