package software.amazon.awscdk.services.datazone;

/**
 * Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment blueprint configurations, or environment profiles.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * Object allDomainUnitsGrantFilter;
 * Object allUsersGrantFilter;
 * Object createEnvironment;
 * Object createEnvironmentFromBlueprint;
 * Object delegateCreateEnvironmentProfile;
 * CfnPolicyGrant cfnPolicyGrant = CfnPolicyGrant.Builder.create(this, "MyCfnPolicyGrant")
 *         .domainIdentifier("domainIdentifier")
 *         .entityIdentifier("entityIdentifier")
 *         .entityType("entityType")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .detail(PolicyGrantDetailProperty.builder()
 *                 .addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createAssetType(CreateAssetTypePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createDomainUnit(CreateDomainUnitPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createEnvironment(createEnvironment)
 *                 .createEnvironmentFromBlueprint(createEnvironmentFromBlueprint)
 *                 .createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetailProperty.builder()
 *                         .domainUnitId("domainUnitId")
 *                         .build())
 *                 .createFormType(CreateFormTypePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createGlossary(CreateGlossaryPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createProject(CreateProjectPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createProjectFromProjectProfile(CreateProjectFromProjectProfilePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .projectProfiles(List.of("projectProfiles"))
 *                         .build())
 *                 .delegateCreateEnvironmentProfile(delegateCreateEnvironmentProfile)
 *                 .overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .build())
 *         .principal(PolicyGrantPrincipalProperty.builder()
 *                 .domainUnit(DomainUnitPolicyGrantPrincipalProperty.builder()
 *                         .domainUnitDesignation("domainUnitDesignation")
 *                         .domainUnitGrantFilter(DomainUnitGrantFilterProperty.builder()
 *                                 .allDomainUnitsGrantFilter(allDomainUnitsGrantFilter)
 *                                 .build())
 *                         .domainUnitIdentifier("domainUnitIdentifier")
 *                         .build())
 *                 .group(GroupPolicyGrantPrincipalProperty.builder()
 *                         .groupIdentifier("groupIdentifier")
 *                         .build())
 *                 .project(ProjectPolicyGrantPrincipalProperty.builder()
 *                         .projectDesignation("projectDesignation")
 *                         .projectGrantFilter(ProjectGrantFilterProperty.builder()
 *                                 .domainUnitFilter(DomainUnitFilterForProjectProperty.builder()
 *                                         .domainUnit("domainUnit")
 *                                         // the properties below are optional
 *                                         .includeChildDomainUnits(false)
 *                                         .build())
 *                                 .build())
 *                         .projectIdentifier("projectIdentifier")
 *                         .build())
 *                 .user(UserPolicyGrantPrincipalProperty.builder()
 *                         .allUsersGrantFilter(allUsersGrantFilter)
 *                         .userIdentifier("userIdentifier")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.990Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant")
public class CfnPolicyGrant extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.datazone.IPolicyGrantRef {

    protected CfnPolicyGrant(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPolicyGrant(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datazone.CfnPolicyGrant.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPolicyGrant(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datazone.CfnPolicyGrantProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Specifies the timestamp at which policy grant member was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the user who created the policy grant member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedBy() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the policy grant returned by the AddPolicyGrant API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGrantId() {
        return software.amazon.jsii.Kernel.get(this, "attrGrantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a PolicyGrant resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datazone.PolicyGrantReference getPolicyGrantRef() {
        return software.amazon.jsii.Kernel.get(this, "policyGrantRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.datazone.PolicyGrantReference.class));
    }

    /**
     * The ID of the domain where you want to add a policy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the domain where you want to add a policy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIdentifier", java.util.Objects.requireNonNull(value, "domainIdentifier is required"));
    }

    /**
     * The ID of the entity (resource) to which you want to add a policy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEntityIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "entityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the entity (resource) to which you want to add a policy grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entityIdentifier", java.util.Objects.requireNonNull(value, "entityIdentifier is required"));
    }

    /**
     * The type of entity (resource) to which the grant is added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEntityType() {
        return software.amazon.jsii.Kernel.get(this, "entityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of entity (resource) to which the grant is added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entityType", java.util.Objects.requireNonNull(value, "entityType is required"));
    }

    /**
     * The type of policy that you want to grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyType() {
        return software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of policy that you want to grant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyType", java.util.Objects.requireNonNull(value, "policyType is required"));
    }

    /**
     * The details of the policy grant member.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantDetailProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDetail() {
        return software.amazon.jsii.Kernel.get(this, "detail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the policy grant member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "detail", value);
    }

    /**
     * The details of the policy grant member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDetail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantDetailProperty value) {
        software.amazon.jsii.Kernel.set(this, "detail", value);
    }

    /**
     * The principal of the policy grant member.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The principal of the policy grant member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "principal", value);
    }

    /**
     * The principal of the policy grant member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty value) {
        software.amazon.jsii.Kernel.set(this, "principal", value);
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * AddToProjectMemberPoolPolicyGrantDetailProperty addToProjectMemberPoolPolicyGrantDetailProperty = AddToProjectMemberPoolPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.AddToProjectMemberPoolPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(AddToProjectMemberPoolPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddToProjectMemberPoolPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail.html#cfn-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail.html#cfn-datazone-policygrant-addtoprojectmemberpoolpolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddToProjectMemberPoolPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddToProjectMemberPoolPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddToProjectMemberPoolPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link AddToProjectMemberPoolPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link AddToProjectMemberPoolPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddToProjectMemberPoolPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddToProjectMemberPoolPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddToProjectMemberPoolPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddToProjectMemberPoolPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.AddToProjectMemberPoolPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddToProjectMemberPoolPolicyGrantDetailProperty.Jsii$Proxy that = (AddToProjectMemberPoolPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateAssetTypePolicyGrantDetailProperty createAssetTypePolicyGrantDetailProperty = CreateAssetTypePolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createassettypepolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createassettypepolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateAssetTypePolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateAssetTypePolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateAssetTypePolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createassettypepolicygrantdetail.html#cfn-datazone-policygrant-createassettypepolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createassettypepolicygrantdetail.html#cfn-datazone-policygrant-createassettypepolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateAssetTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateAssetTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateAssetTypePolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link CreateAssetTypePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateAssetTypePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateAssetTypePolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateAssetTypePolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateAssetTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateAssetTypePolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateAssetTypePolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateAssetTypePolicyGrantDetailProperty.Jsii$Proxy that = (CreateAssetTypePolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateDomainUnitPolicyGrantDetailProperty createDomainUnitPolicyGrantDetailProperty = CreateDomainUnitPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createdomainunitpolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createdomainunitpolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateDomainUnitPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateDomainUnitPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateDomainUnitPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createdomainunitpolicygrantdetail.html#cfn-datazone-policygrant-createdomainunitpolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createdomainunitpolicygrantdetail.html#cfn-datazone-policygrant-createdomainunitpolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateDomainUnitPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateDomainUnitPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateDomainUnitPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link CreateDomainUnitPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateDomainUnitPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateDomainUnitPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateDomainUnitPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateDomainUnitPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateDomainUnitPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateDomainUnitPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateDomainUnitPolicyGrantDetailProperty.Jsii$Proxy that = (CreateDomainUnitPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateEnvironmentProfilePolicyGrantDetailProperty createEnvironmentProfilePolicyGrantDetailProperty = CreateEnvironmentProfilePolicyGrantDetailProperty.builder()
     *         .domainUnitId("domainUnitId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createenvironmentprofilepolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createenvironmentprofilepolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateEnvironmentProfilePolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateEnvironmentProfilePolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateEnvironmentProfilePolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the domain unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createenvironmentprofilepolicygrantdetail.html#cfn-datazone-policygrant-createenvironmentprofilepolicygrantdetail-domainunitid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createenvironmentprofilepolicygrantdetail.html#cfn-datazone-policygrant-createenvironmentprofilepolicygrantdetail-domainunitid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainUnitId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateEnvironmentProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateEnvironmentProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateEnvironmentProfilePolicyGrantDetailProperty> {
            java.lang.String domainUnitId;

            /**
             * Sets the value of {@link CreateEnvironmentProfilePolicyGrantDetailProperty#getDomainUnitId}
             * @param domainUnitId The ID of the domain unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitId(java.lang.String domainUnitId) {
                this.domainUnitId = domainUnitId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateEnvironmentProfilePolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateEnvironmentProfilePolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateEnvironmentProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateEnvironmentProfilePolicyGrantDetailProperty {
            private final java.lang.String domainUnitId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainUnitId = software.amazon.jsii.Kernel.get(this, "domainUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainUnitId = builder.domainUnitId;
            }

            @Override
            public final java.lang.String getDomainUnitId() {
                return this.domainUnitId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainUnitId() != null) {
                    data.set("domainUnitId", om.valueToTree(this.getDomainUnitId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateEnvironmentProfilePolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateEnvironmentProfilePolicyGrantDetailProperty.Jsii$Proxy that = (CreateEnvironmentProfilePolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.domainUnitId != null ? this.domainUnitId.equals(that.domainUnitId) : that.domainUnitId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainUnitId != null ? this.domainUnitId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateFormTypePolicyGrantDetailProperty createFormTypePolicyGrantDetailProperty = CreateFormTypePolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createformtypepolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createformtypepolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateFormTypePolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateFormTypePolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateFormTypePolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createformtypepolicygrantdetail.html#cfn-datazone-policygrant-createformtypepolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createformtypepolicygrantdetail.html#cfn-datazone-policygrant-createformtypepolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateFormTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateFormTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateFormTypePolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link CreateFormTypePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateFormTypePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateFormTypePolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateFormTypePolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateFormTypePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateFormTypePolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateFormTypePolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateFormTypePolicyGrantDetailProperty.Jsii$Proxy that = (CreateFormTypePolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateGlossaryPolicyGrantDetailProperty createGlossaryPolicyGrantDetailProperty = CreateGlossaryPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createglossarypolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createglossarypolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateGlossaryPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateGlossaryPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateGlossaryPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createglossarypolicygrantdetail.html#cfn-datazone-policygrant-createglossarypolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createglossarypolicygrantdetail.html#cfn-datazone-policygrant-createglossarypolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateGlossaryPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateGlossaryPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateGlossaryPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link CreateGlossaryPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateGlossaryPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateGlossaryPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateGlossaryPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateGlossaryPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateGlossaryPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateGlossaryPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateGlossaryPolicyGrantDetailProperty.Jsii$Proxy that = (CreateGlossaryPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies whether to create a project from project profile policy grant details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateProjectFromProjectProfilePolicyGrantDetailProperty createProjectFromProjectProfilePolicyGrantDetailProperty = CreateProjectFromProjectProfilePolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .projectProfiles(List.of("projectProfiles"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateProjectFromProjectProfilePolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateProjectFromProjectProfilePolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateProjectFromProjectProfilePolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to include child domain units when creating a project from project profile policy grant details.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html#cfn-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html#cfn-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * Specifies project profiles when creating a project from project profile policy grant details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html#cfn-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail-projectprofiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail.html#cfn-datazone-policygrant-createprojectfromprojectprofilepolicygrantdetail-projectprofiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProjectProfiles() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateProjectFromProjectProfilePolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;
            java.util.List<java.lang.String> projectProfiles;

            /**
             * Sets the value of {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether to include child domain units when creating a project from project profile policy grant details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether to include child domain units when creating a project from project profile policy grant details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty#getProjectProfiles}
             * @param projectProfiles Specifies project profiles when creating a project from project profile policy grant details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectProfiles(java.util.List<java.lang.String> projectProfiles) {
                this.projectProfiles = projectProfiles;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateProjectFromProjectProfilePolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateProjectFromProjectProfilePolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateProjectFromProjectProfilePolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;
            private final java.util.List<java.lang.String> projectProfiles;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projectProfiles = software.amazon.jsii.Kernel.get(this, "projectProfiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
                this.projectProfiles = builder.projectProfiles;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            public final java.util.List<java.lang.String> getProjectProfiles() {
                return this.projectProfiles;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }
                if (this.getProjectProfiles() != null) {
                    data.set("projectProfiles", om.valueToTree(this.getProjectProfiles()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateProjectFromProjectProfilePolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateProjectFromProjectProfilePolicyGrantDetailProperty.Jsii$Proxy that = (CreateProjectFromProjectProfilePolicyGrantDetailProperty.Jsii$Proxy) o;

                if (this.includeChildDomainUnits != null ? !this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits != null) return false;
                return this.projectProfiles != null ? this.projectProfiles.equals(that.projectProfiles) : that.projectProfiles == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                result = 31 * result + (this.projectProfiles != null ? this.projectProfiles.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * CreateProjectPolicyGrantDetailProperty createProjectPolicyGrantDetailProperty = CreateProjectPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectpolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectpolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateProjectPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateProjectPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateProjectPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy grant is applied to child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectpolicygrantdetail.html#cfn-datazone-policygrant-createprojectpolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-createprojectpolicygrantdetail.html#cfn-datazone-policygrant-createprojectpolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateProjectPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateProjectPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateProjectPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link CreateProjectPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link CreateProjectPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy grant is applied to child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateProjectPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateProjectPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateProjectPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateProjectPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.CreateProjectPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateProjectPolicyGrantDetailProperty.Jsii$Proxy that = (CreateProjectPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The domain unit filter of the project grant filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * DomainUnitFilterForProjectProperty domainUnitFilterForProjectProperty = DomainUnitFilterForProjectProperty.builder()
     *         .domainUnit("domainUnit")
     *         // the properties below are optional
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitFilterForProjectProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainUnitFilterForProjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainUnitFilterForProjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain unit ID to use in the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html#cfn-datazone-policygrant-domainunitfilterforproject-domainunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html#cfn-datazone-policygrant-domainunitfilterforproject-domainunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainUnit();

        /**
         * Specifies whether to include child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html#cfn-datazone-policygrant-domainunitfilterforproject-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitfilterforproject.html#cfn-datazone-policygrant-domainunitfilterforproject-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainUnitFilterForProjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainUnitFilterForProjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainUnitFilterForProjectProperty> {
            java.lang.String domainUnit;
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link DomainUnitFilterForProjectProperty#getDomainUnit}
             * @param domainUnit The domain unit ID to use in the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnit(java.lang.String domainUnit) {
                this.domainUnit = domainUnit;
                return this;
            }

            /**
             * Sets the value of {@link DomainUnitFilterForProjectProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether to include child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link DomainUnitFilterForProjectProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether to include child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainUnitFilterForProjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainUnitFilterForProjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainUnitFilterForProjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainUnitFilterForProjectProperty {
            private final java.lang.String domainUnit;
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainUnit = software.amazon.jsii.Kernel.get(this, "domainUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainUnit = java.util.Objects.requireNonNull(builder.domainUnit, "domainUnit is required");
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.String getDomainUnit() {
                return this.domainUnit;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainUnit", om.valueToTree(this.getDomainUnit()));
                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitFilterForProjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainUnitFilterForProjectProperty.Jsii$Proxy that = (DomainUnitFilterForProjectProperty.Jsii$Proxy) o;

                if (!domainUnit.equals(that.domainUnit)) return false;
                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainUnit.hashCode();
                result = 31 * result + (this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The grant filter for the domain unit.
     * <p>
     * In the current release of Amazon DataZone, the only supported filter is the <code>allDomainUnitsGrantFilter</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * Object allDomainUnitsGrantFilter;
     * DomainUnitGrantFilterProperty domainUnitGrantFilterProperty = DomainUnitGrantFilterProperty.builder()
     *         .allDomainUnitsGrantFilter(allDomainUnitsGrantFilter)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitgrantfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitgrantfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitGrantFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainUnitGrantFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainUnitGrantFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a grant filter containing all domain units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitgrantfilter.html#cfn-datazone-policygrant-domainunitgrantfilter-alldomainunitsgrantfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitgrantfilter.html#cfn-datazone-policygrant-domainunitgrantfilter-alldomainunitsgrantfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllDomainUnitsGrantFilter();

        /**
         * @return a {@link Builder} of {@link DomainUnitGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainUnitGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainUnitGrantFilterProperty> {
            java.lang.Object allDomainUnitsGrantFilter;

            /**
             * Sets the value of {@link DomainUnitGrantFilterProperty#getAllDomainUnitsGrantFilter}
             * @param allDomainUnitsGrantFilter Specifies a grant filter containing all domain units. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allDomainUnitsGrantFilter(java.lang.Object allDomainUnitsGrantFilter) {
                this.allDomainUnitsGrantFilter = allDomainUnitsGrantFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainUnitGrantFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainUnitGrantFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainUnitGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainUnitGrantFilterProperty {
            private final java.lang.Object allDomainUnitsGrantFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allDomainUnitsGrantFilter = software.amazon.jsii.Kernel.get(this, "allDomainUnitsGrantFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allDomainUnitsGrantFilter = java.util.Objects.requireNonNull(builder.allDomainUnitsGrantFilter, "allDomainUnitsGrantFilter is required");
            }

            @Override
            public final java.lang.Object getAllDomainUnitsGrantFilter() {
                return this.allDomainUnitsGrantFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allDomainUnitsGrantFilter", om.valueToTree(this.getAllDomainUnitsGrantFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitGrantFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainUnitGrantFilterProperty.Jsii$Proxy that = (DomainUnitGrantFilterProperty.Jsii$Proxy) o;

                return this.allDomainUnitsGrantFilter.equals(that.allDomainUnitsGrantFilter);
            }

            @Override
            public final int hashCode() {
                int result = this.allDomainUnitsGrantFilter.hashCode();
                return result;
            }
        }
    }
    /**
     * The domain unit principal to whom the policy is granted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * Object allDomainUnitsGrantFilter;
     * DomainUnitPolicyGrantPrincipalProperty domainUnitPolicyGrantPrincipalProperty = DomainUnitPolicyGrantPrincipalProperty.builder()
     *         .domainUnitDesignation("domainUnitDesignation")
     *         .domainUnitGrantFilter(DomainUnitGrantFilterProperty.builder()
     *                 .allDomainUnitsGrantFilter(allDomainUnitsGrantFilter)
     *                 .build())
     *         .domainUnitIdentifier("domainUnitIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitPolicyGrantPrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainUnitPolicyGrantPrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainUnitPolicyGrantPrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifes the designation of the domain unit users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitdesignation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitdesignation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainUnitDesignation() {
            return null;
        }

        /**
         * The grant filter for the domain unit.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitGrantFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitgrantfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitgrantfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDomainUnitGrantFilter() {
            return null;
        }

        /**
         * The ID of the domain unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-domainunitpolicygrantprincipal.html#cfn-datazone-policygrant-domainunitpolicygrantprincipal-domainunitidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainUnitIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainUnitPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainUnitPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainUnitPolicyGrantPrincipalProperty> {
            java.lang.String domainUnitDesignation;
            java.lang.Object domainUnitGrantFilter;
            java.lang.String domainUnitIdentifier;

            /**
             * Sets the value of {@link DomainUnitPolicyGrantPrincipalProperty#getDomainUnitDesignation}
             * @param domainUnitDesignation Specifes the designation of the domain unit users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitDesignation(java.lang.String domainUnitDesignation) {
                this.domainUnitDesignation = domainUnitDesignation;
                return this;
            }

            /**
             * Sets the value of {@link DomainUnitPolicyGrantPrincipalProperty#getDomainUnitGrantFilter}
             * @param domainUnitGrantFilter The grant filter for the domain unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitGrantFilter(software.amazon.awscdk.IResolvable domainUnitGrantFilter) {
                this.domainUnitGrantFilter = domainUnitGrantFilter;
                return this;
            }

            /**
             * Sets the value of {@link DomainUnitPolicyGrantPrincipalProperty#getDomainUnitGrantFilter}
             * @param domainUnitGrantFilter The grant filter for the domain unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitGrantFilter(software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitGrantFilterProperty domainUnitGrantFilter) {
                this.domainUnitGrantFilter = domainUnitGrantFilter;
                return this;
            }

            /**
             * Sets the value of {@link DomainUnitPolicyGrantPrincipalProperty#getDomainUnitIdentifier}
             * @param domainUnitIdentifier The ID of the domain unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitIdentifier(java.lang.String domainUnitIdentifier) {
                this.domainUnitIdentifier = domainUnitIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainUnitPolicyGrantPrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainUnitPolicyGrantPrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainUnitPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainUnitPolicyGrantPrincipalProperty {
            private final java.lang.String domainUnitDesignation;
            private final java.lang.Object domainUnitGrantFilter;
            private final java.lang.String domainUnitIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainUnitDesignation = software.amazon.jsii.Kernel.get(this, "domainUnitDesignation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainUnitGrantFilter = software.amazon.jsii.Kernel.get(this, "domainUnitGrantFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.domainUnitIdentifier = software.amazon.jsii.Kernel.get(this, "domainUnitIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainUnitDesignation = builder.domainUnitDesignation;
                this.domainUnitGrantFilter = builder.domainUnitGrantFilter;
                this.domainUnitIdentifier = builder.domainUnitIdentifier;
            }

            @Override
            public final java.lang.String getDomainUnitDesignation() {
                return this.domainUnitDesignation;
            }

            @Override
            public final java.lang.Object getDomainUnitGrantFilter() {
                return this.domainUnitGrantFilter;
            }

            @Override
            public final java.lang.String getDomainUnitIdentifier() {
                return this.domainUnitIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainUnitDesignation() != null) {
                    data.set("domainUnitDesignation", om.valueToTree(this.getDomainUnitDesignation()));
                }
                if (this.getDomainUnitGrantFilter() != null) {
                    data.set("domainUnitGrantFilter", om.valueToTree(this.getDomainUnitGrantFilter()));
                }
                if (this.getDomainUnitIdentifier() != null) {
                    data.set("domainUnitIdentifier", om.valueToTree(this.getDomainUnitIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.DomainUnitPolicyGrantPrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainUnitPolicyGrantPrincipalProperty.Jsii$Proxy that = (DomainUnitPolicyGrantPrincipalProperty.Jsii$Proxy) o;

                if (this.domainUnitDesignation != null ? !this.domainUnitDesignation.equals(that.domainUnitDesignation) : that.domainUnitDesignation != null) return false;
                if (this.domainUnitGrantFilter != null ? !this.domainUnitGrantFilter.equals(that.domainUnitGrantFilter) : that.domainUnitGrantFilter != null) return false;
                return this.domainUnitIdentifier != null ? this.domainUnitIdentifier.equals(that.domainUnitIdentifier) : that.domainUnitIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainUnitDesignation != null ? this.domainUnitDesignation.hashCode() : 0;
                result = 31 * result + (this.domainUnitGrantFilter != null ? this.domainUnitGrantFilter.hashCode() : 0);
                result = 31 * result + (this.domainUnitIdentifier != null ? this.domainUnitIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The group principal to whom the policy is granted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * GroupPolicyGrantPrincipalProperty groupPolicyGrantPrincipalProperty = GroupPolicyGrantPrincipalProperty.builder()
     *         .groupIdentifier("groupIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-grouppolicygrantprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-grouppolicygrantprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.GroupPolicyGrantPrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupPolicyGrantPrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupPolicyGrantPrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID Of the group of the group principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-grouppolicygrantprincipal.html#cfn-datazone-policygrant-grouppolicygrantprincipal-groupidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-grouppolicygrantprincipal.html#cfn-datazone-policygrant-grouppolicygrantprincipal-groupidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupIdentifier();

        /**
         * @return a {@link Builder} of {@link GroupPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupPolicyGrantPrincipalProperty> {
            java.lang.String groupIdentifier;

            /**
             * Sets the value of {@link GroupPolicyGrantPrincipalProperty#getGroupIdentifier}
             * @param groupIdentifier The ID Of the group of the group principal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupIdentifier(java.lang.String groupIdentifier) {
                this.groupIdentifier = groupIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupPolicyGrantPrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupPolicyGrantPrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupPolicyGrantPrincipalProperty {
            private final java.lang.String groupIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupIdentifier = software.amazon.jsii.Kernel.get(this, "groupIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupIdentifier = java.util.Objects.requireNonNull(builder.groupIdentifier, "groupIdentifier is required");
            }

            @Override
            public final java.lang.String getGroupIdentifier() {
                return this.groupIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupIdentifier", om.valueToTree(this.getGroupIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.GroupPolicyGrantPrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupPolicyGrantPrincipalProperty.Jsii$Proxy that = (GroupPolicyGrantPrincipalProperty.Jsii$Proxy) o;

                return this.groupIdentifier.equals(that.groupIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.groupIdentifier.hashCode();
                return result;
            }
        }
    }
    /**
     * The grant details of the override domain unit owners policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * OverrideDomainUnitOwnersPolicyGrantDetailProperty overrideDomainUnitOwnersPolicyGrantDetailProperty = OverrideDomainUnitOwnersPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overridedomainunitownerspolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overridedomainunitownerspolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.OverrideDomainUnitOwnersPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideDomainUnitOwnersPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideDomainUnitOwnersPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy is inherited by child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overridedomainunitownerspolicygrantdetail.html#cfn-datazone-policygrant-overridedomainunitownerspolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overridedomainunitownerspolicygrantdetail.html#cfn-datazone-policygrant-overridedomainunitownerspolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideDomainUnitOwnersPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy is inherited by child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy is inherited by child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideDomainUnitOwnersPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideDomainUnitOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideDomainUnitOwnersPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.OverrideDomainUnitOwnersPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideDomainUnitOwnersPolicyGrantDetailProperty.Jsii$Proxy that = (OverrideDomainUnitOwnersPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the override project owners policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * OverrideProjectOwnersPolicyGrantDetailProperty overrideProjectOwnersPolicyGrantDetailProperty = OverrideProjectOwnersPolicyGrantDetailProperty.builder()
     *         .includeChildDomainUnits(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overrideprojectownerspolicygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overrideprojectownerspolicygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.OverrideProjectOwnersPolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideProjectOwnersPolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideProjectOwnersPolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the policy is inherited by child domain units.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overrideprojectownerspolicygrantdetail.html#cfn-datazone-policygrant-overrideprojectownerspolicygrantdetail-includechilddomainunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-overrideprojectownerspolicygrantdetail.html#cfn-datazone-policygrant-overrideprojectownerspolicygrantdetail-includechilddomainunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeChildDomainUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideProjectOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideProjectOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideProjectOwnersPolicyGrantDetailProperty> {
            java.lang.Object includeChildDomainUnits;

            /**
             * Sets the value of {@link OverrideProjectOwnersPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy is inherited by child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(java.lang.Boolean includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Sets the value of {@link OverrideProjectOwnersPolicyGrantDetailProperty#getIncludeChildDomainUnits}
             * @param includeChildDomainUnits Specifies whether the policy is inherited by child domain units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeChildDomainUnits(software.amazon.awscdk.IResolvable includeChildDomainUnits) {
                this.includeChildDomainUnits = includeChildDomainUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideProjectOwnersPolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideProjectOwnersPolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideProjectOwnersPolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideProjectOwnersPolicyGrantDetailProperty {
            private final java.lang.Object includeChildDomainUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeChildDomainUnits = software.amazon.jsii.Kernel.get(this, "includeChildDomainUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeChildDomainUnits = builder.includeChildDomainUnits;
            }

            @Override
            public final java.lang.Object getIncludeChildDomainUnits() {
                return this.includeChildDomainUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeChildDomainUnits() != null) {
                    data.set("includeChildDomainUnits", om.valueToTree(this.getIncludeChildDomainUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.OverrideProjectOwnersPolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideProjectOwnersPolicyGrantDetailProperty.Jsii$Proxy that = (OverrideProjectOwnersPolicyGrantDetailProperty.Jsii$Proxy) o;

                return this.includeChildDomainUnits != null ? this.includeChildDomainUnits.equals(that.includeChildDomainUnits) : that.includeChildDomainUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeChildDomainUnits != null ? this.includeChildDomainUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the policy grant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * Object createEnvironment;
     * Object createEnvironmentFromBlueprint;
     * Object delegateCreateEnvironmentProfile;
     * PolicyGrantDetailProperty policyGrantDetailProperty = PolicyGrantDetailProperty.builder()
     *         .addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createAssetType(CreateAssetTypePolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createDomainUnit(CreateDomainUnitPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createEnvironment(createEnvironment)
     *         .createEnvironmentFromBlueprint(createEnvironmentFromBlueprint)
     *         .createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetailProperty.builder()
     *                 .domainUnitId("domainUnitId")
     *                 .build())
     *         .createFormType(CreateFormTypePolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createGlossary(CreateGlossaryPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createProject(CreateProjectPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .createProjectFromProjectProfile(CreateProjectFromProjectProfilePolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .projectProfiles(List.of("projectProfiles"))
     *                 .build())
     *         .delegateCreateEnvironmentProfile(delegateCreateEnvironmentProfile)
     *         .overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetailProperty.builder()
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.PolicyGrantDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyGrantDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyGrantDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies that the policy grant is to be added to the members of the project.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.AddToProjectMemberPoolPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-addtoprojectmemberpool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-addtoprojectmemberpool</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddToProjectMemberPool() {
            return null;
        }

        /**
         * Specifies that this is a create asset type policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateAssetTypePolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createassettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createassettype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateAssetType() {
            return null;
        }

        /**
         * Specifies that this is a create domain unit policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateDomainUnitPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createdomainunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createdomainunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateDomainUnit() {
            return null;
        }

        /**
         * Specifies that this is a create environment policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateEnvironment() {
            return null;
        }

        /**
         * The details of the policy of creating an environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironmentfromblueprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironmentfromblueprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateEnvironmentFromBlueprint() {
            return null;
        }

        /**
         * Specifies that this is a create environment profile policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateEnvironmentProfilePolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironmentprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createenvironmentprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateEnvironmentProfile() {
            return null;
        }

        /**
         * Specifies that this is a create form type policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateFormTypePolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createformtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createformtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateFormType() {
            return null;
        }

        /**
         * Specifies that this is a create glossary policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateGlossaryPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createglossary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createglossary</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateGlossary() {
            return null;
        }

        /**
         * Specifies that this is a create project policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateProjectPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createproject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createproject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateProject() {
            return null;
        }

        /**
         * Specifies whether to create a project from project profile.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateProjectFromProjectProfilePolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createprojectfromprojectprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-createprojectfromprojectprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateProjectFromProjectProfile() {
            return null;
        }

        /**
         * Specifies that this is the delegation of the create environment profile policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-delegatecreateenvironmentprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-delegatecreateenvironmentprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDelegateCreateEnvironmentProfile() {
            return null;
        }

        /**
         * Specifies whether to override domain unit owners.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.OverrideDomainUnitOwnersPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-overridedomainunitowners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-overridedomainunitowners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideDomainUnitOwners() {
            return null;
        }

        /**
         * Specifies whether to override project owners.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.OverrideProjectOwnersPolicyGrantDetailProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-overrideprojectowners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantdetail.html#cfn-datazone-policygrant-policygrantdetail-overrideprojectowners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideProjectOwners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyGrantDetailProperty> {
            java.lang.Object addToProjectMemberPool;
            java.lang.Object createAssetType;
            java.lang.Object createDomainUnit;
            java.lang.Object createEnvironment;
            java.lang.Object createEnvironmentFromBlueprint;
            java.lang.Object createEnvironmentProfile;
            java.lang.Object createFormType;
            java.lang.Object createGlossary;
            java.lang.Object createProject;
            java.lang.Object createProjectFromProjectProfile;
            java.lang.Object delegateCreateEnvironmentProfile;
            java.lang.Object overrideDomainUnitOwners;
            java.lang.Object overrideProjectOwners;

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getAddToProjectMemberPool}
             * @param addToProjectMemberPool Specifies that the policy grant is to be added to the members of the project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addToProjectMemberPool(software.amazon.awscdk.IResolvable addToProjectMemberPool) {
                this.addToProjectMemberPool = addToProjectMemberPool;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getAddToProjectMemberPool}
             * @param addToProjectMemberPool Specifies that the policy grant is to be added to the members of the project.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addToProjectMemberPool(software.amazon.awscdk.services.datazone.CfnPolicyGrant.AddToProjectMemberPoolPolicyGrantDetailProperty addToProjectMemberPool) {
                this.addToProjectMemberPool = addToProjectMemberPool;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateAssetType}
             * @param createAssetType Specifies that this is a create asset type policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAssetType(software.amazon.awscdk.IResolvable createAssetType) {
                this.createAssetType = createAssetType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateAssetType}
             * @param createAssetType Specifies that this is a create asset type policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createAssetType(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateAssetTypePolicyGrantDetailProperty createAssetType) {
                this.createAssetType = createAssetType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateDomainUnit}
             * @param createDomainUnit Specifies that this is a create domain unit policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createDomainUnit(software.amazon.awscdk.IResolvable createDomainUnit) {
                this.createDomainUnit = createDomainUnit;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateDomainUnit}
             * @param createDomainUnit Specifies that this is a create domain unit policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createDomainUnit(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateDomainUnitPolicyGrantDetailProperty createDomainUnit) {
                this.createDomainUnit = createDomainUnit;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateEnvironment}
             * @param createEnvironment Specifies that this is a create environment policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createEnvironment(java.lang.Object createEnvironment) {
                this.createEnvironment = createEnvironment;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateEnvironmentFromBlueprint}
             * @param createEnvironmentFromBlueprint The details of the policy of creating an environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createEnvironmentFromBlueprint(java.lang.Object createEnvironmentFromBlueprint) {
                this.createEnvironmentFromBlueprint = createEnvironmentFromBlueprint;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateEnvironmentProfile}
             * @param createEnvironmentProfile Specifies that this is a create environment profile policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createEnvironmentProfile(software.amazon.awscdk.IResolvable createEnvironmentProfile) {
                this.createEnvironmentProfile = createEnvironmentProfile;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateEnvironmentProfile}
             * @param createEnvironmentProfile Specifies that this is a create environment profile policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createEnvironmentProfile(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateEnvironmentProfilePolicyGrantDetailProperty createEnvironmentProfile) {
                this.createEnvironmentProfile = createEnvironmentProfile;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateFormType}
             * @param createFormType Specifies that this is a create form type policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createFormType(software.amazon.awscdk.IResolvable createFormType) {
                this.createFormType = createFormType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateFormType}
             * @param createFormType Specifies that this is a create form type policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createFormType(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateFormTypePolicyGrantDetailProperty createFormType) {
                this.createFormType = createFormType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateGlossary}
             * @param createGlossary Specifies that this is a create glossary policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createGlossary(software.amazon.awscdk.IResolvable createGlossary) {
                this.createGlossary = createGlossary;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateGlossary}
             * @param createGlossary Specifies that this is a create glossary policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createGlossary(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateGlossaryPolicyGrantDetailProperty createGlossary) {
                this.createGlossary = createGlossary;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateProject}
             * @param createProject Specifies that this is a create project policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createProject(software.amazon.awscdk.IResolvable createProject) {
                this.createProject = createProject;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateProject}
             * @param createProject Specifies that this is a create project policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createProject(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateProjectPolicyGrantDetailProperty createProject) {
                this.createProject = createProject;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateProjectFromProjectProfile}
             * @param createProjectFromProjectProfile Specifies whether to create a project from project profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createProjectFromProjectProfile(software.amazon.awscdk.IResolvable createProjectFromProjectProfile) {
                this.createProjectFromProjectProfile = createProjectFromProjectProfile;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getCreateProjectFromProjectProfile}
             * @param createProjectFromProjectProfile Specifies whether to create a project from project profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createProjectFromProjectProfile(software.amazon.awscdk.services.datazone.CfnPolicyGrant.CreateProjectFromProjectProfilePolicyGrantDetailProperty createProjectFromProjectProfile) {
                this.createProjectFromProjectProfile = createProjectFromProjectProfile;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getDelegateCreateEnvironmentProfile}
             * @param delegateCreateEnvironmentProfile Specifies that this is the delegation of the create environment profile policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delegateCreateEnvironmentProfile(java.lang.Object delegateCreateEnvironmentProfile) {
                this.delegateCreateEnvironmentProfile = delegateCreateEnvironmentProfile;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getOverrideDomainUnitOwners}
             * @param overrideDomainUnitOwners Specifies whether to override domain unit owners.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDomainUnitOwners(software.amazon.awscdk.IResolvable overrideDomainUnitOwners) {
                this.overrideDomainUnitOwners = overrideDomainUnitOwners;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getOverrideDomainUnitOwners}
             * @param overrideDomainUnitOwners Specifies whether to override domain unit owners.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDomainUnitOwners(software.amazon.awscdk.services.datazone.CfnPolicyGrant.OverrideDomainUnitOwnersPolicyGrantDetailProperty overrideDomainUnitOwners) {
                this.overrideDomainUnitOwners = overrideDomainUnitOwners;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getOverrideProjectOwners}
             * @param overrideProjectOwners Specifies whether to override project owners.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideProjectOwners(software.amazon.awscdk.IResolvable overrideProjectOwners) {
                this.overrideProjectOwners = overrideProjectOwners;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantDetailProperty#getOverrideProjectOwners}
             * @param overrideProjectOwners Specifies whether to override project owners.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideProjectOwners(software.amazon.awscdk.services.datazone.CfnPolicyGrant.OverrideProjectOwnersPolicyGrantDetailProperty overrideProjectOwners) {
                this.overrideProjectOwners = overrideProjectOwners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyGrantDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyGrantDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyGrantDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyGrantDetailProperty {
            private final java.lang.Object addToProjectMemberPool;
            private final java.lang.Object createAssetType;
            private final java.lang.Object createDomainUnit;
            private final java.lang.Object createEnvironment;
            private final java.lang.Object createEnvironmentFromBlueprint;
            private final java.lang.Object createEnvironmentProfile;
            private final java.lang.Object createFormType;
            private final java.lang.Object createGlossary;
            private final java.lang.Object createProject;
            private final java.lang.Object createProjectFromProjectProfile;
            private final java.lang.Object delegateCreateEnvironmentProfile;
            private final java.lang.Object overrideDomainUnitOwners;
            private final java.lang.Object overrideProjectOwners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addToProjectMemberPool = software.amazon.jsii.Kernel.get(this, "addToProjectMemberPool", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createAssetType = software.amazon.jsii.Kernel.get(this, "createAssetType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createDomainUnit = software.amazon.jsii.Kernel.get(this, "createDomainUnit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createEnvironment = software.amazon.jsii.Kernel.get(this, "createEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createEnvironmentFromBlueprint = software.amazon.jsii.Kernel.get(this, "createEnvironmentFromBlueprint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createEnvironmentProfile = software.amazon.jsii.Kernel.get(this, "createEnvironmentProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createFormType = software.amazon.jsii.Kernel.get(this, "createFormType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createGlossary = software.amazon.jsii.Kernel.get(this, "createGlossary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createProject = software.amazon.jsii.Kernel.get(this, "createProject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createProjectFromProjectProfile = software.amazon.jsii.Kernel.get(this, "createProjectFromProjectProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delegateCreateEnvironmentProfile = software.amazon.jsii.Kernel.get(this, "delegateCreateEnvironmentProfile", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrideDomainUnitOwners = software.amazon.jsii.Kernel.get(this, "overrideDomainUnitOwners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrideProjectOwners = software.amazon.jsii.Kernel.get(this, "overrideProjectOwners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addToProjectMemberPool = builder.addToProjectMemberPool;
                this.createAssetType = builder.createAssetType;
                this.createDomainUnit = builder.createDomainUnit;
                this.createEnvironment = builder.createEnvironment;
                this.createEnvironmentFromBlueprint = builder.createEnvironmentFromBlueprint;
                this.createEnvironmentProfile = builder.createEnvironmentProfile;
                this.createFormType = builder.createFormType;
                this.createGlossary = builder.createGlossary;
                this.createProject = builder.createProject;
                this.createProjectFromProjectProfile = builder.createProjectFromProjectProfile;
                this.delegateCreateEnvironmentProfile = builder.delegateCreateEnvironmentProfile;
                this.overrideDomainUnitOwners = builder.overrideDomainUnitOwners;
                this.overrideProjectOwners = builder.overrideProjectOwners;
            }

            @Override
            public final java.lang.Object getAddToProjectMemberPool() {
                return this.addToProjectMemberPool;
            }

            @Override
            public final java.lang.Object getCreateAssetType() {
                return this.createAssetType;
            }

            @Override
            public final java.lang.Object getCreateDomainUnit() {
                return this.createDomainUnit;
            }

            @Override
            public final java.lang.Object getCreateEnvironment() {
                return this.createEnvironment;
            }

            @Override
            public final java.lang.Object getCreateEnvironmentFromBlueprint() {
                return this.createEnvironmentFromBlueprint;
            }

            @Override
            public final java.lang.Object getCreateEnvironmentProfile() {
                return this.createEnvironmentProfile;
            }

            @Override
            public final java.lang.Object getCreateFormType() {
                return this.createFormType;
            }

            @Override
            public final java.lang.Object getCreateGlossary() {
                return this.createGlossary;
            }

            @Override
            public final java.lang.Object getCreateProject() {
                return this.createProject;
            }

            @Override
            public final java.lang.Object getCreateProjectFromProjectProfile() {
                return this.createProjectFromProjectProfile;
            }

            @Override
            public final java.lang.Object getDelegateCreateEnvironmentProfile() {
                return this.delegateCreateEnvironmentProfile;
            }

            @Override
            public final java.lang.Object getOverrideDomainUnitOwners() {
                return this.overrideDomainUnitOwners;
            }

            @Override
            public final java.lang.Object getOverrideProjectOwners() {
                return this.overrideProjectOwners;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddToProjectMemberPool() != null) {
                    data.set("addToProjectMemberPool", om.valueToTree(this.getAddToProjectMemberPool()));
                }
                if (this.getCreateAssetType() != null) {
                    data.set("createAssetType", om.valueToTree(this.getCreateAssetType()));
                }
                if (this.getCreateDomainUnit() != null) {
                    data.set("createDomainUnit", om.valueToTree(this.getCreateDomainUnit()));
                }
                if (this.getCreateEnvironment() != null) {
                    data.set("createEnvironment", om.valueToTree(this.getCreateEnvironment()));
                }
                if (this.getCreateEnvironmentFromBlueprint() != null) {
                    data.set("createEnvironmentFromBlueprint", om.valueToTree(this.getCreateEnvironmentFromBlueprint()));
                }
                if (this.getCreateEnvironmentProfile() != null) {
                    data.set("createEnvironmentProfile", om.valueToTree(this.getCreateEnvironmentProfile()));
                }
                if (this.getCreateFormType() != null) {
                    data.set("createFormType", om.valueToTree(this.getCreateFormType()));
                }
                if (this.getCreateGlossary() != null) {
                    data.set("createGlossary", om.valueToTree(this.getCreateGlossary()));
                }
                if (this.getCreateProject() != null) {
                    data.set("createProject", om.valueToTree(this.getCreateProject()));
                }
                if (this.getCreateProjectFromProjectProfile() != null) {
                    data.set("createProjectFromProjectProfile", om.valueToTree(this.getCreateProjectFromProjectProfile()));
                }
                if (this.getDelegateCreateEnvironmentProfile() != null) {
                    data.set("delegateCreateEnvironmentProfile", om.valueToTree(this.getDelegateCreateEnvironmentProfile()));
                }
                if (this.getOverrideDomainUnitOwners() != null) {
                    data.set("overrideDomainUnitOwners", om.valueToTree(this.getOverrideDomainUnitOwners()));
                }
                if (this.getOverrideProjectOwners() != null) {
                    data.set("overrideProjectOwners", om.valueToTree(this.getOverrideProjectOwners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.PolicyGrantDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyGrantDetailProperty.Jsii$Proxy that = (PolicyGrantDetailProperty.Jsii$Proxy) o;

                if (this.addToProjectMemberPool != null ? !this.addToProjectMemberPool.equals(that.addToProjectMemberPool) : that.addToProjectMemberPool != null) return false;
                if (this.createAssetType != null ? !this.createAssetType.equals(that.createAssetType) : that.createAssetType != null) return false;
                if (this.createDomainUnit != null ? !this.createDomainUnit.equals(that.createDomainUnit) : that.createDomainUnit != null) return false;
                if (this.createEnvironment != null ? !this.createEnvironment.equals(that.createEnvironment) : that.createEnvironment != null) return false;
                if (this.createEnvironmentFromBlueprint != null ? !this.createEnvironmentFromBlueprint.equals(that.createEnvironmentFromBlueprint) : that.createEnvironmentFromBlueprint != null) return false;
                if (this.createEnvironmentProfile != null ? !this.createEnvironmentProfile.equals(that.createEnvironmentProfile) : that.createEnvironmentProfile != null) return false;
                if (this.createFormType != null ? !this.createFormType.equals(that.createFormType) : that.createFormType != null) return false;
                if (this.createGlossary != null ? !this.createGlossary.equals(that.createGlossary) : that.createGlossary != null) return false;
                if (this.createProject != null ? !this.createProject.equals(that.createProject) : that.createProject != null) return false;
                if (this.createProjectFromProjectProfile != null ? !this.createProjectFromProjectProfile.equals(that.createProjectFromProjectProfile) : that.createProjectFromProjectProfile != null) return false;
                if (this.delegateCreateEnvironmentProfile != null ? !this.delegateCreateEnvironmentProfile.equals(that.delegateCreateEnvironmentProfile) : that.delegateCreateEnvironmentProfile != null) return false;
                if (this.overrideDomainUnitOwners != null ? !this.overrideDomainUnitOwners.equals(that.overrideDomainUnitOwners) : that.overrideDomainUnitOwners != null) return false;
                return this.overrideProjectOwners != null ? this.overrideProjectOwners.equals(that.overrideProjectOwners) : that.overrideProjectOwners == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addToProjectMemberPool != null ? this.addToProjectMemberPool.hashCode() : 0;
                result = 31 * result + (this.createAssetType != null ? this.createAssetType.hashCode() : 0);
                result = 31 * result + (this.createDomainUnit != null ? this.createDomainUnit.hashCode() : 0);
                result = 31 * result + (this.createEnvironment != null ? this.createEnvironment.hashCode() : 0);
                result = 31 * result + (this.createEnvironmentFromBlueprint != null ? this.createEnvironmentFromBlueprint.hashCode() : 0);
                result = 31 * result + (this.createEnvironmentProfile != null ? this.createEnvironmentProfile.hashCode() : 0);
                result = 31 * result + (this.createFormType != null ? this.createFormType.hashCode() : 0);
                result = 31 * result + (this.createGlossary != null ? this.createGlossary.hashCode() : 0);
                result = 31 * result + (this.createProject != null ? this.createProject.hashCode() : 0);
                result = 31 * result + (this.createProjectFromProjectProfile != null ? this.createProjectFromProjectProfile.hashCode() : 0);
                result = 31 * result + (this.delegateCreateEnvironmentProfile != null ? this.delegateCreateEnvironmentProfile.hashCode() : 0);
                result = 31 * result + (this.overrideDomainUnitOwners != null ? this.overrideDomainUnitOwners.hashCode() : 0);
                result = 31 * result + (this.overrideProjectOwners != null ? this.overrideProjectOwners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The policy grant principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * Object allDomainUnitsGrantFilter;
     * Object allUsersGrantFilter;
     * PolicyGrantPrincipalProperty policyGrantPrincipalProperty = PolicyGrantPrincipalProperty.builder()
     *         .domainUnit(DomainUnitPolicyGrantPrincipalProperty.builder()
     *                 .domainUnitDesignation("domainUnitDesignation")
     *                 .domainUnitGrantFilter(DomainUnitGrantFilterProperty.builder()
     *                         .allDomainUnitsGrantFilter(allDomainUnitsGrantFilter)
     *                         .build())
     *                 .domainUnitIdentifier("domainUnitIdentifier")
     *                 .build())
     *         .group(GroupPolicyGrantPrincipalProperty.builder()
     *                 .groupIdentifier("groupIdentifier")
     *                 .build())
     *         .project(ProjectPolicyGrantPrincipalProperty.builder()
     *                 .projectDesignation("projectDesignation")
     *                 .projectGrantFilter(ProjectGrantFilterProperty.builder()
     *                         .domainUnitFilter(DomainUnitFilterForProjectProperty.builder()
     *                                 .domainUnit("domainUnit")
     *                                 // the properties below are optional
     *                                 .includeChildDomainUnits(false)
     *                                 .build())
     *                         .build())
     *                 .projectIdentifier("projectIdentifier")
     *                 .build())
     *         .user(UserPolicyGrantPrincipalProperty.builder()
     *                 .allUsersGrantFilter(allUsersGrantFilter)
     *                 .userIdentifier("userIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyGrantPrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyGrantPrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain unit of the policy grant principal.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitPolicyGrantPrincipalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-domainunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-domainunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDomainUnit() {
            return null;
        }

        /**
         * The group of the policy grant principal.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.GroupPolicyGrantPrincipalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-group">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-group</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroup() {
            return null;
        }

        /**
         * The project of the policy grant principal.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.ProjectPolicyGrantPrincipalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-project</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProject() {
            return null;
        }

        /**
         * The user of the policy grant principal.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.UserPolicyGrantPrincipalProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-policygrantprincipal.html#cfn-datazone-policygrant-policygrantprincipal-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyGrantPrincipalProperty> {
            java.lang.Object domainUnit;
            java.lang.Object group;
            java.lang.Object project;
            java.lang.Object user;

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getDomainUnit}
             * @param domainUnit The domain unit of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnit(software.amazon.awscdk.IResolvable domainUnit) {
                this.domainUnit = domainUnit;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getDomainUnit}
             * @param domainUnit The domain unit of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnit(software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitPolicyGrantPrincipalProperty domainUnit) {
                this.domainUnit = domainUnit;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getGroup}
             * @param group The group of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(software.amazon.awscdk.IResolvable group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getGroup}
             * @param group The group of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(software.amazon.awscdk.services.datazone.CfnPolicyGrant.GroupPolicyGrantPrincipalProperty group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getProject}
             * @param project The project of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder project(software.amazon.awscdk.IResolvable project) {
                this.project = project;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getProject}
             * @param project The project of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder project(software.amazon.awscdk.services.datazone.CfnPolicyGrant.ProjectPolicyGrantPrincipalProperty project) {
                this.project = project;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getUser}
             * @param user The user of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(software.amazon.awscdk.IResolvable user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link PolicyGrantPrincipalProperty#getUser}
             * @param user The user of the policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(software.amazon.awscdk.services.datazone.CfnPolicyGrant.UserPolicyGrantPrincipalProperty user) {
                this.user = user;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyGrantPrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyGrantPrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyGrantPrincipalProperty {
            private final java.lang.Object domainUnit;
            private final java.lang.Object group;
            private final java.lang.Object project;
            private final java.lang.Object user;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainUnit = software.amazon.jsii.Kernel.get(this, "domainUnit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainUnit = builder.domainUnit;
                this.group = builder.group;
                this.project = builder.project;
                this.user = builder.user;
            }

            @Override
            public final java.lang.Object getDomainUnit() {
                return this.domainUnit;
            }

            @Override
            public final java.lang.Object getGroup() {
                return this.group;
            }

            @Override
            public final java.lang.Object getProject() {
                return this.project;
            }

            @Override
            public final java.lang.Object getUser() {
                return this.user;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainUnit() != null) {
                    data.set("domainUnit", om.valueToTree(this.getDomainUnit()));
                }
                if (this.getGroup() != null) {
                    data.set("group", om.valueToTree(this.getGroup()));
                }
                if (this.getProject() != null) {
                    data.set("project", om.valueToTree(this.getProject()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyGrantPrincipalProperty.Jsii$Proxy that = (PolicyGrantPrincipalProperty.Jsii$Proxy) o;

                if (this.domainUnit != null ? !this.domainUnit.equals(that.domainUnit) : that.domainUnit != null) return false;
                if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
                if (this.project != null ? !this.project.equals(that.project) : that.project != null) return false;
                return this.user != null ? this.user.equals(that.user) : that.user == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainUnit != null ? this.domainUnit.hashCode() : 0;
                result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
                result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The project grant filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * ProjectGrantFilterProperty projectGrantFilterProperty = ProjectGrantFilterProperty.builder()
     *         .domainUnitFilter(DomainUnitFilterForProjectProperty.builder()
     *                 .domainUnit("domainUnit")
     *                 // the properties below are optional
     *                 .includeChildDomainUnits(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectgrantfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectgrantfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.ProjectGrantFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectGrantFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectGrantFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain unit filter of the project grant filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitFilterForProjectProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectgrantfilter.html#cfn-datazone-policygrant-projectgrantfilter-domainunitfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectgrantfilter.html#cfn-datazone-policygrant-projectgrantfilter-domainunitfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDomainUnitFilter();

        /**
         * @return a {@link Builder} of {@link ProjectGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectGrantFilterProperty> {
            java.lang.Object domainUnitFilter;

            /**
             * Sets the value of {@link ProjectGrantFilterProperty#getDomainUnitFilter}
             * @param domainUnitFilter The domain unit filter of the project grant filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitFilter(software.amazon.awscdk.IResolvable domainUnitFilter) {
                this.domainUnitFilter = domainUnitFilter;
                return this;
            }

            /**
             * Sets the value of {@link ProjectGrantFilterProperty#getDomainUnitFilter}
             * @param domainUnitFilter The domain unit filter of the project grant filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainUnitFilter(software.amazon.awscdk.services.datazone.CfnPolicyGrant.DomainUnitFilterForProjectProperty domainUnitFilter) {
                this.domainUnitFilter = domainUnitFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectGrantFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectGrantFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectGrantFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectGrantFilterProperty {
            private final java.lang.Object domainUnitFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainUnitFilter = software.amazon.jsii.Kernel.get(this, "domainUnitFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainUnitFilter = java.util.Objects.requireNonNull(builder.domainUnitFilter, "domainUnitFilter is required");
            }

            @Override
            public final java.lang.Object getDomainUnitFilter() {
                return this.domainUnitFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainUnitFilter", om.valueToTree(this.getDomainUnitFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.ProjectGrantFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectGrantFilterProperty.Jsii$Proxy that = (ProjectGrantFilterProperty.Jsii$Proxy) o;

                return this.domainUnitFilter.equals(that.domainUnitFilter);
            }

            @Override
            public final int hashCode() {
                int result = this.domainUnitFilter.hashCode();
                return result;
            }
        }
    }
    /**
     * The project policy grant principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * ProjectPolicyGrantPrincipalProperty projectPolicyGrantPrincipalProperty = ProjectPolicyGrantPrincipalProperty.builder()
     *         .projectDesignation("projectDesignation")
     *         .projectGrantFilter(ProjectGrantFilterProperty.builder()
     *                 .domainUnitFilter(DomainUnitFilterForProjectProperty.builder()
     *                         .domainUnit("domainUnit")
     *                         // the properties below are optional
     *                         .includeChildDomainUnits(false)
     *                         .build())
     *                 .build())
     *         .projectIdentifier("projectIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.ProjectPolicyGrantPrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectPolicyGrantPrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectPolicyGrantPrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The project designation of the project policy grant principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectdesignation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectdesignation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectDesignation() {
            return null;
        }

        /**
         * The project grant filter of the project policy grant principal.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.ProjectGrantFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectgrantfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectgrantfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProjectGrantFilter() {
            return null;
        }

        /**
         * The project ID of the project policy grant principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-projectpolicygrantprincipal.html#cfn-datazone-policygrant-projectpolicygrantprincipal-projectidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectPolicyGrantPrincipalProperty> {
            java.lang.String projectDesignation;
            java.lang.Object projectGrantFilter;
            java.lang.String projectIdentifier;

            /**
             * Sets the value of {@link ProjectPolicyGrantPrincipalProperty#getProjectDesignation}
             * @param projectDesignation The project designation of the project policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectDesignation(java.lang.String projectDesignation) {
                this.projectDesignation = projectDesignation;
                return this;
            }

            /**
             * Sets the value of {@link ProjectPolicyGrantPrincipalProperty#getProjectGrantFilter}
             * @param projectGrantFilter The project grant filter of the project policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectGrantFilter(software.amazon.awscdk.IResolvable projectGrantFilter) {
                this.projectGrantFilter = projectGrantFilter;
                return this;
            }

            /**
             * Sets the value of {@link ProjectPolicyGrantPrincipalProperty#getProjectGrantFilter}
             * @param projectGrantFilter The project grant filter of the project policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectGrantFilter(software.amazon.awscdk.services.datazone.CfnPolicyGrant.ProjectGrantFilterProperty projectGrantFilter) {
                this.projectGrantFilter = projectGrantFilter;
                return this;
            }

            /**
             * Sets the value of {@link ProjectPolicyGrantPrincipalProperty#getProjectIdentifier}
             * @param projectIdentifier The project ID of the project policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectIdentifier(java.lang.String projectIdentifier) {
                this.projectIdentifier = projectIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectPolicyGrantPrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectPolicyGrantPrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectPolicyGrantPrincipalProperty {
            private final java.lang.String projectDesignation;
            private final java.lang.Object projectGrantFilter;
            private final java.lang.String projectIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.projectDesignation = software.amazon.jsii.Kernel.get(this, "projectDesignation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.projectGrantFilter = software.amazon.jsii.Kernel.get(this, "projectGrantFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.projectDesignation = builder.projectDesignation;
                this.projectGrantFilter = builder.projectGrantFilter;
                this.projectIdentifier = builder.projectIdentifier;
            }

            @Override
            public final java.lang.String getProjectDesignation() {
                return this.projectDesignation;
            }

            @Override
            public final java.lang.Object getProjectGrantFilter() {
                return this.projectGrantFilter;
            }

            @Override
            public final java.lang.String getProjectIdentifier() {
                return this.projectIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProjectDesignation() != null) {
                    data.set("projectDesignation", om.valueToTree(this.getProjectDesignation()));
                }
                if (this.getProjectGrantFilter() != null) {
                    data.set("projectGrantFilter", om.valueToTree(this.getProjectGrantFilter()));
                }
                if (this.getProjectIdentifier() != null) {
                    data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.ProjectPolicyGrantPrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectPolicyGrantPrincipalProperty.Jsii$Proxy that = (ProjectPolicyGrantPrincipalProperty.Jsii$Proxy) o;

                if (this.projectDesignation != null ? !this.projectDesignation.equals(that.projectDesignation) : that.projectDesignation != null) return false;
                if (this.projectGrantFilter != null ? !this.projectGrantFilter.equals(that.projectGrantFilter) : that.projectGrantFilter != null) return false;
                return this.projectIdentifier != null ? this.projectIdentifier.equals(that.projectIdentifier) : that.projectIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.projectDesignation != null ? this.projectDesignation.hashCode() : 0;
                result = 31 * result + (this.projectGrantFilter != null ? this.projectGrantFilter.hashCode() : 0);
                result = 31 * result + (this.projectIdentifier != null ? this.projectIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The user policy grant principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datazone.*;
     * Object allUsersGrantFilter;
     * UserPolicyGrantPrincipalProperty userPolicyGrantPrincipalProperty = UserPolicyGrantPrincipalProperty.builder()
     *         .allUsersGrantFilter(allUsersGrantFilter)
     *         .userIdentifier("userIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrant.UserPolicyGrantPrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPolicyGrantPrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPolicyGrantPrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The all users grant filter of the user policy grant principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html#cfn-datazone-policygrant-userpolicygrantprincipal-allusersgrantfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html#cfn-datazone-policygrant-userpolicygrantprincipal-allusersgrantfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllUsersGrantFilter() {
            return null;
        }

        /**
         * The user ID of the user policy grant principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html#cfn-datazone-policygrant-userpolicygrantprincipal-useridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datazone-policygrant-userpolicygrantprincipal.html#cfn-datazone-policygrant-userpolicygrantprincipal-useridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPolicyGrantPrincipalProperty> {
            java.lang.Object allUsersGrantFilter;
            java.lang.String userIdentifier;

            /**
             * Sets the value of {@link UserPolicyGrantPrincipalProperty#getAllUsersGrantFilter}
             * @param allUsersGrantFilter The all users grant filter of the user policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allUsersGrantFilter(java.lang.Object allUsersGrantFilter) {
                this.allUsersGrantFilter = allUsersGrantFilter;
                return this;
            }

            /**
             * Sets the value of {@link UserPolicyGrantPrincipalProperty#getUserIdentifier}
             * @param userIdentifier The user ID of the user policy grant principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userIdentifier(java.lang.String userIdentifier) {
                this.userIdentifier = userIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPolicyGrantPrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPolicyGrantPrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPolicyGrantPrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPolicyGrantPrincipalProperty {
            private final java.lang.Object allUsersGrantFilter;
            private final java.lang.String userIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allUsersGrantFilter = software.amazon.jsii.Kernel.get(this, "allUsersGrantFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userIdentifier = software.amazon.jsii.Kernel.get(this, "userIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allUsersGrantFilter = builder.allUsersGrantFilter;
                this.userIdentifier = builder.userIdentifier;
            }

            @Override
            public final java.lang.Object getAllUsersGrantFilter() {
                return this.allUsersGrantFilter;
            }

            @Override
            public final java.lang.String getUserIdentifier() {
                return this.userIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllUsersGrantFilter() != null) {
                    data.set("allUsersGrantFilter", om.valueToTree(this.getAllUsersGrantFilter()));
                }
                if (this.getUserIdentifier() != null) {
                    data.set("userIdentifier", om.valueToTree(this.getUserIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrant.UserPolicyGrantPrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPolicyGrantPrincipalProperty.Jsii$Proxy that = (UserPolicyGrantPrincipalProperty.Jsii$Proxy) o;

                if (this.allUsersGrantFilter != null ? !this.allUsersGrantFilter.equals(that.allUsersGrantFilter) : that.allUsersGrantFilter != null) return false;
                return this.userIdentifier != null ? this.userIdentifier.equals(that.userIdentifier) : that.userIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allUsersGrantFilter != null ? this.allUsersGrantFilter.hashCode() : 0;
                result = 31 * result + (this.userIdentifier != null ? this.userIdentifier.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datazone.CfnPolicyGrant> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datazone.CfnPolicyGrantProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datazone.CfnPolicyGrantProps.Builder();
        }

        /**
         * The ID of the domain where you want to add a policy grant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-domainidentifier</a>
         * @param domainIdentifier The ID of the domain where you want to add a policy grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(final java.lang.String domainIdentifier) {
            this.props.domainIdentifier(domainIdentifier);
            return this;
        }

        /**
         * The ID of the entity (resource) to which you want to add a policy grant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entityidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entityidentifier</a>
         * @param entityIdentifier The ID of the entity (resource) to which you want to add a policy grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityIdentifier(final java.lang.String entityIdentifier) {
            this.props.entityIdentifier(entityIdentifier);
            return this;
        }

        /**
         * The type of entity (resource) to which the grant is added.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entitytype</a>
         * @param entityType The type of entity (resource) to which the grant is added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityType(final java.lang.String entityType) {
            this.props.entityType(entityType);
            return this;
        }

        /**
         * The type of policy that you want to grant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-policytype</a>
         * @param policyType The type of policy that you want to grant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(final java.lang.String policyType) {
            this.props.policyType(policyType);
            return this;
        }

        /**
         * The details of the policy grant member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail</a>
         * @param detail The details of the policy grant member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(final software.amazon.awscdk.IResolvable detail) {
            this.props.detail(detail);
            return this;
        }
        /**
         * The details of the policy grant member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail</a>
         * @param detail The details of the policy grant member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(final software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantDetailProperty detail) {
            this.props.detail(detail);
            return this;
        }

        /**
         * The principal of the policy grant member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal</a>
         * @param principal The principal of the policy grant member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final software.amazon.awscdk.IResolvable principal) {
            this.props.principal(principal);
            return this;
        }
        /**
         * The principal of the policy grant member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal</a>
         * @param principal The principal of the policy grant member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty principal) {
            this.props.principal(principal);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datazone.CfnPolicyGrant build() {
            return new software.amazon.awscdk.services.datazone.CfnPolicyGrant(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
