package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnPolicyGrant</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * Object allDomainUnitsGrantFilter;
 * Object allUsersGrantFilter;
 * Object createEnvironment;
 * Object createEnvironmentFromBlueprint;
 * Object delegateCreateEnvironmentProfile;
 * CfnPolicyGrantProps cfnPolicyGrantProps = CfnPolicyGrantProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .entityIdentifier("entityIdentifier")
 *         .entityType("entityType")
 *         .policyType("policyType")
 *         // the properties below are optional
 *         .detail(PolicyGrantDetailProperty.builder()
 *                 .addToProjectMemberPool(AddToProjectMemberPoolPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createAssetType(CreateAssetTypePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createDomainUnit(CreateDomainUnitPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createEnvironment(createEnvironment)
 *                 .createEnvironmentFromBlueprint(createEnvironmentFromBlueprint)
 *                 .createEnvironmentProfile(CreateEnvironmentProfilePolicyGrantDetailProperty.builder()
 *                         .domainUnitId("domainUnitId")
 *                         .build())
 *                 .createFormType(CreateFormTypePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createGlossary(CreateGlossaryPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createProject(CreateProjectPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .createProjectFromProjectProfile(CreateProjectFromProjectProfilePolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .projectProfiles(List.of("projectProfiles"))
 *                         .build())
 *                 .delegateCreateEnvironmentProfile(delegateCreateEnvironmentProfile)
 *                 .overrideDomainUnitOwners(OverrideDomainUnitOwnersPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .overrideProjectOwners(OverrideProjectOwnersPolicyGrantDetailProperty.builder()
 *                         .includeChildDomainUnits(false)
 *                         .build())
 *                 .build())
 *         .principal(PolicyGrantPrincipalProperty.builder()
 *                 .domainUnit(DomainUnitPolicyGrantPrincipalProperty.builder()
 *                         .domainUnitDesignation("domainUnitDesignation")
 *                         .domainUnitGrantFilter(DomainUnitGrantFilterProperty.builder()
 *                                 .allDomainUnitsGrantFilter(allDomainUnitsGrantFilter)
 *                                 .build())
 *                         .domainUnitIdentifier("domainUnitIdentifier")
 *                         .build())
 *                 .group(GroupPolicyGrantPrincipalProperty.builder()
 *                         .groupIdentifier("groupIdentifier")
 *                         .build())
 *                 .project(ProjectPolicyGrantPrincipalProperty.builder()
 *                         .projectDesignation("projectDesignation")
 *                         .projectGrantFilter(ProjectGrantFilterProperty.builder()
 *                                 .domainUnitFilter(DomainUnitFilterForProjectProperty.builder()
 *                                         .domainUnit("domainUnit")
 *                                         // the properties below are optional
 *                                         .includeChildDomainUnits(false)
 *                                         .build())
 *                                 .build())
 *                         .projectIdentifier("projectIdentifier")
 *                         .build())
 *                 .user(UserPolicyGrantPrincipalProperty.builder()
 *                         .allUsersGrantFilter(allUsersGrantFilter)
 *                         .userIdentifier("userIdentifier")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:01.999Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnPolicyGrantProps")
@software.amazon.jsii.Jsii.Proxy(CfnPolicyGrantProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPolicyGrantProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the domain where you want to add a policy grant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The ID of the entity (resource) to which you want to add a policy grant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entityidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entityidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntityIdentifier();

    /**
     * The type of entity (resource) to which the grant is added.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-entitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntityType();

    /**
     * The type of policy that you want to grant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-policytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyType();

    /**
     * The details of the policy grant member.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantDetailProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-detail</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDetail() {
        return null;
    }

    /**
     * The principal of the policy grant member.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-policygrant.html#cfn-datazone-policygrant-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrincipal() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPolicyGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPolicyGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPolicyGrantProps> {
        java.lang.String domainIdentifier;
        java.lang.String entityIdentifier;
        java.lang.String entityType;
        java.lang.String policyType;
        java.lang.Object detail;
        java.lang.Object principal;

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getDomainIdentifier}
         * @param domainIdentifier The ID of the domain where you want to add a policy grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getEntityIdentifier}
         * @param entityIdentifier The ID of the entity (resource) to which you want to add a policy grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityIdentifier(java.lang.String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getEntityType}
         * @param entityType The type of entity (resource) to which the grant is added. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityType(java.lang.String entityType) {
            this.entityType = entityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getPolicyType}
         * @param policyType The type of policy that you want to grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(java.lang.String policyType) {
            this.policyType = policyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getDetail}
         * @param detail The details of the policy grant member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(software.amazon.awscdk.IResolvable detail) {
            this.detail = detail;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getDetail}
         * @param detail The details of the policy grant member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantDetailProperty detail) {
            this.detail = detail;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getPrincipal}
         * @param principal The principal of the policy grant member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(software.amazon.awscdk.IResolvable principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPolicyGrantProps#getPrincipal}
         * @param principal The principal of the policy grant member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(software.amazon.awscdk.services.datazone.CfnPolicyGrant.PolicyGrantPrincipalProperty principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPolicyGrantProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPolicyGrantProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPolicyGrantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPolicyGrantProps {
        private final java.lang.String domainIdentifier;
        private final java.lang.String entityIdentifier;
        private final java.lang.String entityType;
        private final java.lang.String policyType;
        private final java.lang.Object detail;
        private final java.lang.Object principal;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityIdentifier = software.amazon.jsii.Kernel.get(this, "entityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityType = software.amazon.jsii.Kernel.get(this, "entityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detail = software.amazon.jsii.Kernel.get(this, "detail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.entityIdentifier = java.util.Objects.requireNonNull(builder.entityIdentifier, "entityIdentifier is required");
            this.entityType = java.util.Objects.requireNonNull(builder.entityType, "entityType is required");
            this.policyType = java.util.Objects.requireNonNull(builder.policyType, "policyType is required");
            this.detail = builder.detail;
            this.principal = builder.principal;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        @Override
        public final java.lang.String getEntityType() {
            return this.entityType;
        }

        @Override
        public final java.lang.String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final java.lang.Object getDetail() {
            return this.detail;
        }

        @Override
        public final java.lang.Object getPrincipal() {
            return this.principal;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("entityIdentifier", om.valueToTree(this.getEntityIdentifier()));
            data.set("entityType", om.valueToTree(this.getEntityType()));
            data.set("policyType", om.valueToTree(this.getPolicyType()));
            if (this.getDetail() != null) {
                data.set("detail", om.valueToTree(this.getDetail()));
            }
            if (this.getPrincipal() != null) {
                data.set("principal", om.valueToTree(this.getPrincipal()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnPolicyGrantProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPolicyGrantProps.Jsii$Proxy that = (CfnPolicyGrantProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!entityIdentifier.equals(that.entityIdentifier)) return false;
            if (!entityType.equals(that.entityType)) return false;
            if (!policyType.equals(that.policyType)) return false;
            if (this.detail != null ? !this.detail.equals(that.detail) : that.detail != null) return false;
            return this.principal != null ? this.principal.equals(that.principal) : that.principal == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.entityIdentifier.hashCode());
            result = 31 * result + (this.entityType.hashCode());
            result = 31 * result + (this.policyType.hashCode());
            result = 31 * result + (this.detail != null ? this.detail.hashCode() : 0);
            result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
            return result;
        }
    }
}
