package software.amazon.awscdk.services.datazone;

/**
 * A reference to a DomainUnit resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * DomainUnitReference domainUnitReference = DomainUnitReference.builder()
 *         .domainId("domainId")
 *         .domainUnitId("domainUnitId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.013Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.DomainUnitReference")
@software.amazon.jsii.Jsii.Proxy(DomainUnitReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainUnitReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DomainId of the DomainUnit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainId();

    /**
     * The Id of the DomainUnit resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainUnitId();

    /**
     * @return a {@link Builder} of {@link DomainUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainUnitReference> {
        java.lang.String domainId;
        java.lang.String domainUnitId;

        /**
         * Sets the value of {@link DomainUnitReference#getDomainId}
         * @param domainId The DomainId of the DomainUnit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainId(java.lang.String domainId) {
            this.domainId = domainId;
            return this;
        }

        /**
         * Sets the value of {@link DomainUnitReference#getDomainUnitId}
         * @param domainUnitId The Id of the DomainUnit resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainUnitId(java.lang.String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainUnitReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainUnitReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainUnitReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainUnitReference {
        private final java.lang.String domainId;
        private final java.lang.String domainUnitId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainId = software.amazon.jsii.Kernel.get(this, "domainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainUnitId = software.amazon.jsii.Kernel.get(this, "domainUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainId = java.util.Objects.requireNonNull(builder.domainId, "domainId is required");
            this.domainUnitId = java.util.Objects.requireNonNull(builder.domainUnitId, "domainUnitId is required");
        }

        @Override
        public final java.lang.String getDomainId() {
            return this.domainId;
        }

        @Override
        public final java.lang.String getDomainUnitId() {
            return this.domainUnitId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainId", om.valueToTree(this.getDomainId()));
            data.set("domainUnitId", om.valueToTree(this.getDomainUnitId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.DomainUnitReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainUnitReference.Jsii$Proxy that = (DomainUnitReference.Jsii$Proxy) o;

            if (!domainId.equals(that.domainId)) return false;
            return this.domainUnitId.equals(that.domainUnitId);
        }

        @Override
        public final int hashCode() {
            int result = this.domainId.hashCode();
            result = 31 * result + (this.domainUnitId.hashCode());
            return result;
        }
    }
}
