package software.amazon.awscdk.services.datazone;

/**
 * A reference to a PolicyGrant resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * PolicyGrantReference policyGrantReference = PolicyGrantReference.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .entityIdentifier("entityIdentifier")
 *         .entityType("entityType")
 *         .grantId("grantId")
 *         .policyType("policyType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.034Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.PolicyGrantReference")
@software.amazon.jsii.Jsii.Proxy(PolicyGrantReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyGrantReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DomainIdentifier of the PolicyGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The EntityIdentifier of the PolicyGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntityIdentifier();

    /**
     * The EntityType of the PolicyGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEntityType();

    /**
     * The GrantId of the PolicyGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGrantId();

    /**
     * The PolicyType of the PolicyGrant resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyType();

    /**
     * @return a {@link Builder} of {@link PolicyGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyGrantReference> {
        java.lang.String domainIdentifier;
        java.lang.String entityIdentifier;
        java.lang.String entityType;
        java.lang.String grantId;
        java.lang.String policyType;

        /**
         * Sets the value of {@link PolicyGrantReference#getDomainIdentifier}
         * @param domainIdentifier The DomainIdentifier of the PolicyGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link PolicyGrantReference#getEntityIdentifier}
         * @param entityIdentifier The EntityIdentifier of the PolicyGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityIdentifier(java.lang.String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link PolicyGrantReference#getEntityType}
         * @param entityType The EntityType of the PolicyGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityType(java.lang.String entityType) {
            this.entityType = entityType;
            return this;
        }

        /**
         * Sets the value of {@link PolicyGrantReference#getGrantId}
         * @param grantId The GrantId of the PolicyGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantId(java.lang.String grantId) {
            this.grantId = grantId;
            return this;
        }

        /**
         * Sets the value of {@link PolicyGrantReference#getPolicyType}
         * @param policyType The PolicyType of the PolicyGrant resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(java.lang.String policyType) {
            this.policyType = policyType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyGrantReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyGrantReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyGrantReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyGrantReference {
        private final java.lang.String domainIdentifier;
        private final java.lang.String entityIdentifier;
        private final java.lang.String entityType;
        private final java.lang.String grantId;
        private final java.lang.String policyType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityIdentifier = software.amazon.jsii.Kernel.get(this, "entityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entityType = software.amazon.jsii.Kernel.get(this, "entityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.grantId = software.amazon.jsii.Kernel.get(this, "grantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.entityIdentifier = java.util.Objects.requireNonNull(builder.entityIdentifier, "entityIdentifier is required");
            this.entityType = java.util.Objects.requireNonNull(builder.entityType, "entityType is required");
            this.grantId = java.util.Objects.requireNonNull(builder.grantId, "grantId is required");
            this.policyType = java.util.Objects.requireNonNull(builder.policyType, "policyType is required");
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        @Override
        public final java.lang.String getEntityType() {
            return this.entityType;
        }

        @Override
        public final java.lang.String getGrantId() {
            return this.grantId;
        }

        @Override
        public final java.lang.String getPolicyType() {
            return this.policyType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("entityIdentifier", om.valueToTree(this.getEntityIdentifier()));
            data.set("entityType", om.valueToTree(this.getEntityType()));
            data.set("grantId", om.valueToTree(this.getGrantId()));
            data.set("policyType", om.valueToTree(this.getPolicyType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.PolicyGrantReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyGrantReference.Jsii$Proxy that = (PolicyGrantReference.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!entityIdentifier.equals(that.entityIdentifier)) return false;
            if (!entityType.equals(that.entityType)) return false;
            if (!grantId.equals(that.grantId)) return false;
            return this.policyType.equals(that.policyType);
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.entityIdentifier.hashCode());
            result = 31 * result + (this.entityType.hashCode());
            result = 31 * result + (this.grantId.hashCode());
            result = 31 * result + (this.policyType.hashCode());
            return result;
        }
    }
}
