package software.amazon.awscdk.services.datazone;

/**
 * A reference to a ProjectMembership resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * ProjectMembershipReference projectMembershipReference = ProjectMembershipReference.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .memberIdentifier("memberIdentifier")
 *         .memberIdentifierType("memberIdentifierType")
 *         .projectIdentifier("projectIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.ProjectMembershipReference")
@software.amazon.jsii.Jsii.Proxy(ProjectMembershipReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProjectMembershipReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DomainIdentifier of the ProjectMembership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The MemberIdentifier of the ProjectMembership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMemberIdentifier();

    /**
     * The MemberIdentifierType of the ProjectMembership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMemberIdentifierType();

    /**
     * The ProjectIdentifier of the ProjectMembership resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier();

    /**
     * @return a {@link Builder} of {@link ProjectMembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProjectMembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProjectMembershipReference> {
        java.lang.String domainIdentifier;
        java.lang.String memberIdentifier;
        java.lang.String memberIdentifierType;
        java.lang.String projectIdentifier;

        /**
         * Sets the value of {@link ProjectMembershipReference#getDomainIdentifier}
         * @param domainIdentifier The DomainIdentifier of the ProjectMembership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ProjectMembershipReference#getMemberIdentifier}
         * @param memberIdentifier The MemberIdentifier of the ProjectMembership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberIdentifier(java.lang.String memberIdentifier) {
            this.memberIdentifier = memberIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link ProjectMembershipReference#getMemberIdentifierType}
         * @param memberIdentifierType The MemberIdentifierType of the ProjectMembership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberIdentifierType(java.lang.String memberIdentifierType) {
            this.memberIdentifierType = memberIdentifierType;
            return this;
        }

        /**
         * Sets the value of {@link ProjectMembershipReference#getProjectIdentifier}
         * @param projectIdentifier The ProjectIdentifier of the ProjectMembership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(java.lang.String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectMembershipReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProjectMembershipReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProjectMembershipReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectMembershipReference {
        private final java.lang.String domainIdentifier;
        private final java.lang.String memberIdentifier;
        private final java.lang.String memberIdentifierType;
        private final java.lang.String projectIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memberIdentifier = software.amazon.jsii.Kernel.get(this, "memberIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memberIdentifierType = software.amazon.jsii.Kernel.get(this, "memberIdentifierType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.memberIdentifier = java.util.Objects.requireNonNull(builder.memberIdentifier, "memberIdentifier is required");
            this.memberIdentifierType = java.util.Objects.requireNonNull(builder.memberIdentifierType, "memberIdentifierType is required");
            this.projectIdentifier = java.util.Objects.requireNonNull(builder.projectIdentifier, "projectIdentifier is required");
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getMemberIdentifier() {
            return this.memberIdentifier;
        }

        @Override
        public final java.lang.String getMemberIdentifierType() {
            return this.memberIdentifierType;
        }

        @Override
        public final java.lang.String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("memberIdentifier", om.valueToTree(this.getMemberIdentifier()));
            data.set("memberIdentifierType", om.valueToTree(this.getMemberIdentifierType()));
            data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.ProjectMembershipReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProjectMembershipReference.Jsii$Proxy that = (ProjectMembershipReference.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!memberIdentifier.equals(that.memberIdentifier)) return false;
            if (!memberIdentifierType.equals(that.memberIdentifierType)) return false;
            return this.projectIdentifier.equals(that.projectIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.memberIdentifier.hashCode());
            result = 31 * result + (this.memberIdentifierType.hashCode());
            result = 31 * result + (this.projectIdentifier.hashCode());
            return result;
        }
    }
}
