package software.amazon.awscdk.services.deadline;

/**
 * A reference to a QueueEnvironment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * QueueEnvironmentReference queueEnvironmentReference = QueueEnvironmentReference.builder()
 *         .farmId("farmId")
 *         .queueEnvironmentId("queueEnvironmentId")
 *         .queueId("queueId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.QueueEnvironmentReference")
@software.amazon.jsii.Jsii.Proxy(QueueEnvironmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueEnvironmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The FarmId of the QueueEnvironment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFarmId();

    /**
     * The QueueEnvironmentId of the QueueEnvironment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueEnvironmentId();

    /**
     * The QueueId of the QueueEnvironment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueueId();

    /**
     * @return a {@link Builder} of {@link QueueEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueEnvironmentReference> {
        java.lang.String farmId;
        java.lang.String queueEnvironmentId;
        java.lang.String queueId;

        /**
         * Sets the value of {@link QueueEnvironmentReference#getFarmId}
         * @param farmId The FarmId of the QueueEnvironment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link QueueEnvironmentReference#getQueueEnvironmentId}
         * @param queueEnvironmentId The QueueEnvironmentId of the QueueEnvironment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueEnvironmentId(java.lang.String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
            return this;
        }

        /**
         * Sets the value of {@link QueueEnvironmentReference#getQueueId}
         * @param queueId The QueueId of the QueueEnvironment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueId(java.lang.String queueId) {
            this.queueId = queueId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueEnvironmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueEnvironmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueueEnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueEnvironmentReference {
        private final java.lang.String farmId;
        private final java.lang.String queueEnvironmentId;
        private final java.lang.String queueId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueEnvironmentId = software.amazon.jsii.Kernel.get(this, "queueEnvironmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queueId = software.amazon.jsii.Kernel.get(this, "queueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.farmId = java.util.Objects.requireNonNull(builder.farmId, "farmId is required");
            this.queueEnvironmentId = java.util.Objects.requireNonNull(builder.queueEnvironmentId, "queueEnvironmentId is required");
            this.queueId = java.util.Objects.requireNonNull(builder.queueId, "queueId is required");
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.lang.String getQueueEnvironmentId() {
            return this.queueEnvironmentId;
        }

        @Override
        public final java.lang.String getQueueId() {
            return this.queueId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("farmId", om.valueToTree(this.getFarmId()));
            data.set("queueEnvironmentId", om.valueToTree(this.getQueueEnvironmentId()));
            data.set("queueId", om.valueToTree(this.getQueueId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.QueueEnvironmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueEnvironmentReference.Jsii$Proxy that = (QueueEnvironmentReference.Jsii$Proxy) o;

            if (!farmId.equals(that.farmId)) return false;
            if (!queueEnvironmentId.equals(that.queueEnvironmentId)) return false;
            return this.queueId.equals(that.queueId);
        }

        @Override
        public final int hashCode() {
            int result = this.farmId.hashCode();
            result = 31 * result + (this.queueEnvironmentId.hashCode());
            result = 31 * result + (this.queueId.hashCode());
            return result;
        }
    }
}
