package software.amazon.awscdk.services.docdb;

/**
 * A reference to a DBSubnetGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * DBSubnetGroupReference dBSubnetGroupReference = DBSubnetGroupReference.builder()
 *         .dbSubnetGroupId("dbSubnetGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.354Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DBSubnetGroupReference")
@software.amazon.jsii.Jsii.Proxy(DBSubnetGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DBSubnetGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the DBSubnetGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbSubnetGroupId();

    /**
     * @return a {@link Builder} of {@link DBSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DBSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DBSubnetGroupReference> {
        java.lang.String dbSubnetGroupId;

        /**
         * Sets the value of {@link DBSubnetGroupReference#getDbSubnetGroupId}
         * @param dbSubnetGroupId The Id of the DBSubnetGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupId(java.lang.String dbSubnetGroupId) {
            this.dbSubnetGroupId = dbSubnetGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DBSubnetGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DBSubnetGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DBSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBSubnetGroupReference {
        private final java.lang.String dbSubnetGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbSubnetGroupId = software.amazon.jsii.Kernel.get(this, "dbSubnetGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbSubnetGroupId = java.util.Objects.requireNonNull(builder.dbSubnetGroupId, "dbSubnetGroupId is required");
        }

        @Override
        public final java.lang.String getDbSubnetGroupId() {
            return this.dbSubnetGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbSubnetGroupId", om.valueToTree(this.getDbSubnetGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DBSubnetGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DBSubnetGroupReference.Jsii$Proxy that = (DBSubnetGroupReference.Jsii$Proxy) o;

            return this.dbSubnetGroupId.equals(that.dbSubnetGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.dbSubnetGroupId.hashCode();
            return result;
        }
    }
}
