package software.amazon.awscdk.services.dynamodb;

/**
 * The <code>AWS::DynamoDB::GlobalTable</code> resource enables you to create and manage a Version 2019.11.21 global table. This resource cannot be used to create or manage a Version 2017.11.29 global table. For more information, see <a href="https://docs.aws.amazon.com//amazondynamodb/latest/developerguide/GlobalTables.html">Global tables</a> .
 * <p>
 * <blockquote>
 * <p>
 * You cannot convert a resource of type <code>AWS::DynamoDB::Table</code> into a resource of type <code>AWS::DynamoDB::GlobalTable</code> by changing its type in your template. <em>Doing so might result in the deletion of your DynamoDB table.</em>
 * <p>
 * You can instead use the GlobalTable resource to create a new table in a single Region. This will be billed the same as a single Region table. If you later update the stack to add other Regions then Global Tables pricing will apply.
 * <p>
 * </blockquote>
 * <p>
 * You should be aware of the following behaviors when working with DynamoDB global tables.
 * <p>
 * <ul>
 * <li>The IAM Principal executing the stack operation must have the permissions listed below in all regions where you plan to have a global table replica. The IAM Principal's permissions should not have restrictions based on IP source address. Some global tables operations (for example, adding a replica) are asynchronous, and require that the IAM Principal is valid until they complete. You should not delete the Principal (user or IAM role) until CloudFormation has finished updating your stack.</li>
 * <li><code>application-autoscaling:DeleteScalingPolicy</code></li>
 * <li><code>application-autoscaling:DeleteScheduledAction</code></li>
 * <li><code>application-autoscaling:DeregisterScalableTarget</code></li>
 * <li><code>application-autoscaling:DescribeScalableTargets</code></li>
 * <li><code>application-autoscaling:DescribeScalingPolicies</code></li>
 * <li><code>application-autoscaling:PutScalingPolicy</code></li>
 * <li><code>application-autoscaling:PutScheduledAction</code></li>
 * <li><code>application-autoscaling:RegisterScalableTarget</code></li>
 * <li><code>dynamodb:BatchWriteItem</code></li>
 * <li><code>dynamodb:CreateGlobalTableWitness</code></li>
 * <li><code>dynamodb:CreateTable</code></li>
 * <li><code>dynamodb:CreateTableReplica</code></li>
 * <li><code>dynamodb:DeleteGlobalTableWitness</code></li>
 * <li><code>dynamodb:DeleteItem</code></li>
 * <li><code>dynamodb:DeleteTable</code></li>
 * <li><code>dynamodb:DeleteTableReplica</code></li>
 * <li><code>dynamodb:DescribeContinuousBackups</code></li>
 * <li><code>dynamodb:DescribeContributorInsights</code></li>
 * <li><code>dynamodb:DescribeTable</code></li>
 * <li><code>dynamodb:DescribeTableReplicaAutoScaling</code></li>
 * <li><code>dynamodb:DescribeTimeToLive</code></li>
 * <li><code>dynamodb:DisableKinesisStreamingDestination</code></li>
 * <li><code>dynamodb:EnableKinesisStreamingDestination</code></li>
 * <li><code>dynamodb:GetItem</code></li>
 * <li><code>dynamodb:ListTables</code></li>
 * <li><code>dynamodb:ListTagsOfResource</code></li>
 * <li><code>dynamodb:PutItem</code></li>
 * <li><code>dynamodb:Query</code></li>
 * <li><code>dynamodb:Scan</code></li>
 * <li><code>dynamodb:TagResource</code></li>
 * <li><code>dynamodb:UntagResource</code></li>
 * <li><code>dynamodb:UpdateContinuousBackups</code></li>
 * <li><code>dynamodb:UpdateContributorInsights</code></li>
 * <li><code>dynamodb:UpdateItem</code></li>
 * <li><code>dynamodb:UpdateTable</code></li>
 * <li><code>dynamodb:UpdateTableReplicaAutoScaling</code></li>
 * <li><code>dynamodb:UpdateTimeToLive</code></li>
 * <li><code>iam:CreateServiceLinkedRole</code></li>
 * <li><code>kms:CreateGrant</code></li>
 * <li><code>kms:DescribeKey</code></li>
 * <li>When using provisioned billing mode, CloudFormation will create an auto scaling policy on each of your replicas to control their write capacities. You must configure this policy using the <code>WriteProvisionedThroughputSettings</code> property. CloudFormation will ensure that all replicas have the same write capacity auto scaling property. You cannot directly specify a value for write capacity for a global table.</li>
 * <li>If your table uses provisioned capacity, you must configure auto scaling directly in the <code>AWS::DynamoDB::GlobalTable</code> resource. You should not configure additional auto scaling policies on any of the table replicas or global secondary indexes, either via API or via <code>AWS::ApplicationAutoScaling::ScalableTarget</code> or <code>AWS::ApplicationAutoScaling::ScalingPolicy</code> . Doing so might result in unexpected behavior and is unsupported.</li>
 * <li>In AWS CloudFormation , each global table is controlled by a single stack, in a single region, regardless of the number of replicas. When you deploy your template, CloudFormation will create/update all replicas as part of a single stack operation. You should not deploy the same <code>AWS::DynamoDB::GlobalTable</code> resource in multiple regions. Doing so will result in errors, and is unsupported. If you deploy your application template in multiple regions, you can use conditions to only create the resource in a single region. Alternatively, you can choose to define your <code>AWS::DynamoDB::GlobalTable</code> resources in a stack separate from your application stack, and make sure it is only deployed to a single region.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * Object policyDocument;
 * CfnGlobalTable cfnGlobalTable = CfnGlobalTable.Builder.create(this, "MyCfnGlobalTable")
 *         .attributeDefinitions(List.of(AttributeDefinitionProperty.builder()
 *                 .attributeName("attributeName")
 *                 .attributeType("attributeType")
 *                 .build()))
 *         .keySchema(List.of(KeySchemaProperty.builder()
 *                 .attributeName("attributeName")
 *                 .keyType("keyType")
 *                 .build()))
 *         .replicas(List.of(ReplicaSpecificationProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                         .enabled(false)
 *                         // the properties below are optional
 *                         .mode("mode")
 *                         .build())
 *                 .deletionProtectionEnabled(false)
 *                 .globalSecondaryIndexes(List.of(ReplicaGlobalSecondaryIndexSpecificationProperty.builder()
 *                         .indexName("indexName")
 *                         // the properties below are optional
 *                         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .mode("mode")
 *                                 .build())
 *                         .readOnDemandThroughputSettings(ReadOnDemandThroughputSettingsProperty.builder()
 *                                 .maxReadRequestUnits(123)
 *                                 .build())
 *                         .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
 *                                 .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                                 .targetValue(123)
 *                                                 // the properties below are optional
 *                                                 .disableScaleIn(false)
 *                                                 .scaleInCooldown(123)
 *                                                 .scaleOutCooldown(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .seedCapacity(123)
 *                                         .build())
 *                                 .readCapacityUnits(123)
 *                                 .build())
 *                         .build()))
 *                 .kinesisStreamSpecification(KinesisStreamSpecificationProperty.builder()
 *                         .streamArn("streamArn")
 *                         // the properties below are optional
 *                         .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
 *                         .build())
 *                 .pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty.builder()
 *                         .pointInTimeRecoveryEnabled(false)
 *                         .recoveryPeriodInDays(123)
 *                         .build())
 *                 .readOnDemandThroughputSettings(ReadOnDemandThroughputSettingsProperty.builder()
 *                         .maxReadRequestUnits(123)
 *                         .build())
 *                 .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
 *                         .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                 .maxCapacity(123)
 *                                 .minCapacity(123)
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .seedCapacity(123)
 *                                 .build())
 *                         .readCapacityUnits(123)
 *                         .build())
 *                 .replicaStreamSpecification(ReplicaStreamSpecificationProperty.builder()
 *                         .resourcePolicy(ResourcePolicyProperty.builder()
 *                                 .policyDocument(policyDocument)
 *                                 .build())
 *                         .build())
 *                 .resourcePolicy(ResourcePolicyProperty.builder()
 *                         .policyDocument(policyDocument)
 *                         .build())
 *                 .sseSpecification(ReplicaSSESpecificationProperty.builder()
 *                         .kmsMasterKeyId("kmsMasterKeyId")
 *                         .build())
 *                 .tableClass("tableClass")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .billingMode("billingMode")
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 // the properties below are optional
 *                 .warmThroughput(WarmThroughputProperty.builder()
 *                         .readUnitsPerSecond(123)
 *                         .writeUnitsPerSecond(123)
 *                         .build())
 *                 .writeOnDemandThroughputSettings(WriteOnDemandThroughputSettingsProperty.builder()
 *                         .maxWriteRequestUnits(123)
 *                         .build())
 *                 .writeProvisionedThroughputSettings(WriteProvisionedThroughputSettingsProperty.builder()
 *                         .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                 .maxCapacity(123)
 *                                 .minCapacity(123)
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .seedCapacity(123)
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .globalTableWitnesses(List.of(GlobalTableWitnessProperty.builder()
 *                 .region("region")
 *                 .build()))
 *         .localSecondaryIndexes(List.of(LocalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 .build()))
 *         .multiRegionConsistency("multiRegionConsistency")
 *         .sseSpecification(SSESpecificationProperty.builder()
 *                 .sseEnabled(false)
 *                 // the properties below are optional
 *                 .sseType("sseType")
 *                 .build())
 *         .streamSpecification(StreamSpecificationProperty.builder()
 *                 .streamViewType("streamViewType")
 *                 .build())
 *         .tableName("tableName")
 *         .timeToLiveSpecification(TimeToLiveSpecificationProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .attributeName("attributeName")
 *                 .build())
 *         .warmThroughput(WarmThroughputProperty.builder()
 *                 .readUnitsPerSecond(123)
 *                 .writeUnitsPerSecond(123)
 *                 .build())
 *         .writeOnDemandThroughputSettings(WriteOnDemandThroughputSettingsProperty.builder()
 *                 .maxWriteRequestUnits(123)
 *                 .build())
 *         .writeProvisionedThroughputSettings(WriteProvisionedThroughputSettingsProperty.builder()
 *                 .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                 .targetValue(123)
 *                                 // the properties below are optional
 *                                 .disableScaleIn(false)
 *                                 .scaleInCooldown(123)
 *                                 .scaleOutCooldown(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .seedCapacity(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.402Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable")
public class CfnGlobalTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.dynamodb.IGlobalTableRef {

    protected CfnGlobalTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGlobalTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGlobalTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.CfnGlobalTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the DynamoDB table, such as <code>arn:aws:dynamodb:us-east-2:123456789012:table/myDynamoDBTable</code> .
     * <p>
     * The ARN returned is that of the replica in the region the stack is deployed to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the DynamoDB stream, such as <code>arn:aws:dynamodb:us-east-1:123456789012:table/testddbstack-myDynamoDBTable-012A1SL7SMP5Q/stream/2015-11-30T20:10:00.000</code> . The <code>StreamArn</code> returned is that of the replica in the region the stack is deployed to.
     * <p>
     * <blockquote>
     * <p>
     * You must specify the <code>StreamSpecification</code> property to use this attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "attrStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique identifier for the table, such as <code>a123b456-01ab-23cd-123a-111222aaabbb</code> .
     * <p>
     * The <code>TableId</code> returned is that of the replica in the region the stack is deployed to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTableId() {
        return software.amazon.jsii.Kernel.get(this, "attrTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a GlobalTable resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.GlobalTableReference getGlobalTableRef() {
        return software.amazon.jsii.Kernel.get(this, "globalTableRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.GlobalTableReference.class));
    }

    /**
     * A list of attributes that describe the key schema for the global table and indexes.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.AttributeDefinitionProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAttributeDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "attributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of attributes that describe the key schema for the global table and indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributeDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributeDefinitions", java.util.Objects.requireNonNull(value, "attributeDefinitions is required"));
    }

    /**
     * A list of attributes that describe the key schema for the global table and indexes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributeDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.AttributeDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.AttributeDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "attributeDefinitions", java.util.Objects.requireNonNull(value, "attributeDefinitions is required"));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KeySchemaProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema() {
        return software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySchema(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * Specifies the attributes that make up the primary key for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySchema(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KeySchemaProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KeySchemaProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "keySchema", java.util.Objects.requireNonNull(value, "keySchema is required"));
    }

    /**
     * Specifies the list of replicas for your global table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaSpecificationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getReplicas() {
        return software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the list of replicas for your global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicas(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replicas", java.util.Objects.requireNonNull(value, "replicas is required"));
    }

    /**
     * Specifies the list of replicas for your global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicas(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "replicas", java.util.Objects.requireNonNull(value, "replicas is required"));
    }

    /**
     * Specifies how you are charged for read and write throughput and how you manage capacity.
     * <p>
     * Valid values are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how you are charged for read and write throughput and how you manage capacity.
     * <p>
     * Valid values are:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * Global secondary indexes to be created on the global table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
        return software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Global secondary indexes to be created on the global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalSecondaryIndexes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "globalSecondaryIndexes", value);
    }

    /**
     * Global secondary indexes to be created on the global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalSecondaryIndexes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "globalSecondaryIndexes", value);
    }

    /**
     * The list of witnesses of the MRSC global table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalTableWitnessProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGlobalTableWitnesses() {
        return software.amazon.jsii.Kernel.get(this, "globalTableWitnesses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of witnesses of the MRSC global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalTableWitnesses(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "globalTableWitnesses", value);
    }

    /**
     * The list of witnesses of the MRSC global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalTableWitnesses(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalTableWitnessProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.GlobalTableWitnessProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "globalTableWitnesses", value);
    }

    /**
     * Local secondary indexes to be created on the table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.LocalSecondaryIndexProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLocalSecondaryIndexes() {
        return software.amazon.jsii.Kernel.get(this, "localSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Local secondary indexes to be created on the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalSecondaryIndexes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "localSecondaryIndexes", value);
    }

    /**
     * Local secondary indexes to be created on the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalSecondaryIndexes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dynamodb.CfnGlobalTable.LocalSecondaryIndexProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dynamodb.CfnGlobalTable.LocalSecondaryIndexProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "localSecondaryIndexes", value);
    }

    /**
     * Specifies the consistency mode for a new global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMultiRegionConsistency() {
        return software.amazon.jsii.Kernel.get(this, "multiRegionConsistency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the consistency mode for a new global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionConsistency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionConsistency", value);
    }

    /**
     * Specifies the settings to enable server-side encryption.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.SSESpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sseSpecification", value);
    }

    /**
     * Specifies the settings to enable server-side encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSseSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.SSESpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "sseSpecification", value);
    }

    /**
     * Specifies the streams settings on your global table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.StreamSpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStreamSpecification() {
        return software.amazon.jsii.Kernel.get(this, "streamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the streams settings on your global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamSpecification", value);
    }

    /**
     * Specifies the streams settings on your global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.StreamSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamSpecification", value);
    }

    /**
     * A name for the global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the global table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }

    /**
     * Specifies the time to live (TTL) settings for the table.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeToLiveSpecification() {
        return software.amazon.jsii.Kernel.get(this, "timeToLiveSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the time to live (TTL) settings for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeToLiveSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "timeToLiveSpecification", value);
    }

    /**
     * Specifies the time to live (TTL) settings for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeToLiveSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "timeToLiveSpecification", value);
    }

    /**
     * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WarmThroughputProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWarmThroughput() {
        return software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWarmThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "warmThroughput", value);
    }

    /**
     * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWarmThroughput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WarmThroughputProperty value) {
        software.amazon.jsii.Kernel.set(this, "warmThroughput", value);
    }

    /**
     * Sets the write request settings for a global table or a global secondary index.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWriteOnDemandThroughputSettings() {
        return software.amazon.jsii.Kernel.get(this, "writeOnDemandThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Sets the write request settings for a global table or a global secondary index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteOnDemandThroughputSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "writeOnDemandThroughputSettings", value);
    }

    /**
     * Sets the write request settings for a global table or a global secondary index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteOnDemandThroughputSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "writeOnDemandThroughputSettings", value);
    }

    /**
     * Specifies an auto scaling policy for write capacity.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWriteProvisionedThroughputSettings() {
        return software.amazon.jsii.Kernel.get(this, "writeProvisionedThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies an auto scaling policy for write capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteProvisionedThroughputSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "writeProvisionedThroughputSettings", value);
    }

    /**
     * Specifies an auto scaling policy for write capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWriteProvisionedThroughputSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "writeProvisionedThroughputSettings", value);
    }
    /**
     * Represents an attribute for describing the schema for the table and indexes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * AttributeDefinitionProperty attributeDefinitionProperty = AttributeDefinitionProperty.builder()
     *         .attributeName("attributeName")
     *         .attributeType("attributeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.AttributeDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The data type for the attribute, where:.
         * <p>
         * <ul>
         * <li><code>S</code> - the attribute is of type String</li>
         * <li><code>N</code> - the attribute is of type Number</li>
         * <li><code>B</code> - the attribute is of type Binary</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-attributedefinition.html#cfn-dynamodb-globaltable-attributedefinition-attributetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeType();

        /**
         * @return a {@link Builder} of {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeDefinitionProperty> {
            java.lang.String attributeName;
            java.lang.String attributeType;

            /**
             * Sets the value of {@link AttributeDefinitionProperty#getAttributeName}
             * @param attributeName A name for the attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link AttributeDefinitionProperty#getAttributeType}
             * @param attributeType The data type for the attribute, where:. This parameter is required.
             *                      <ul>
             *                      <li><code>S</code> - the attribute is of type String</li>
             *                      <li><code>N</code> - the attribute is of type Number</li>
             *                      <li><code>B</code> - the attribute is of type Binary</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeType(java.lang.String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDefinitionProperty {
            private final java.lang.String attributeName;
            private final java.lang.String attributeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeType = software.amazon.jsii.Kernel.get(this, "attributeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.attributeType = java.util.Objects.requireNonNull(builder.attributeType, "attributeType is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getAttributeType() {
                return this.attributeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("attributeType", om.valueToTree(this.getAttributeType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.AttributeDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDefinitionProperty.Jsii$Proxy that = (AttributeDefinitionProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.attributeType.equals(that.attributeType);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.attributeType.hashCode());
                return result;
            }
        }
    }
    /**
     * Configures a scalable target and an autoscaling policy for a table or global secondary index's read or write capacity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * CapacityAutoScalingSettingsProperty capacityAutoScalingSettingsProperty = CapacityAutoScalingSettingsProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                 .targetValue(123)
     *                 // the properties below are optional
     *                 .disableScaleIn(false)
     *                 .scaleInCooldown(123)
     *                 .scaleOutCooldown(123)
     *                 .build())
     *         // the properties below are optional
     *         .seedCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityAutoScalingSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityAutoScalingSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum provisioned capacity units for the global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * The minimum provisioned capacity units for the global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-mincapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * Defines a target tracking scaling policy.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-targettrackingscalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-targettrackingscalingpolicyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTargetTrackingScalingPolicyConfiguration();

        /**
         * When switching billing mode from <code>PAY_PER_REQUEST</code> to <code>PROVISIONED</code> , DynamoDB requires you to specify read and write capacity unit values for the table and for each global secondary index.
         * <p>
         * These values will be applied to all replicas. The table will use these provisioned values until CloudFormation creates the autoscaling policies you configured in your template. CloudFormation cannot determine what capacity the table and its global secondary indexes will require in this time period, since they are application-dependent.
         * <p>
         * If you want to switch a table's billing mode from <code>PAY_PER_REQUEST</code> to <code>PROVISIONED</code> , you must specify a value for this property for each autoscaled resource. If you specify different values for the same resource in different regions, CloudFormation will use the highest value found in either the <code>SeedCapacity</code> or <code>ReadCapacityUnits</code> properties. For example, if your global secondary index <code>myGSI</code> has a <code>SeedCapacity</code> of 10 in us-east-1 and a fixed <code>ReadCapacityUnits</code> of 20 in eu-west-1, CloudFormation will initially set the read capacity for <code>myGSI</code> to 20. Note that if you disable <code>ScaleIn</code> for <code>myGSI</code> in us-east-1, its read capacity units might not be set back to 10.
         * <p>
         * You must also specify a value for <code>SeedCapacity</code> when you plan to switch a table's billing mode from <code>PROVISIONED</code> to <code>PAY_PER_REQUEST</code> , because CloudFormation might need to roll back the operation (reverting the billing mode to <code>PROVISIONED</code> ) and this cannot succeed without specifying a value for <code>SeedCapacity</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-seedcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-capacityautoscalingsettings.html#cfn-dynamodb-globaltable-capacityautoscalingsettings-seedcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSeedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityAutoScalingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityAutoScalingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityAutoScalingSettingsProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;
            java.lang.Object targetTrackingScalingPolicyConfiguration;
            java.lang.Number seedCapacity;

            /**
             * Sets the value of {@link CapacityAutoScalingSettingsProperty#getMaxCapacity}
             * @param maxCapacity The maximum provisioned capacity units for the global table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link CapacityAutoScalingSettingsProperty#getMinCapacity}
             * @param minCapacity The minimum provisioned capacity units for the global table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of {@link CapacityAutoScalingSettingsProperty#getTargetTrackingScalingPolicyConfiguration}
             * @param targetTrackingScalingPolicyConfiguration Defines a target tracking scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.IResolvable targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CapacityAutoScalingSettingsProperty#getTargetTrackingScalingPolicyConfiguration}
             * @param targetTrackingScalingPolicyConfiguration Defines a target tracking scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTrackingScalingPolicyConfiguration(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CapacityAutoScalingSettingsProperty#getSeedCapacity}
             * @param seedCapacity When switching billing mode from <code>PAY_PER_REQUEST</code> to <code>PROVISIONED</code> , DynamoDB requires you to specify read and write capacity unit values for the table and for each global secondary index.
             *                     These values will be applied to all replicas. The table will use these provisioned values until CloudFormation creates the autoscaling policies you configured in your template. CloudFormation cannot determine what capacity the table and its global secondary indexes will require in this time period, since they are application-dependent.
             *                     <p>
             *                     If you want to switch a table's billing mode from <code>PAY_PER_REQUEST</code> to <code>PROVISIONED</code> , you must specify a value for this property for each autoscaled resource. If you specify different values for the same resource in different regions, CloudFormation will use the highest value found in either the <code>SeedCapacity</code> or <code>ReadCapacityUnits</code> properties. For example, if your global secondary index <code>myGSI</code> has a <code>SeedCapacity</code> of 10 in us-east-1 and a fixed <code>ReadCapacityUnits</code> of 20 in eu-west-1, CloudFormation will initially set the read capacity for <code>myGSI</code> to 20. Note that if you disable <code>ScaleIn</code> for <code>myGSI</code> in us-east-1, its read capacity units might not be set back to 10.
             *                     <p>
             *                     You must also specify a value for <code>SeedCapacity</code> when you plan to switch a table's billing mode from <code>PROVISIONED</code> to <code>PAY_PER_REQUEST</code> , because CloudFormation might need to roll back the operation (reverting the billing mode to <code>PROVISIONED</code> ) and this cannot succeed without specifying a value for <code>SeedCapacity</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedCapacity(java.lang.Number seedCapacity) {
                this.seedCapacity = seedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityAutoScalingSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityAutoScalingSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityAutoScalingSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityAutoScalingSettingsProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.Object targetTrackingScalingPolicyConfiguration;
            private final java.lang.Number seedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetTrackingScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "targetTrackingScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.seedCapacity = software.amazon.jsii.Kernel.get(this, "seedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
                this.targetTrackingScalingPolicyConfiguration = java.util.Objects.requireNonNull(builder.targetTrackingScalingPolicyConfiguration, "targetTrackingScalingPolicyConfiguration is required");
                this.seedCapacity = builder.seedCapacity;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public final java.lang.Object getTargetTrackingScalingPolicyConfiguration() {
                return this.targetTrackingScalingPolicyConfiguration;
            }

            @Override
            public final java.lang.Number getSeedCapacity() {
                return this.seedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                data.set("targetTrackingScalingPolicyConfiguration", om.valueToTree(this.getTargetTrackingScalingPolicyConfiguration()));
                if (this.getSeedCapacity() != null) {
                    data.set("seedCapacity", om.valueToTree(this.getSeedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityAutoScalingSettingsProperty.Jsii$Proxy that = (CapacityAutoScalingSettingsProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                if (!minCapacity.equals(that.minCapacity)) return false;
                if (!targetTrackingScalingPolicyConfiguration.equals(that.targetTrackingScalingPolicyConfiguration)) return false;
                return this.seedCapacity != null ? this.seedCapacity.equals(that.seedCapacity) : that.seedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                result = 31 * result + (this.targetTrackingScalingPolicyConfiguration.hashCode());
                result = 31 * result + (this.seedCapacity != null ? this.seedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures contributor insights settings for a replica or one of its indexes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ContributorInsightsSpecificationProperty contributorInsightsSpecificationProperty = ContributorInsightsSpecificationProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .mode("mode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ContributorInsightsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContributorInsightsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html#cfn-dynamodb-globaltable-contributorinsightsspecification-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html#cfn-dynamodb-globaltable-contributorinsightsspecification-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Specifies the CloudWatch Contributor Insights mode for a global table.
         * <p>
         * Valid values are <code>ACCESSED_AND_THROTTLED_KEYS</code> (tracks all access and throttled events) or <code>THROTTLED_KEYS</code> (tracks only throttled events). This setting determines what type of contributor insights data is collected for the global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html#cfn-dynamodb-globaltable-contributorinsightsspecification-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-contributorinsightsspecification.html#cfn-dynamodb-globaltable-contributorinsightsspecification-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContributorInsightsSpecificationProperty> {
            java.lang.Object enabled;
            java.lang.String mode;

            /**
             * Sets the value of {@link ContributorInsightsSpecificationProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContributorInsightsSpecificationProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContributorInsightsSpecificationProperty#getMode}
             * @param mode Specifies the CloudWatch Contributor Insights mode for a global table.
             *             Valid values are <code>ACCESSED_AND_THROTTLED_KEYS</code> (tracks all access and throttled events) or <code>THROTTLED_KEYS</code> (tracks only throttled events). This setting determines what type of contributor insights data is collected for the global table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContributorInsightsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContributorInsightsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContributorInsightsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContributorInsightsSpecificationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String mode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.mode = builder.mode;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContributorInsightsSpecificationProperty.Jsii$Proxy that = (ContributorInsightsSpecificationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows you to specify a global secondary index for the global table.
     * <p>
     * The index will be defined on all replicas.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * GlobalSecondaryIndexProperty globalSecondaryIndexProperty = GlobalSecondaryIndexProperty.builder()
     *         .indexName("indexName")
     *         .keySchema(List.of(KeySchemaProperty.builder()
     *                 .attributeName("attributeName")
     *                 .keyType("keyType")
     *                 .build()))
     *         .projection(ProjectionProperty.builder()
     *                 .nonKeyAttributes(List.of("nonKeyAttributes"))
     *                 .projectionType("projectionType")
     *                 .build())
     *         // the properties below are optional
     *         .warmThroughput(WarmThroughputProperty.builder()
     *                 .readUnitsPerSecond(123)
     *                 .writeUnitsPerSecond(123)
     *                 .build())
     *         .writeOnDemandThroughputSettings(WriteOnDemandThroughputSettingsProperty.builder()
     *                 .maxWriteRequestUnits(123)
     *                 .build())
     *         .writeProvisionedThroughputSettings(WriteProvisionedThroughputSettingsProperty.builder()
     *                 .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                         .maxCapacity(123)
     *                         .minCapacity(123)
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .seedCapacity(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalSecondaryIndexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the global secondary index.
         * <p>
         * The name must be unique among all other indexes on this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> .
         * <p>
         * The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * <blockquote>
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KeySchemaProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-keyschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

        /**
         * Represents attributes that are copied (projected) from the table into the global secondary index.
         * <p>
         * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ProjectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-projection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-projection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProjection();

        /**
         * Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
         * <p>
         * If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WarmThroughputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-warmthroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWarmThroughput() {
            return null;
        }

        /**
         * Sets the write request settings for a global table or a global secondary index.
         * <p>
         * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-writeondemandthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-writeondemandthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteOnDemandThroughputSettings() {
            return null;
        }

        /**
         * Defines write capacity settings for the global secondary index.
         * <p>
         * You must specify a value for this property if the table's <code>BillingMode</code> is <code>PROVISIONED</code> . All replicas will have the same write capacity settings for this global secondary index.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-writeprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globalsecondaryindex.html#cfn-dynamodb-globaltable-globalsecondaryindex-writeprovisionedthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteProvisionedThroughputSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalSecondaryIndexProperty> {
            java.lang.String indexName;
            java.lang.Object keySchema;
            java.lang.Object projection;
            java.lang.Object warmThroughput;
            java.lang.Object writeOnDemandThroughputSettings;
            java.lang.Object writeProvisionedThroughputSettings;

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getIndexName}
             * @param indexName The name of the global secondary index. This parameter is required.
             *                  The name must be unique among all other indexes on this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(software.amazon.awscdk.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the global secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the global secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWarmThroughput}
             * @param warmThroughput Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
             *                       If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmThroughput(software.amazon.awscdk.IResolvable warmThroughput) {
                this.warmThroughput = warmThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWarmThroughput}
             * @param warmThroughput Represents the warm throughput value (in read units per second and write units per second) for the specified secondary index.
             *                       If you use this parameter, you must specify <code>ReadUnitsPerSecond</code> , <code>WriteUnitsPerSecond</code> , or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmThroughput(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WarmThroughputProperty warmThroughput) {
                this.warmThroughput = warmThroughput;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWriteOnDemandThroughputSettings}
             * @param writeOnDemandThroughputSettings Sets the write request settings for a global table or a global secondary index.
             *                                        You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOnDemandThroughputSettings(software.amazon.awscdk.IResolvable writeOnDemandThroughputSettings) {
                this.writeOnDemandThroughputSettings = writeOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWriteOnDemandThroughputSettings}
             * @param writeOnDemandThroughputSettings Sets the write request settings for a global table or a global secondary index.
             *                                        You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOnDemandThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty writeOnDemandThroughputSettings) {
                this.writeOnDemandThroughputSettings = writeOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWriteProvisionedThroughputSettings}
             * @param writeProvisionedThroughputSettings Defines write capacity settings for the global secondary index.
             *                                           You must specify a value for this property if the table's <code>BillingMode</code> is <code>PROVISIONED</code> . All replicas will have the same write capacity settings for this global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeProvisionedThroughputSettings(software.amazon.awscdk.IResolvable writeProvisionedThroughputSettings) {
                this.writeProvisionedThroughputSettings = writeProvisionedThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link GlobalSecondaryIndexProperty#getWriteProvisionedThroughputSettings}
             * @param writeProvisionedThroughputSettings Defines write capacity settings for the global secondary index.
             *                                           You must specify a value for this property if the table's <code>BillingMode</code> is <code>PROVISIONED</code> . All replicas will have the same write capacity settings for this global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeProvisionedThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty writeProvisionedThroughputSettings) {
                this.writeProvisionedThroughputSettings = writeProvisionedThroughputSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalSecondaryIndexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;
            private final java.lang.Object warmThroughput;
            private final java.lang.Object writeOnDemandThroughputSettings;
            private final java.lang.Object writeProvisionedThroughputSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projection = software.amazon.jsii.Kernel.get(this, "projection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warmThroughput = software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeOnDemandThroughputSettings = software.amazon.jsii.Kernel.get(this, "writeOnDemandThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeProvisionedThroughputSettings = software.amazon.jsii.Kernel.get(this, "writeProvisionedThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(builder.projection, "projection is required");
                this.warmThroughput = builder.warmThroughput;
                this.writeOnDemandThroughputSettings = builder.writeOnDemandThroughputSettings;
                this.writeProvisionedThroughputSettings = builder.writeProvisionedThroughputSettings;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public final java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            public final java.lang.Object getWarmThroughput() {
                return this.warmThroughput;
            }

            @Override
            public final java.lang.Object getWriteOnDemandThroughputSettings() {
                return this.writeOnDemandThroughputSettings;
            }

            @Override
            public final java.lang.Object getWriteProvisionedThroughputSettings() {
                return this.writeProvisionedThroughputSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("keySchema", om.valueToTree(this.getKeySchema()));
                data.set("projection", om.valueToTree(this.getProjection()));
                if (this.getWarmThroughput() != null) {
                    data.set("warmThroughput", om.valueToTree(this.getWarmThroughput()));
                }
                if (this.getWriteOnDemandThroughputSettings() != null) {
                    data.set("writeOnDemandThroughputSettings", om.valueToTree(this.getWriteOnDemandThroughputSettings()));
                }
                if (this.getWriteProvisionedThroughputSettings() != null) {
                    data.set("writeProvisionedThroughputSettings", om.valueToTree(this.getWriteProvisionedThroughputSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.GlobalSecondaryIndexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalSecondaryIndexProperty.Jsii$Proxy that = (GlobalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                if (!projection.equals(that.projection)) return false;
                if (this.warmThroughput != null ? !this.warmThroughput.equals(that.warmThroughput) : that.warmThroughput != null) return false;
                if (this.writeOnDemandThroughputSettings != null ? !this.writeOnDemandThroughputSettings.equals(that.writeOnDemandThroughputSettings) : that.writeOnDemandThroughputSettings != null) return false;
                return this.writeProvisionedThroughputSettings != null ? this.writeProvisionedThroughputSettings.equals(that.writeProvisionedThroughputSettings) : that.writeProvisionedThroughputSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                result = 31 * result + (this.warmThroughput != null ? this.warmThroughput.hashCode() : 0);
                result = 31 * result + (this.writeOnDemandThroughputSettings != null ? this.writeOnDemandThroughputSettings.hashCode() : 0);
                result = 31 * result + (this.writeProvisionedThroughputSettings != null ? this.writeProvisionedThroughputSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The witness Region for the MRSC global table.
     * <p>
     * A MRSC global table can be configured with either three replicas, or with two replicas and one witness.
     * <p>
     * The witness must be in a different Region than the replicas and within the same Region set:
     * <p>
     * <ul>
     * <li>US Region set: US East (N. Virginia), US East (Ohio), US West (Oregon)</li>
     * <li>EU Region set: Europe (Ireland), Europe (London), Europe (Paris), Europe (Frankfurt)</li>
     * <li>AP Region set: Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Osaka)</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * GlobalTableWitnessProperty globalTableWitnessProperty = GlobalTableWitnessProperty.builder()
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globaltablewitness.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globaltablewitness.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.GlobalTableWitnessProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalTableWitnessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalTableWitnessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS Region that serves as a witness for the MRSC global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globaltablewitness.html#cfn-dynamodb-globaltable-globaltablewitness-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-globaltablewitness.html#cfn-dynamodb-globaltable-globaltablewitness-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalTableWitnessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalTableWitnessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalTableWitnessProperty> {
            java.lang.String region;

            /**
             * Sets the value of {@link GlobalTableWitnessProperty#getRegion}
             * @param region The name of the AWS Region that serves as a witness for the MRSC global table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalTableWitnessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalTableWitnessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalTableWitnessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalTableWitnessProperty {
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.GlobalTableWitnessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalTableWitnessProperty.Jsii$Proxy that = (GlobalTableWitnessProperty.Jsii$Proxy) o;

                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region != null ? this.region.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents <em>a single element</em> of a key schema.
     * <p>
     * A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.
     * <p>
     * A <code>KeySchemaElement</code> represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one <code>KeySchemaElement</code> (for the partition key). A composite primary key would require one <code>KeySchemaElement</code> for the partition key, and another <code>KeySchemaElement</code> for the sort key.
     * <p>
     * A <code>KeySchemaElement</code> must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * KeySchemaProperty keySchemaProperty = KeySchemaProperty.builder()
     *         .attributeName("attributeName")
     *         .keyType("keyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.KeySchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(KeySchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeySchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a key attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The role that this key attribute will assume:.
         * <p>
         * <ul>
         * <li><code>HASH</code> - partition key</li>
         * <li><code>RANGE</code> - sort key</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The partition key of an item is also known as its <em>hash attribute</em> . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-keyschema.html#cfn-dynamodb-globaltable-keyschema-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyType();

        /**
         * @return a {@link Builder} of {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeySchemaProperty> {
            java.lang.String attributeName;
            java.lang.String keyType;

            /**
             * Sets the value of {@link KeySchemaProperty#getAttributeName}
             * @param attributeName The name of a key attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link KeySchemaProperty#getKeyType}
             * @param keyType The role that this key attribute will assume:. This parameter is required.
             *                <ul>
             *                <li><code>HASH</code> - partition key</li>
             *                <li><code>RANGE</code> - sort key</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                The partition key of an item is also known as its <em>hash attribute</em> . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                <p>
             *                The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeySchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeySchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeySchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySchemaProperty {
            private final java.lang.String attributeName;
            private final java.lang.String keyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.keyType = java.util.Objects.requireNonNull(builder.keyType, "keyType is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("keyType", om.valueToTree(this.getKeyType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.KeySchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeySchemaProperty.Jsii$Proxy that = (KeySchemaProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.keyType.equals(that.keyType);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.keyType.hashCode());
                return result;
            }
        }
    }
    /**
     * The Kinesis Data Streams configuration for the specified global table replica.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * KinesisStreamSpecificationProperty kinesisStreamSpecificationProperty = KinesisStreamSpecificationProperty.builder()
     *         .streamArn("streamArn")
     *         // the properties below are optional
     *         .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.KinesisStreamSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for a specific Kinesis data stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html#cfn-dynamodb-globaltable-kinesisstreamspecification-streamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html#cfn-dynamodb-globaltable-kinesisstreamspecification-streamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

        /**
         * The precision for the time and date that the stream was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html#cfn-dynamodb-globaltable-kinesisstreamspecification-approximatecreationdatetimeprecision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-kinesisstreamspecification.html#cfn-dynamodb-globaltable-kinesisstreamspecification-approximatecreationdatetimeprecision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApproximateCreationDateTimePrecision() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamSpecificationProperty> {
            java.lang.String streamArn;
            java.lang.String approximateCreationDateTimePrecision;

            /**
             * Sets the value of {@link KinesisStreamSpecificationProperty#getStreamArn}
             * @param streamArn The ARN for a specific Kinesis data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamSpecificationProperty#getApproximateCreationDateTimePrecision}
             * @param approximateCreationDateTimePrecision The precision for the time and date that the stream was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approximateCreationDateTimePrecision(java.lang.String approximateCreationDateTimePrecision) {
                this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamSpecificationProperty {
            private final java.lang.String streamArn;
            private final java.lang.String approximateCreationDateTimePrecision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.approximateCreationDateTimePrecision = software.amazon.jsii.Kernel.get(this, "approximateCreationDateTimePrecision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamArn = java.util.Objects.requireNonNull(builder.streamArn, "streamArn is required");
                this.approximateCreationDateTimePrecision = builder.approximateCreationDateTimePrecision;
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            public final java.lang.String getApproximateCreationDateTimePrecision() {
                return this.approximateCreationDateTimePrecision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamArn", om.valueToTree(this.getStreamArn()));
                if (this.getApproximateCreationDateTimePrecision() != null) {
                    data.set("approximateCreationDateTimePrecision", om.valueToTree(this.getApproximateCreationDateTimePrecision()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.KinesisStreamSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamSpecificationProperty.Jsii$Proxy that = (KinesisStreamSpecificationProperty.Jsii$Proxy) o;

                if (!streamArn.equals(that.streamArn)) return false;
                return this.approximateCreationDateTimePrecision != null ? this.approximateCreationDateTimePrecision.equals(that.approximateCreationDateTimePrecision) : that.approximateCreationDateTimePrecision == null;
            }

            @Override
            public final int hashCode() {
                int result = this.streamArn.hashCode();
                result = 31 * result + (this.approximateCreationDateTimePrecision != null ? this.approximateCreationDateTimePrecision.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the properties of a local secondary index.
     * <p>
     * A local secondary index can only be created when its parent table is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * LocalSecondaryIndexProperty localSecondaryIndexProperty = LocalSecondaryIndexProperty.builder()
     *         .indexName("indexName")
     *         .keySchema(List.of(KeySchemaProperty.builder()
     *                 .attributeName("attributeName")
     *                 .keyType("keyType")
     *                 .build()))
     *         .projection(ProjectionProperty.builder()
     *                 .nonKeyAttributes(List.of("nonKeyAttributes"))
     *                 .projectionType("projectionType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.LocalSecondaryIndexProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalSecondaryIndexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalSecondaryIndexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the local secondary index.
         * <p>
         * The name must be unique among all other indexes on this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> .
         * <p>
         * The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         * <p>
         * <blockquote>
         * <p>
         * The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         * <p>
         * </blockquote>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KeySchemaProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-keyschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

        /**
         * Represents attributes that are copied (projected) from the table into the local secondary index.
         * <p>
         * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ProjectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-projection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-localsecondaryindex.html#cfn-dynamodb-globaltable-localsecondaryindex-projection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProjection();

        /**
         * @return a {@link Builder} of {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalSecondaryIndexProperty> {
            java.lang.String indexName;
            java.lang.Object keySchema;
            java.lang.Object projection;

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getIndexName}
             * @param indexName The name of the local secondary index. This parameter is required.
             *                  The name must be unique among all other indexes on this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(software.amazon.awscdk.IResolvable keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getKeySchema}
             * @param keySchema The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:  - <code>HASH</code> - partition key - <code>RANGE</code> - sort key  &gt; The partition key of an item is also known as its <em>hash attribute</em> . This parameter is required.
             *                  The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  The sort key of an item is also known as its <em>range attribute</em> . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
                this.keySchema = keySchema;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the local secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.IResolvable projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Sets the value of {@link LocalSecondaryIndexProperty#getProjection}
             * @param projection Represents attributes that are copied (projected) from the table into the local secondary index. This parameter is required.
             *                   These are in addition to the primary key attributes and index key attributes, which are automatically projected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projection(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ProjectionProperty projection) {
                this.projection = projection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalSecondaryIndexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalSecondaryIndexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalSecondaryIndexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalSecondaryIndexProperty {
            private final java.lang.String indexName;
            private final java.lang.Object keySchema;
            private final java.lang.Object projection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projection = software.amazon.jsii.Kernel.get(this, "projection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
                this.projection = java.util.Objects.requireNonNull(builder.projection, "projection is required");
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.Object getKeySchema() {
                return this.keySchema;
            }

            @Override
            public final java.lang.Object getProjection() {
                return this.projection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("keySchema", om.valueToTree(this.getKeySchema()));
                data.set("projection", om.valueToTree(this.getProjection()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.LocalSecondaryIndexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalSecondaryIndexProperty.Jsii$Proxy that = (LocalSecondaryIndexProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!keySchema.equals(that.keySchema)) return false;
                return this.projection.equals(that.projection);
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.keySchema.hashCode());
                result = 31 * result + (this.projection.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents the settings used to enable point in time recovery.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecificationProperty = PointInTimeRecoverySpecificationProperty.builder()
     *         .pointInTimeRecoveryEnabled(false)
     *         .recoveryPeriodInDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.PointInTimeRecoverySpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PointInTimeRecoverySpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PointInTimeRecoverySpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html#cfn-dynamodb-globaltable-pointintimerecoveryspecification-pointintimerecoveryenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html#cfn-dynamodb-globaltable-pointintimerecoveryspecification-pointintimerecoveryenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoveryEnabled() {
            return null;
        }

        /**
         * The number of preceding days for which continuous backups are taken and maintained.
         * <p>
         * Your table data is only recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If no value is provided, the value will default to 35.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html#cfn-dynamodb-globaltable-pointintimerecoveryspecification-recoveryperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-pointintimerecoveryspecification.html#cfn-dynamodb-globaltable-pointintimerecoveryspecification-recoveryperiodindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryPeriodInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PointInTimeRecoverySpecificationProperty> {
            java.lang.Object pointInTimeRecoveryEnabled;
            java.lang.Number recoveryPeriodInDays;

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getPointInTimeRecoveryEnabled}
             * @param pointInTimeRecoveryEnabled Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoveryEnabled(java.lang.Boolean pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getPointInTimeRecoveryEnabled}
             * @param pointInTimeRecoveryEnabled Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoveryEnabled(software.amazon.awscdk.IResolvable pointInTimeRecoveryEnabled) {
                this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PointInTimeRecoverySpecificationProperty#getRecoveryPeriodInDays}
             * @param recoveryPeriodInDays The number of preceding days for which continuous backups are taken and maintained.
             *                             Your table data is only recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If no value is provided, the value will default to 35.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryPeriodInDays(java.lang.Number recoveryPeriodInDays) {
                this.recoveryPeriodInDays = recoveryPeriodInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointInTimeRecoverySpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PointInTimeRecoverySpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PointInTimeRecoverySpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PointInTimeRecoverySpecificationProperty {
            private final java.lang.Object pointInTimeRecoveryEnabled;
            private final java.lang.Number recoveryPeriodInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pointInTimeRecoveryEnabled = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recoveryPeriodInDays = software.amazon.jsii.Kernel.get(this, "recoveryPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pointInTimeRecoveryEnabled = builder.pointInTimeRecoveryEnabled;
                this.recoveryPeriodInDays = builder.recoveryPeriodInDays;
            }

            @Override
            public final java.lang.Object getPointInTimeRecoveryEnabled() {
                return this.pointInTimeRecoveryEnabled;
            }

            @Override
            public final java.lang.Number getRecoveryPeriodInDays() {
                return this.recoveryPeriodInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPointInTimeRecoveryEnabled() != null) {
                    data.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
                }
                if (this.getRecoveryPeriodInDays() != null) {
                    data.set("recoveryPeriodInDays", om.valueToTree(this.getRecoveryPeriodInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.PointInTimeRecoverySpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PointInTimeRecoverySpecificationProperty.Jsii$Proxy that = (PointInTimeRecoverySpecificationProperty.Jsii$Proxy) o;

                if (this.pointInTimeRecoveryEnabled != null ? !this.pointInTimeRecoveryEnabled.equals(that.pointInTimeRecoveryEnabled) : that.pointInTimeRecoveryEnabled != null) return false;
                return this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.equals(that.recoveryPeriodInDays) : that.recoveryPeriodInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pointInTimeRecoveryEnabled != null ? this.pointInTimeRecoveryEnabled.hashCode() : 0;
                result = 31 * result + (this.recoveryPeriodInDays != null ? this.recoveryPeriodInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents attributes that are copied (projected) from the table into an index.
     * <p>
     * These are in addition to the primary key attributes and index key attributes, which are automatically projected.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ProjectionProperty projectionProperty = ProjectionProperty.builder()
     *         .nonKeyAttributes(List.of("nonKeyAttributes"))
     *         .projectionType("projectionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ProjectionProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the non-key attribute names which will be projected into the index.
         * <p>
         * For global and local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total. This limit only applies when you specify the ProjectionType of <code>INCLUDE</code> . You still can specify the ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table has more than 100 attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-nonkeyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-nonkeyattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNonKeyAttributes() {
            return null;
        }

        /**
         * The set of attributes that are projected into the index:.
         * <p>
         * <ul>
         * <li><code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</li>
         * <li><code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code> , the secondary index will include other non-key attributes that you specify.</li>
         * <li><code>ALL</code> - All of the table attributes are projected into the index.</li>
         * </ul>
         * <p>
         * When using the DynamoDB console, <code>ALL</code> is selected by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-projectiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-projection.html#cfn-dynamodb-globaltable-projection-projectiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProjectionType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectionProperty> {
            java.util.List<java.lang.String> nonKeyAttributes;
            java.lang.String projectionType;

            /**
             * Sets the value of {@link ProjectionProperty#getNonKeyAttributes}
             * @param nonKeyAttributes Represents the non-key attribute names which will be projected into the index.
             *                         For global and local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total. This limit only applies when you specify the ProjectionType of <code>INCLUDE</code> . You still can specify the ProjectionType of <code>ALL</code> to project all attributes from the source table, even if the table has more than 100 attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
                this.nonKeyAttributes = nonKeyAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ProjectionProperty#getProjectionType}
             * @param projectionType The set of attributes that are projected into the index:.
             *                       <ul>
             *                       <li><code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</li>
             *                       <li><code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code> , the secondary index will include other non-key attributes that you specify.</li>
             *                       <li><code>ALL</code> - All of the table attributes are projected into the index.</li>
             *                       </ul>
             *                       <p>
             *                       When using the DynamoDB console, <code>ALL</code> is selected by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectionType(java.lang.String projectionType) {
                this.projectionType = projectionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectionProperty {
            private final java.util.List<java.lang.String> nonKeyAttributes;
            private final java.lang.String projectionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nonKeyAttributes = builder.nonKeyAttributes;
                this.projectionType = builder.projectionType;
            }

            @Override
            public final java.util.List<java.lang.String> getNonKeyAttributes() {
                return this.nonKeyAttributes;
            }

            @Override
            public final java.lang.String getProjectionType() {
                return this.projectionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNonKeyAttributes() != null) {
                    data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
                }
                if (this.getProjectionType() != null) {
                    data.set("projectionType", om.valueToTree(this.getProjectionType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ProjectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectionProperty.Jsii$Proxy that = (ProjectionProperty.Jsii$Proxy) o;

                if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
                return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0;
                result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets the read request settings for a replica table or a replica global secondary index.
     * <p>
     * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ReadOnDemandThroughputSettingsProperty readOnDemandThroughputSettingsProperty = ReadOnDemandThroughputSettingsProperty.builder()
     *         .maxReadRequestUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readondemandthroughputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readondemandthroughputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReadOnDemandThroughputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReadOnDemandThroughputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of read request units for the specified replica of a global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readondemandthroughputsettings.html#cfn-dynamodb-globaltable-readondemandthroughputsettings-maxreadrequestunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readondemandthroughputsettings.html#cfn-dynamodb-globaltable-readondemandthroughputsettings-maxreadrequestunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReadOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReadOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReadOnDemandThroughputSettingsProperty> {
            java.lang.Number maxReadRequestUnits;

            /**
             * Sets the value of {@link ReadOnDemandThroughputSettingsProperty#getMaxReadRequestUnits}
             * @param maxReadRequestUnits Maximum number of read request units for the specified replica of a global table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
                this.maxReadRequestUnits = maxReadRequestUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReadOnDemandThroughputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReadOnDemandThroughputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReadOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReadOnDemandThroughputSettingsProperty {
            private final java.lang.Number maxReadRequestUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxReadRequestUnits = builder.maxReadRequestUnits;
            }

            @Override
            public final java.lang.Number getMaxReadRequestUnits() {
                return this.maxReadRequestUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxReadRequestUnits() != null) {
                    data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReadOnDemandThroughputSettingsProperty.Jsii$Proxy that = (ReadOnDemandThroughputSettingsProperty.Jsii$Proxy) o;

                return this.maxReadRequestUnits != null ? this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Allows you to specify the read capacity settings for a replica table or a replica global secondary index when the <code>BillingMode</code> is set to <code>PROVISIONED</code> .
     * <p>
     * You must specify a value for either <code>ReadCapacityUnits</code> or <code>ReadCapacityAutoScalingSettings</code> , but not both. You can switch between fixed capacity and auto scaling.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ReadProvisionedThroughputSettingsProperty readProvisionedThroughputSettingsProperty = ReadProvisionedThroughputSettingsProperty.builder()
     *         .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                         .targetValue(123)
     *                         // the properties below are optional
     *                         .disableScaleIn(false)
     *                         .scaleInCooldown(123)
     *                         .scaleOutCooldown(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .seedCapacity(123)
     *                 .build())
     *         .readCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReadProvisionedThroughputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReadProvisionedThroughputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies auto scaling settings for the replica table or global secondary index.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityautoscalingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityautoscalingsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadCapacityAutoScalingSettings() {
            return null;
        }

        /**
         * Specifies a fixed read capacity for the replica table or global secondary index.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-readprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-readprovisionedthroughputsettings-readcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReadCapacityUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReadProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReadProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReadProvisionedThroughputSettingsProperty> {
            java.lang.Object readCapacityAutoScalingSettings;
            java.lang.Number readCapacityUnits;

            /**
             * Sets the value of {@link ReadProvisionedThroughputSettingsProperty#getReadCapacityAutoScalingSettings}
             * @param readCapacityAutoScalingSettings Specifies auto scaling settings for the replica table or global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScalingSettings(software.amazon.awscdk.IResolvable readCapacityAutoScalingSettings) {
                this.readCapacityAutoScalingSettings = readCapacityAutoScalingSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReadProvisionedThroughputSettingsProperty#getReadCapacityAutoScalingSettings}
             * @param readCapacityAutoScalingSettings Specifies auto scaling settings for the replica table or global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityAutoScalingSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty readCapacityAutoScalingSettings) {
                this.readCapacityAutoScalingSettings = readCapacityAutoScalingSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReadProvisionedThroughputSettingsProperty#getReadCapacityUnits}
             * @param readCapacityUnits Specifies a fixed read capacity for the replica table or global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReadProvisionedThroughputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReadProvisionedThroughputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReadProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReadProvisionedThroughputSettingsProperty {
            private final java.lang.Object readCapacityAutoScalingSettings;
            private final java.lang.Number readCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readCapacityAutoScalingSettings = software.amazon.jsii.Kernel.get(this, "readCapacityAutoScalingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readCapacityUnits = software.amazon.jsii.Kernel.get(this, "readCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityAutoScalingSettings = builder.readCapacityAutoScalingSettings;
                this.readCapacityUnits = builder.readCapacityUnits;
            }

            @Override
            public final java.lang.Object getReadCapacityAutoScalingSettings() {
                return this.readCapacityAutoScalingSettings;
            }

            @Override
            public final java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReadCapacityAutoScalingSettings() != null) {
                    data.set("readCapacityAutoScalingSettings", om.valueToTree(this.getReadCapacityAutoScalingSettings()));
                }
                if (this.getReadCapacityUnits() != null) {
                    data.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReadProvisionedThroughputSettingsProperty.Jsii$Proxy that = (ReadProvisionedThroughputSettingsProperty.Jsii$Proxy) o;

                if (this.readCapacityAutoScalingSettings != null ? !this.readCapacityAutoScalingSettings.equals(that.readCapacityAutoScalingSettings) : that.readCapacityAutoScalingSettings != null) return false;
                return this.readCapacityUnits != null ? this.readCapacityUnits.equals(that.readCapacityUnits) : that.readCapacityUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.readCapacityAutoScalingSettings != null ? this.readCapacityAutoScalingSettings.hashCode() : 0;
                result = 31 * result + (this.readCapacityUnits != null ? this.readCapacityUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the properties of a global secondary index that can be set on a per-replica basis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ReplicaGlobalSecondaryIndexSpecificationProperty replicaGlobalSecondaryIndexSpecificationProperty = ReplicaGlobalSecondaryIndexSpecificationProperty.builder()
     *         .indexName("indexName")
     *         // the properties below are optional
     *         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .mode("mode")
     *                 .build())
     *         .readOnDemandThroughputSettings(ReadOnDemandThroughputSettingsProperty.builder()
     *                 .maxReadRequestUnits(123)
     *                 .build())
     *         .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
     *                 .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                         .maxCapacity(123)
     *                         .minCapacity(123)
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .seedCapacity(123)
     *                         .build())
     *                 .readCapacityUnits(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaGlobalSecondaryIndexSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaGlobalSecondaryIndexSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the global secondary index.
         * <p>
         * The name must be unique among all other indexes on this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * Updates the status for contributor insights for a specific table or index.
         * <p>
         * CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of AWS Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an AWS managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-contributorinsightsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-contributorinsightsspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsSpecification() {
            return null;
        }

        /**
         * Sets the read request settings for a replica global secondary index.
         * <p>
         * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-readondemandthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-readondemandthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnDemandThroughputSettings() {
            return null;
        }

        /**
         * Allows you to specify the read capacity settings for a replica global secondary index when the <code>BillingMode</code> is set to <code>PROVISIONED</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-readprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaglobalsecondaryindexspecification.html#cfn-dynamodb-globaltable-replicaglobalsecondaryindexspecification-readprovisionedthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadProvisionedThroughputSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicaGlobalSecondaryIndexSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaGlobalSecondaryIndexSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaGlobalSecondaryIndexSpecificationProperty> {
            java.lang.String indexName;
            java.lang.Object contributorInsightsSpecification;
            java.lang.Object readOnDemandThroughputSettings;
            java.lang.Object readProvisionedThroughputSettings;

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getIndexName}
             * @param indexName The name of the global secondary index. This parameter is required.
             *                  The name must be unique among all other indexes on this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification Updates the status for contributor insights for a specific table or index.
             *                                         CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of AWS Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an AWS managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.IResolvable contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification Updates the status for contributor insights for a specific table or index.
             *                                         CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of AWS Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an AWS managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getReadOnDemandThroughputSettings}
             * @param readOnDemandThroughputSettings Sets the read request settings for a replica global secondary index.
             *                                       You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnDemandThroughputSettings(software.amazon.awscdk.IResolvable readOnDemandThroughputSettings) {
                this.readOnDemandThroughputSettings = readOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getReadOnDemandThroughputSettings}
             * @param readOnDemandThroughputSettings Sets the read request settings for a replica global secondary index.
             *                                       You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnDemandThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty readOnDemandThroughputSettings) {
                this.readOnDemandThroughputSettings = readOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getReadProvisionedThroughputSettings}
             * @param readProvisionedThroughputSettings Allows you to specify the read capacity settings for a replica global secondary index when the <code>BillingMode</code> is set to <code>PROVISIONED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readProvisionedThroughputSettings(software.amazon.awscdk.IResolvable readProvisionedThroughputSettings) {
                this.readProvisionedThroughputSettings = readProvisionedThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaGlobalSecondaryIndexSpecificationProperty#getReadProvisionedThroughputSettings}
             * @param readProvisionedThroughputSettings Allows you to specify the read capacity settings for a replica global secondary index when the <code>BillingMode</code> is set to <code>PROVISIONED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readProvisionedThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty readProvisionedThroughputSettings) {
                this.readProvisionedThroughputSettings = readProvisionedThroughputSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaGlobalSecondaryIndexSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaGlobalSecondaryIndexSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaGlobalSecondaryIndexSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaGlobalSecondaryIndexSpecificationProperty {
            private final java.lang.String indexName;
            private final java.lang.Object contributorInsightsSpecification;
            private final java.lang.Object readOnDemandThroughputSettings;
            private final java.lang.Object readProvisionedThroughputSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contributorInsightsSpecification = software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnDemandThroughputSettings = software.amazon.jsii.Kernel.get(this, "readOnDemandThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readProvisionedThroughputSettings = software.amazon.jsii.Kernel.get(this, "readProvisionedThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.contributorInsightsSpecification = builder.contributorInsightsSpecification;
                this.readOnDemandThroughputSettings = builder.readOnDemandThroughputSettings;
                this.readProvisionedThroughputSettings = builder.readProvisionedThroughputSettings;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.Object getContributorInsightsSpecification() {
                return this.contributorInsightsSpecification;
            }

            @Override
            public final java.lang.Object getReadOnDemandThroughputSettings() {
                return this.readOnDemandThroughputSettings;
            }

            @Override
            public final java.lang.Object getReadProvisionedThroughputSettings() {
                return this.readProvisionedThroughputSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                if (this.getContributorInsightsSpecification() != null) {
                    data.set("contributorInsightsSpecification", om.valueToTree(this.getContributorInsightsSpecification()));
                }
                if (this.getReadOnDemandThroughputSettings() != null) {
                    data.set("readOnDemandThroughputSettings", om.valueToTree(this.getReadOnDemandThroughputSettings()));
                }
                if (this.getReadProvisionedThroughputSettings() != null) {
                    data.set("readProvisionedThroughputSettings", om.valueToTree(this.getReadProvisionedThroughputSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaGlobalSecondaryIndexSpecificationProperty.Jsii$Proxy that = (ReplicaGlobalSecondaryIndexSpecificationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (this.contributorInsightsSpecification != null ? !this.contributorInsightsSpecification.equals(that.contributorInsightsSpecification) : that.contributorInsightsSpecification != null) return false;
                if (this.readOnDemandThroughputSettings != null ? !this.readOnDemandThroughputSettings.equals(that.readOnDemandThroughputSettings) : that.readOnDemandThroughputSettings != null) return false;
                return this.readProvisionedThroughputSettings != null ? this.readProvisionedThroughputSettings.equals(that.readProvisionedThroughputSettings) : that.readProvisionedThroughputSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.contributorInsightsSpecification != null ? this.contributorInsightsSpecification.hashCode() : 0);
                result = 31 * result + (this.readOnDemandThroughputSettings != null ? this.readOnDemandThroughputSettings.hashCode() : 0);
                result = 31 * result + (this.readProvisionedThroughputSettings != null ? this.readProvisionedThroughputSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows you to specify a KMS key identifier to be used for server-side encryption.
     * <p>
     * The key can be specified via ARN, key ID, or alias. The key must be created in the same region as the replica.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * ReplicaSSESpecificationProperty replicaSSESpecificationProperty = ReplicaSSESpecificationProperty.builder()
     *         .kmsMasterKeyId("kmsMasterKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaSSESpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaSSESpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaSSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS KMS key that should be used for the AWS KMS encryption.
         * <p>
         * To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html#cfn-dynamodb-globaltable-replicassespecification-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicassespecification.html#cfn-dynamodb-globaltable-replicassespecification-kmsmasterkeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsMasterKeyId();

        /**
         * @return a {@link Builder} of {@link ReplicaSSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaSSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaSSESpecificationProperty> {
            java.lang.String kmsMasterKeyId;

            /**
             * Sets the value of {@link ReplicaSSESpecificationProperty#getKmsMasterKeyId}
             * @param kmsMasterKeyId The AWS KMS key that should be used for the AWS KMS encryption. This parameter is required.
             *                       To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaSSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaSSESpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaSSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaSSESpecificationProperty {
            private final java.lang.String kmsMasterKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsMasterKeyId = java.util.Objects.requireNonNull(builder.kmsMasterKeyId, "kmsMasterKeyId is required");
            }

            @Override
            public final java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaSSESpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaSSESpecificationProperty.Jsii$Proxy that = (ReplicaSSESpecificationProperty.Jsii$Proxy) o;

                return this.kmsMasterKeyId.equals(that.kmsMasterKeyId);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsMasterKeyId.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines settings specific to a single replica of a global table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * Object policyDocument;
     * ReplicaSpecificationProperty replicaSpecificationProperty = ReplicaSpecificationProperty.builder()
     *         .region("region")
     *         // the properties below are optional
     *         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .mode("mode")
     *                 .build())
     *         .deletionProtectionEnabled(false)
     *         .globalSecondaryIndexes(List.of(ReplicaGlobalSecondaryIndexSpecificationProperty.builder()
     *                 .indexName("indexName")
     *                 // the properties below are optional
     *                 .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .mode("mode")
     *                         .build())
     *                 .readOnDemandThroughputSettings(ReadOnDemandThroughputSettingsProperty.builder()
     *                         .maxReadRequestUnits(123)
     *                         .build())
     *                 .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
     *                         .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                                 .maxCapacity(123)
     *                                 .minCapacity(123)
     *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                         .targetValue(123)
     *                                         // the properties below are optional
     *                                         .disableScaleIn(false)
     *                                         .scaleInCooldown(123)
     *                                         .scaleOutCooldown(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .seedCapacity(123)
     *                                 .build())
     *                         .readCapacityUnits(123)
     *                         .build())
     *                 .build()))
     *         .kinesisStreamSpecification(KinesisStreamSpecificationProperty.builder()
     *                 .streamArn("streamArn")
     *                 // the properties below are optional
     *                 .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
     *                 .build())
     *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty.builder()
     *                 .pointInTimeRecoveryEnabled(false)
     *                 .recoveryPeriodInDays(123)
     *                 .build())
     *         .readOnDemandThroughputSettings(ReadOnDemandThroughputSettingsProperty.builder()
     *                 .maxReadRequestUnits(123)
     *                 .build())
     *         .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
     *                 .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                         .maxCapacity(123)
     *                         .minCapacity(123)
     *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                                 .targetValue(123)
     *                                 // the properties below are optional
     *                                 .disableScaleIn(false)
     *                                 .scaleInCooldown(123)
     *                                 .scaleOutCooldown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .seedCapacity(123)
     *                         .build())
     *                 .readCapacityUnits(123)
     *                 .build())
     *         .replicaStreamSpecification(ReplicaStreamSpecificationProperty.builder()
     *                 .resourcePolicy(ResourcePolicyProperty.builder()
     *                         .policyDocument(policyDocument)
     *                         .build())
     *                 .build())
     *         .resourcePolicy(ResourcePolicyProperty.builder()
     *                 .policyDocument(policyDocument)
     *                 .build())
     *         .sseSpecification(ReplicaSSESpecificationProperty.builder()
     *                 .kmsMasterKeyId("kmsMasterKeyId")
     *                 .build())
     *         .tableClass("tableClass")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The region in which this replica exists.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The settings used to enable or disable CloudWatch Contributor Insights for the specified replica.
         * <p>
         * When not specified, defaults to contributor insights disabled for the replica.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-contributorinsightsspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-contributorinsightsspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContributorInsightsSpecification() {
            return null;
        }

        /**
         * Determines if a replica is protected from deletion.
         * <p>
         * When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection">Using deletion protection</a> in the <em>Amazon DynamoDB Developer Guide</em> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-deletionprotectionenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
            return null;
        }

        /**
         * Defines additional settings for the global secondary indexes of this replica.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaGlobalSecondaryIndexSpecificationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-globalsecondaryindexes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
            return null;
        }

        /**
         * Defines the Kinesis Data Streams configuration for the specified replica.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KinesisStreamSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-kinesisstreamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-kinesisstreamspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSpecification() {
            return null;
        }

        /**
         * The settings used to enable point in time recovery.
         * <p>
         * When not specified, defaults to point in time recovery disabled for the replica.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.PointInTimeRecoverySpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-pointintimerecoveryspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-pointintimerecoveryspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoverySpecification() {
            return null;
        }

        /**
         * Sets read request settings for the replica table.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-readondemandthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-readondemandthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnDemandThroughputSettings() {
            return null;
        }

        /**
         * Defines read capacity settings for the replica table.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-readprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-readprovisionedthroughputsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadProvisionedThroughputSettings() {
            return null;
        }

        /**
         * Represents the DynamoDB Streams configuration for a global table replica.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaStreamSpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-replicastreamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-replicastreamspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplicaStreamSpecification() {
            return null;
        }

        /**
         * A resource-based policy document that contains permissions to add to the specified replica of a DynamoDB global table.
         * <p>
         * Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ResourcePolicyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
            return null;
        }

        /**
         * Allows you to specify a customer-managed key for the replica.
         * <p>
         * When using customer-managed keys for server-side encryption, this property must have a value in all replicas.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaSSESpecificationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-ssespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
            return null;
        }

        /**
         * The table class of the specified table.
         * <p>
         * Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-tableclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-tableclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableClass() {
            return null;
        }

        /**
         * An array of key-value pairs to apply to this replica.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaSpecificationProperty> {
            java.lang.String region;
            java.lang.Object contributorInsightsSpecification;
            java.lang.Object deletionProtectionEnabled;
            java.lang.Object globalSecondaryIndexes;
            java.lang.Object kinesisStreamSpecification;
            java.lang.Object pointInTimeRecoverySpecification;
            java.lang.Object readOnDemandThroughputSettings;
            java.lang.Object readProvisionedThroughputSettings;
            java.lang.Object replicaStreamSpecification;
            java.lang.Object resourcePolicy;
            java.lang.Object sseSpecification;
            java.lang.String tableClass;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getRegion}
             * @param region The region in which this replica exists. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified replica.
             *                                         When not specified, defaults to contributor insights disabled for the replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.IResolvable contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getContributorInsightsSpecification}
             * @param contributorInsightsSpecification The settings used to enable or disable CloudWatch Contributor Insights for the specified replica.
             *                                         When not specified, defaults to contributor insights disabled for the replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contributorInsightsSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ContributorInsightsSpecificationProperty contributorInsightsSpecification) {
                this.contributorInsightsSpecification = contributorInsightsSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getDeletionProtectionEnabled}
             * @param deletionProtectionEnabled Determines if a replica is protected from deletion.
             *                                  When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection">Using deletion protection</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deletionProtectionEnabled(java.lang.Boolean deletionProtectionEnabled) {
                this.deletionProtectionEnabled = deletionProtectionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getDeletionProtectionEnabled}
             * @param deletionProtectionEnabled Determines if a replica is protected from deletion.
             *                                  When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection">Using deletion protection</a> in the <em>Amazon DynamoDB Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deletionProtectionEnabled(software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
                this.deletionProtectionEnabled = deletionProtectionEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getGlobalSecondaryIndexes}
             * @param globalSecondaryIndexes Defines additional settings for the global secondary indexes of this replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalSecondaryIndexes(software.amazon.awscdk.IResolvable globalSecondaryIndexes) {
                this.globalSecondaryIndexes = globalSecondaryIndexes;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getGlobalSecondaryIndexes}
             * @param globalSecondaryIndexes Defines additional settings for the global secondary indexes of this replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalSecondaryIndexes(java.util.List<? extends java.lang.Object> globalSecondaryIndexes) {
                this.globalSecondaryIndexes = globalSecondaryIndexes;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getKinesisStreamSpecification}
             * @param kinesisStreamSpecification Defines the Kinesis Data Streams configuration for the specified replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamSpecification(software.amazon.awscdk.IResolvable kinesisStreamSpecification) {
                this.kinesisStreamSpecification = kinesisStreamSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getKinesisStreamSpecification}
             * @param kinesisStreamSpecification Defines the Kinesis Data Streams configuration for the specified replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.KinesisStreamSpecificationProperty kinesisStreamSpecification) {
                this.kinesisStreamSpecification = kinesisStreamSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getPointInTimeRecoverySpecification}
             * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery.
             *                                         When not specified, defaults to point in time recovery disabled for the replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.IResolvable pointInTimeRecoverySpecification) {
                this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getPointInTimeRecoverySpecification}
             * @param pointInTimeRecoverySpecification The settings used to enable point in time recovery.
             *                                         When not specified, defaults to point in time recovery disabled for the replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.PointInTimeRecoverySpecificationProperty pointInTimeRecoverySpecification) {
                this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadOnDemandThroughputSettings}
             * @param readOnDemandThroughputSettings Sets read request settings for the replica table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnDemandThroughputSettings(software.amazon.awscdk.IResolvable readOnDemandThroughputSettings) {
                this.readOnDemandThroughputSettings = readOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadOnDemandThroughputSettings}
             * @param readOnDemandThroughputSettings Sets read request settings for the replica table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnDemandThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadOnDemandThroughputSettingsProperty readOnDemandThroughputSettings) {
                this.readOnDemandThroughputSettings = readOnDemandThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadProvisionedThroughputSettings}
             * @param readProvisionedThroughputSettings Defines read capacity settings for the replica table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readProvisionedThroughputSettings(software.amazon.awscdk.IResolvable readProvisionedThroughputSettings) {
                this.readProvisionedThroughputSettings = readProvisionedThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReadProvisionedThroughputSettings}
             * @param readProvisionedThroughputSettings Defines read capacity settings for the replica table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readProvisionedThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReadProvisionedThroughputSettingsProperty readProvisionedThroughputSettings) {
                this.readProvisionedThroughputSettings = readProvisionedThroughputSettings;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReplicaStreamSpecification}
             * @param replicaStreamSpecification Represents the DynamoDB Streams configuration for a global table replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaStreamSpecification(software.amazon.awscdk.IResolvable replicaStreamSpecification) {
                this.replicaStreamSpecification = replicaStreamSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getReplicaStreamSpecification}
             * @param replicaStreamSpecification Represents the DynamoDB Streams configuration for a global table replica.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicaStreamSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaStreamSpecificationProperty replicaStreamSpecification) {
                this.replicaStreamSpecification = replicaStreamSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy A resource-based policy document that contains permissions to add to the specified replica of a DynamoDB global table.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy A resource-based policy document that contains permissions to add to the specified replica of a DynamoDB global table.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getSseSpecification}
             * @param sseSpecification Allows you to specify a customer-managed key for the replica.
             *                         When using customer-managed keys for server-side encryption, this property must have a value in all replicas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseSpecification(software.amazon.awscdk.IResolvable sseSpecification) {
                this.sseSpecification = sseSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getSseSpecification}
             * @param sseSpecification Allows you to specify a customer-managed key for the replica.
             *                         When using customer-managed keys for server-side encryption, this property must have a value in all replicas.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ReplicaSSESpecificationProperty sseSpecification) {
                this.sseSpecification = sseSpecification;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getTableClass}
             * @param tableClass The table class of the specified table.
             *                   Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableClass(java.lang.String tableClass) {
                this.tableClass = tableClass;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaSpecificationProperty#getTags}
             * @param tags An array of key-value pairs to apply to this replica.
             *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaSpecificationProperty {
            private final java.lang.String region;
            private final java.lang.Object contributorInsightsSpecification;
            private final java.lang.Object deletionProtectionEnabled;
            private final java.lang.Object globalSecondaryIndexes;
            private final java.lang.Object kinesisStreamSpecification;
            private final java.lang.Object pointInTimeRecoverySpecification;
            private final java.lang.Object readOnDemandThroughputSettings;
            private final java.lang.Object readProvisionedThroughputSettings;
            private final java.lang.Object replicaStreamSpecification;
            private final java.lang.Object resourcePolicy;
            private final java.lang.Object sseSpecification;
            private final java.lang.String tableClass;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contributorInsightsSpecification = software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deletionProtectionEnabled = software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.globalSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamSpecification = software.amazon.jsii.Kernel.get(this, "kinesisStreamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnDemandThroughputSettings = software.amazon.jsii.Kernel.get(this, "readOnDemandThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readProvisionedThroughputSettings = software.amazon.jsii.Kernel.get(this, "readProvisionedThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replicaStreamSpecification = software.amazon.jsii.Kernel.get(this, "replicaStreamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.contributorInsightsSpecification = builder.contributorInsightsSpecification;
                this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
                this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
                this.kinesisStreamSpecification = builder.kinesisStreamSpecification;
                this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
                this.readOnDemandThroughputSettings = builder.readOnDemandThroughputSettings;
                this.readProvisionedThroughputSettings = builder.readProvisionedThroughputSettings;
                this.replicaStreamSpecification = builder.replicaStreamSpecification;
                this.resourcePolicy = builder.resourcePolicy;
                this.sseSpecification = builder.sseSpecification;
                this.tableClass = builder.tableClass;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.Object getContributorInsightsSpecification() {
                return this.contributorInsightsSpecification;
            }

            @Override
            public final java.lang.Object getDeletionProtectionEnabled() {
                return this.deletionProtectionEnabled;
            }

            @Override
            public final java.lang.Object getGlobalSecondaryIndexes() {
                return this.globalSecondaryIndexes;
            }

            @Override
            public final java.lang.Object getKinesisStreamSpecification() {
                return this.kinesisStreamSpecification;
            }

            @Override
            public final java.lang.Object getPointInTimeRecoverySpecification() {
                return this.pointInTimeRecoverySpecification;
            }

            @Override
            public final java.lang.Object getReadOnDemandThroughputSettings() {
                return this.readOnDemandThroughputSettings;
            }

            @Override
            public final java.lang.Object getReadProvisionedThroughputSettings() {
                return this.readProvisionedThroughputSettings;
            }

            @Override
            public final java.lang.Object getReplicaStreamSpecification() {
                return this.replicaStreamSpecification;
            }

            @Override
            public final java.lang.Object getResourcePolicy() {
                return this.resourcePolicy;
            }

            @Override
            public final java.lang.Object getSseSpecification() {
                return this.sseSpecification;
            }

            @Override
            public final java.lang.String getTableClass() {
                return this.tableClass;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getContributorInsightsSpecification() != null) {
                    data.set("contributorInsightsSpecification", om.valueToTree(this.getContributorInsightsSpecification()));
                }
                if (this.getDeletionProtectionEnabled() != null) {
                    data.set("deletionProtectionEnabled", om.valueToTree(this.getDeletionProtectionEnabled()));
                }
                if (this.getGlobalSecondaryIndexes() != null) {
                    data.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
                }
                if (this.getKinesisStreamSpecification() != null) {
                    data.set("kinesisStreamSpecification", om.valueToTree(this.getKinesisStreamSpecification()));
                }
                if (this.getPointInTimeRecoverySpecification() != null) {
                    data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
                }
                if (this.getReadOnDemandThroughputSettings() != null) {
                    data.set("readOnDemandThroughputSettings", om.valueToTree(this.getReadOnDemandThroughputSettings()));
                }
                if (this.getReadProvisionedThroughputSettings() != null) {
                    data.set("readProvisionedThroughputSettings", om.valueToTree(this.getReadProvisionedThroughputSettings()));
                }
                if (this.getReplicaStreamSpecification() != null) {
                    data.set("replicaStreamSpecification", om.valueToTree(this.getReplicaStreamSpecification()));
                }
                if (this.getResourcePolicy() != null) {
                    data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
                }
                if (this.getSseSpecification() != null) {
                    data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
                }
                if (this.getTableClass() != null) {
                    data.set("tableClass", om.valueToTree(this.getTableClass()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaSpecificationProperty.Jsii$Proxy that = (ReplicaSpecificationProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                if (this.contributorInsightsSpecification != null ? !this.contributorInsightsSpecification.equals(that.contributorInsightsSpecification) : that.contributorInsightsSpecification != null) return false;
                if (this.deletionProtectionEnabled != null ? !this.deletionProtectionEnabled.equals(that.deletionProtectionEnabled) : that.deletionProtectionEnabled != null) return false;
                if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
                if (this.kinesisStreamSpecification != null ? !this.kinesisStreamSpecification.equals(that.kinesisStreamSpecification) : that.kinesisStreamSpecification != null) return false;
                if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
                if (this.readOnDemandThroughputSettings != null ? !this.readOnDemandThroughputSettings.equals(that.readOnDemandThroughputSettings) : that.readOnDemandThroughputSettings != null) return false;
                if (this.readProvisionedThroughputSettings != null ? !this.readProvisionedThroughputSettings.equals(that.readProvisionedThroughputSettings) : that.readProvisionedThroughputSettings != null) return false;
                if (this.replicaStreamSpecification != null ? !this.replicaStreamSpecification.equals(that.replicaStreamSpecification) : that.replicaStreamSpecification != null) return false;
                if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
                if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
                if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.contributorInsightsSpecification != null ? this.contributorInsightsSpecification.hashCode() : 0);
                result = 31 * result + (this.deletionProtectionEnabled != null ? this.deletionProtectionEnabled.hashCode() : 0);
                result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamSpecification != null ? this.kinesisStreamSpecification.hashCode() : 0);
                result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
                result = 31 * result + (this.readOnDemandThroughputSettings != null ? this.readOnDemandThroughputSettings.hashCode() : 0);
                result = 31 * result + (this.readProvisionedThroughputSettings != null ? this.readProvisionedThroughputSettings.hashCode() : 0);
                result = 31 * result + (this.replicaStreamSpecification != null ? this.replicaStreamSpecification.hashCode() : 0);
                result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
                result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
                result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the DynamoDB Streams configuration for a global table replica.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * Object policyDocument;
     * ReplicaStreamSpecificationProperty replicaStreamSpecificationProperty = ReplicaStreamSpecificationProperty.builder()
     *         .resourcePolicy(ResourcePolicyProperty.builder()
     *                 .policyDocument(policyDocument)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicastreamspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicastreamspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaStreamSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplicaStreamSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplicaStreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A resource-based policy document that contains the permissions for the specified stream of a DynamoDB global table replica.
         * <p>
         * Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * You can update the <code>ResourcePolicy</code> property if you've specified more than one table using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">AWS ::DynamoDB::GlobalTable</a> resource.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ResourcePolicyProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicastreamspecification.html#cfn-dynamodb-globaltable-replicastreamspecification-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicastreamspecification.html#cfn-dynamodb-globaltable-replicastreamspecification-resourcepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getResourcePolicy();

        /**
         * @return a {@link Builder} of {@link ReplicaStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplicaStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplicaStreamSpecificationProperty> {
            java.lang.Object resourcePolicy;

            /**
             * Sets the value of {@link ReplicaStreamSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy A resource-based policy document that contains the permissions for the specified stream of a DynamoDB global table replica. This parameter is required.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             *                       <p>
             *                       You can update the <code>ResourcePolicy</code> property if you've specified more than one table using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">AWS ::DynamoDB::GlobalTable</a> resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.IResolvable resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Sets the value of {@link ReplicaStreamSpecificationProperty#getResourcePolicy}
             * @param resourcePolicy A resource-based policy document that contains the permissions for the specified stream of a DynamoDB global table replica. This parameter is required.
             *                       Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
             *                       <p>
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             *                       <p>
             *                       You can update the <code>ResourcePolicy</code> property if you've specified more than one table using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">AWS ::DynamoDB::GlobalTable</a> resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePolicy(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.ResourcePolicyProperty resourcePolicy) {
                this.resourcePolicy = resourcePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplicaStreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplicaStreamSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplicaStreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaStreamSpecificationProperty {
            private final java.lang.Object resourcePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourcePolicy = java.util.Objects.requireNonNull(builder.resourcePolicy, "resourcePolicy is required");
            }

            @Override
            public final java.lang.Object getResourcePolicy() {
                return this.resourcePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ReplicaStreamSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplicaStreamSpecificationProperty.Jsii$Proxy that = (ReplicaStreamSpecificationProperty.Jsii$Proxy) o;

                return this.resourcePolicy.equals(that.resourcePolicy);
            }

            @Override
            public final int hashCode() {
                int result = this.resourcePolicy.hashCode();
                return result;
            }
        }
    }
    /**
     * Creates or updates a resource-based policy document that contains the permissions for DynamoDB resources, such as a table, its indexes, and stream.
     * <p>
     * Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
     * <p>
     * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
     * <p>
     * While defining resource-based policies in your CloudFormation templates, the following considerations apply:
     * <p>
     * <ul>
     * <li>The maximum size supported for a resource-based policy document in JSON format is 20 KB. DynamoDB counts whitespaces when calculating the size of a policy against this limit.</li>
     * <li>Resource-based policies don't support <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html#">drift detection</a> . If you update a policy outside of the CloudFormation stack template, you'll need to update the CloudFormation stack with the changes.</li>
     * <li>Resource-based policies don't support out-of-band changes. If you add, update, or delete a policy outside of the CloudFormation template, the change won't be overwritten if there are no changes to the policy within the template.</li>
     * </ul>
     * <p>
     * For example, say that your template contains a resource-based policy, which you later update outside of the template. If you don't make any changes to the policy in the template, the updated policy in DynamoDB won’t be synced with the policy in the template.
     * <p>
     * Conversely, say that your template doesn’t contain a resource-based policy, but you add a policy outside of the template. This policy won’t be removed from DynamoDB as long as you don’t add it to the template. When you add a policy to the template and update the stack, the existing policy in DynamoDB will be updated to match the one defined in the template.
     * <p>
     * <ul>
     * <li>Within a resource-based policy, if the action for a DynamoDB service-linked role (SLR) to replicate data for a global table is denied, adding or deleting a replica will fail with an error.</li>
     * <li>The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">AWS ::DynamoDB::GlobalTable</a> resource doesn't support creating a replica in the same stack update in Regions other than the Region where you deploy the stack update.</li>
     * </ul>
     * <p>
     * For a full list of all considerations, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html">Resource-based policy considerations</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * Object policyDocument;
     * ResourcePolicyProperty resourcePolicyProperty = ResourcePolicyProperty.builder()
     *         .policyDocument(policyDocument)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-resourcepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-resourcepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ResourcePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A resource-based policy document that contains permissions to add to the specified DynamoDB table, its indexes, and stream.
         * <p>
         * In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-resourcepolicy.html#cfn-dynamodb-globaltable-resourcepolicy-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-resourcepolicy.html#cfn-dynamodb-globaltable-resourcepolicy-policydocument</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

        /**
         * @return a {@link Builder} of {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyProperty> {
            java.lang.Object policyDocument;

            /**
             * Sets the value of {@link ResourcePolicyProperty#getPolicyDocument}
             * @param policyDocument A resource-based policy document that contains permissions to add to the specified DynamoDB table, its indexes, and stream. This parameter is required.
             *                       In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html">Using resource-based policies for DynamoDB</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html">Resource-based policy examples</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyDocument(java.lang.Object policyDocument) {
                this.policyDocument = policyDocument;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyProperty {
            private final java.lang.Object policyDocument;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
            }

            @Override
            public final java.lang.Object getPolicyDocument() {
                return this.policyDocument;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.ResourcePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePolicyProperty.Jsii$Proxy that = (ResourcePolicyProperty.Jsii$Proxy) o;

                return this.policyDocument.equals(that.policyDocument);
            }

            @Override
            public final int hashCode() {
                int result = this.policyDocument.hashCode();
                return result;
            }
        }
    }
    /**
     * Represents the settings used to enable server-side encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * SSESpecificationProperty sSESpecificationProperty = SSESpecificationProperty.builder()
     *         .sseEnabled(false)
     *         // the properties below are optional
     *         .sseType("sseType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.SSESpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SSESpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SSESpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether server-side encryption is performed using an AWS managed key or an AWS owned key.
         * <p>
         * If enabled (true), server-side encryption type is set to KMS and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified,server-side encryption is set to an AWS owned key. If you choose to use KMS encryption, you can also use customer managed KMS keys by specifying them in the <code>ReplicaSpecification.SSESpecification</code> object. You cannot mix AWS managed and customer managed KMS keys.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-sseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-sseenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSseEnabled();

        /**
         * Server-side encryption type. The only supported value is:.
         * <p>
         * <ul>
         * <li><code>KMS</code> - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-ssetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-ssespecification.html#cfn-dynamodb-globaltable-ssespecification-ssetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSseType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SSESpecificationProperty> {
            java.lang.Object sseEnabled;
            java.lang.String sseType;

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseEnabled}
             * @param sseEnabled Indicates whether server-side encryption is performed using an AWS managed key or an AWS owned key. This parameter is required.
             *                   If enabled (true), server-side encryption type is set to KMS and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified,server-side encryption is set to an AWS owned key. If you choose to use KMS encryption, you can also use customer managed KMS keys by specifying them in the <code>ReplicaSpecification.SSESpecification</code> object. You cannot mix AWS managed and customer managed KMS keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseEnabled(java.lang.Boolean sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseEnabled}
             * @param sseEnabled Indicates whether server-side encryption is performed using an AWS managed key or an AWS owned key. This parameter is required.
             *                   If enabled (true), server-side encryption type is set to KMS and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified,server-side encryption is set to an AWS owned key. If you choose to use KMS encryption, you can also use customer managed KMS keys by specifying them in the <code>ReplicaSpecification.SSESpecification</code> object. You cannot mix AWS managed and customer managed KMS keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseEnabled(software.amazon.awscdk.IResolvable sseEnabled) {
                this.sseEnabled = sseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SSESpecificationProperty#getSseType}
             * @param sseType Server-side encryption type. The only supported value is:.
             *                <ul>
             *                <li><code>KMS</code> - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseType(java.lang.String sseType) {
                this.sseType = sseType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSESpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SSESpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SSESpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSESpecificationProperty {
            private final java.lang.Object sseEnabled;
            private final java.lang.String sseType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseEnabled = software.amazon.jsii.Kernel.get(this, "sseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sseType = software.amazon.jsii.Kernel.get(this, "sseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseEnabled = java.util.Objects.requireNonNull(builder.sseEnabled, "sseEnabled is required");
                this.sseType = builder.sseType;
            }

            @Override
            public final java.lang.Object getSseEnabled() {
                return this.sseEnabled;
            }

            @Override
            public final java.lang.String getSseType() {
                return this.sseType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseEnabled", om.valueToTree(this.getSseEnabled()));
                if (this.getSseType() != null) {
                    data.set("sseType", om.valueToTree(this.getSseType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.SSESpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSESpecificationProperty.Jsii$Proxy that = (SSESpecificationProperty.Jsii$Proxy) o;

                if (!sseEnabled.equals(that.sseEnabled)) return false;
                return this.sseType != null ? this.sseType.equals(that.sseType) : that.sseType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sseEnabled.hashCode();
                result = 31 * result + (this.sseType != null ? this.sseType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the DynamoDB Streams configuration for a table in DynamoDB .
     * <p>
     * You can only modify this value for a <code>AWS::DynamoDB::GlobalTable</code> resource configured for multi-Region eventual consistency (MREC, the default) if that resource contains only one entry in <code>Replicas</code> . You must specify a value for this property for a <code>AWS::DynamoDB::GlobalTable</code> resource configured for MREC with more than one entry in <code>Replicas</code> . For Multi-Region Strong Consistency (MRSC), Streams are not required and can be changed for existing tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * StreamSpecificationProperty streamSpecificationProperty = StreamSpecificationProperty.builder()
     *         .streamViewType("streamViewType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.StreamSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table.
         * <p>
         * Valid values for <code>StreamViewType</code> are:
         * <p>
         * <ul>
         * <li><code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</li>
         * <li><code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</li>
         * <li><code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</li>
         * <li><code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html#cfn-dynamodb-globaltable-streamspecification-streamviewtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-streamspecification.html#cfn-dynamodb-globaltable-streamspecification-streamviewtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamViewType();

        /**
         * @return a {@link Builder} of {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSpecificationProperty> {
            java.lang.String streamViewType;

            /**
             * Sets the value of {@link StreamSpecificationProperty#getStreamViewType}
             * @param streamViewType When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. This parameter is required.
             *                       Valid values for <code>StreamViewType</code> are:
             *                       <p>
             *                       <ul>
             *                       <li><code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</li>
             *                       <li><code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</li>
             *                       <li><code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</li>
             *                       <li><code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamViewType(java.lang.String streamViewType) {
                this.streamViewType = streamViewType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSpecificationProperty {
            private final java.lang.String streamViewType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamViewType = software.amazon.jsii.Kernel.get(this, "streamViewType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamViewType = java.util.Objects.requireNonNull(builder.streamViewType, "streamViewType is required");
            }

            @Override
            public final java.lang.String getStreamViewType() {
                return this.streamViewType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamViewType", om.valueToTree(this.getStreamViewType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.StreamSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSpecificationProperty.Jsii$Proxy that = (StreamSpecificationProperty.Jsii$Proxy) o;

                return this.streamViewType.equals(that.streamViewType);
            }

            @Override
            public final int hashCode() {
                int result = this.streamViewType.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a target tracking scaling policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfigurationProperty = TargetTrackingScalingPolicyConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .disableScaleIn(false)
     *         .scaleInCooldown(123)
     *         .scaleOutCooldown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines a target value for the scaling policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-disablescalein">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-disablescalein</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleincooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleincooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleoutcooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-targettrackingscalingpolicyconfiguration.html#cfn-dynamodb-globaltable-targettrackingscalingpolicyconfiguration-scaleoutcooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object disableScaleIn;
            java.lang.Number scaleInCooldown;
            java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getTargetValue}
             * @param targetValue Defines a target value for the scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scale in by the target tracking scaling policy is disabled.
             *                       The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleInCooldown}
             * @param scaleInCooldown The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingScalingPolicyConfigurationProperty#getScaleOutCooldown}
             * @param scaleOutCooldown The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingScalingPolicyConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scaleInCooldown = software.amazon.jsii.Kernel.get(this, "scaleInCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scaleOutCooldown = software.amazon.jsii.Kernel.get(this, "scaleOutCooldown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.disableScaleIn = builder.disableScaleIn;
                this.scaleInCooldown = builder.scaleInCooldown;
                this.scaleOutCooldown = builder.scaleOutCooldown;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public final java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy that = (TargetTrackingScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the settings used to enable or disable Time to Live (TTL) for the specified table.
     * <p>
     * All replicas will have the same time to live configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * TimeToLiveSpecificationProperty timeToLiveSpecificationProperty = TimeToLiveSpecificationProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .attributeName("attributeName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeToLiveSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeToLiveSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the attribute used to store the expiration time for items in the table.
         * <p>
         * Currently, you cannot directly change the attribute name used to evaluate time to live. In order to do so, you must first disable time to live, and then re-enable it with the new attribute name. It can take up to one hour for changes to time to live to take effect. If you attempt to modify time to live within that time window, your stack operation might be delayed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-timetolivespecification.html#cfn-dynamodb-globaltable-timetolivespecification-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeToLiveSpecificationProperty> {
            java.lang.Object enabled;
            java.lang.String attributeName;

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getEnabled}
             * @param enabled Indicates whether TTL is to be enabled (true) or disabled (false) on the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getEnabled}
             * @param enabled Indicates whether TTL is to be enabled (true) or disabled (false) on the table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TimeToLiveSpecificationProperty#getAttributeName}
             * @param attributeName The name of the attribute used to store the expiration time for items in the table.
             *                      Currently, you cannot directly change the attribute name used to evaluate time to live. In order to do so, you must first disable time to live, and then re-enable it with the new attribute name. It can take up to one hour for changes to time to live to take effect. If you attempt to modify time to live within that time window, your stack operation might be delayed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeToLiveSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeToLiveSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeToLiveSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeToLiveSpecificationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String attributeName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.attributeName = builder.attributeName;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAttributeName() != null) {
                    data.set("attributeName", om.valueToTree(this.getAttributeName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeToLiveSpecificationProperty.Jsii$Proxy that = (TimeToLiveSpecificationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.attributeName != null ? this.attributeName.equals(that.attributeName) : that.attributeName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.attributeName != null ? this.attributeName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
     * <p>
     * The settings can be modified using the <code>UpdateTable</code> operation to meet the throughput requirements of an upcoming peak event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * WarmThroughputProperty warmThroughputProperty = WarmThroughputProperty.builder()
     *         .readUnitsPerSecond(123)
     *         .writeUnitsPerSecond(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WarmThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(WarmThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WarmThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents the number of read operations your base table can instantaneously support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html#cfn-dynamodb-globaltable-warmthroughput-readunitspersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html#cfn-dynamodb-globaltable-warmthroughput-readunitspersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReadUnitsPerSecond() {
            return null;
        }

        /**
         * Represents the number of write operations your base table can instantaneously support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html#cfn-dynamodb-globaltable-warmthroughput-writeunitspersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-warmthroughput.html#cfn-dynamodb-globaltable-warmthroughput-writeunitspersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWriteUnitsPerSecond() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WarmThroughputProperty> {
            java.lang.Number readUnitsPerSecond;
            java.lang.Number writeUnitsPerSecond;

            /**
             * Sets the value of {@link WarmThroughputProperty#getReadUnitsPerSecond}
             * @param readUnitsPerSecond Represents the number of read operations your base table can instantaneously support.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readUnitsPerSecond(java.lang.Number readUnitsPerSecond) {
                this.readUnitsPerSecond = readUnitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link WarmThroughputProperty#getWriteUnitsPerSecond}
             * @param writeUnitsPerSecond Represents the number of write operations your base table can instantaneously support.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeUnitsPerSecond(java.lang.Number writeUnitsPerSecond) {
                this.writeUnitsPerSecond = writeUnitsPerSecond;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WarmThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WarmThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WarmThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WarmThroughputProperty {
            private final java.lang.Number readUnitsPerSecond;
            private final java.lang.Number writeUnitsPerSecond;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "readUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writeUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "writeUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readUnitsPerSecond = builder.readUnitsPerSecond;
                this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
            }

            @Override
            public final java.lang.Number getReadUnitsPerSecond() {
                return this.readUnitsPerSecond;
            }

            @Override
            public final java.lang.Number getWriteUnitsPerSecond() {
                return this.writeUnitsPerSecond;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReadUnitsPerSecond() != null) {
                    data.set("readUnitsPerSecond", om.valueToTree(this.getReadUnitsPerSecond()));
                }
                if (this.getWriteUnitsPerSecond() != null) {
                    data.set("writeUnitsPerSecond", om.valueToTree(this.getWriteUnitsPerSecond()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WarmThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WarmThroughputProperty.Jsii$Proxy that = (WarmThroughputProperty.Jsii$Proxy) o;

                if (this.readUnitsPerSecond != null ? !this.readUnitsPerSecond.equals(that.readUnitsPerSecond) : that.readUnitsPerSecond != null) return false;
                return this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.equals(that.writeUnitsPerSecond) : that.writeUnitsPerSecond == null;
            }

            @Override
            public final int hashCode() {
                int result = this.readUnitsPerSecond != null ? this.readUnitsPerSecond.hashCode() : 0;
                result = 31 * result + (this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets the write request settings for a global table or a global secondary index.
     * <p>
     * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * WriteOnDemandThroughputSettingsProperty writeOnDemandThroughputSettingsProperty = WriteOnDemandThroughputSettingsProperty.builder()
     *         .maxWriteRequestUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeondemandthroughputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeondemandthroughputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(WriteOnDemandThroughputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WriteOnDemandThroughputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum number of write request settings for the specified replica of a global table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeondemandthroughputsettings.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings-maxwriterequestunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeondemandthroughputsettings.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings-maxwriterequestunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWriteRequestUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WriteOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WriteOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WriteOnDemandThroughputSettingsProperty> {
            java.lang.Number maxWriteRequestUnits;

            /**
             * Sets the value of {@link WriteOnDemandThroughputSettingsProperty#getMaxWriteRequestUnits}
             * @param maxWriteRequestUnits Maximum number of write request settings for the specified replica of a global table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxWriteRequestUnits(java.lang.Number maxWriteRequestUnits) {
                this.maxWriteRequestUnits = maxWriteRequestUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WriteOnDemandThroughputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WriteOnDemandThroughputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WriteOnDemandThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WriteOnDemandThroughputSettingsProperty {
            private final java.lang.Number maxWriteRequestUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxWriteRequestUnits = software.amazon.jsii.Kernel.get(this, "maxWriteRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
            }

            @Override
            public final java.lang.Number getMaxWriteRequestUnits() {
                return this.maxWriteRequestUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxWriteRequestUnits() != null) {
                    data.set("maxWriteRequestUnits", om.valueToTree(this.getMaxWriteRequestUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WriteOnDemandThroughputSettingsProperty.Jsii$Proxy that = (WriteOnDemandThroughputSettingsProperty.Jsii$Proxy) o;

                return this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.equals(that.maxWriteRequestUnits) : that.maxWriteRequestUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an auto scaling policy for write capacity.
     * <p>
     * This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dynamodb.*;
     * WriteProvisionedThroughputSettingsProperty writeProvisionedThroughputSettingsProperty = WriteProvisionedThroughputSettingsProperty.builder()
     *         .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
     *                         .targetValue(123)
     *                         // the properties below are optional
     *                         .disableScaleIn(false)
     *                         .scaleInCooldown(123)
     *                         .scaleOutCooldown(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .seedCapacity(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(WriteProvisionedThroughputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WriteProvisionedThroughputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies auto scaling settings for the replica table or global secondary index.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings-writecapacityautoscalingsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-writeprovisionedthroughputsettings.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings-writecapacityautoscalingsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWriteCapacityAutoScalingSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WriteProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WriteProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WriteProvisionedThroughputSettingsProperty> {
            java.lang.Object writeCapacityAutoScalingSettings;

            /**
             * Sets the value of {@link WriteProvisionedThroughputSettingsProperty#getWriteCapacityAutoScalingSettings}
             * @param writeCapacityAutoScalingSettings Specifies auto scaling settings for the replica table or global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityAutoScalingSettings(software.amazon.awscdk.IResolvable writeCapacityAutoScalingSettings) {
                this.writeCapacityAutoScalingSettings = writeCapacityAutoScalingSettings;
                return this;
            }

            /**
             * Sets the value of {@link WriteProvisionedThroughputSettingsProperty#getWriteCapacityAutoScalingSettings}
             * @param writeCapacityAutoScalingSettings Specifies auto scaling settings for the replica table or global secondary index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityAutoScalingSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty writeCapacityAutoScalingSettings) {
                this.writeCapacityAutoScalingSettings = writeCapacityAutoScalingSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WriteProvisionedThroughputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WriteProvisionedThroughputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WriteProvisionedThroughputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WriteProvisionedThroughputSettingsProperty {
            private final java.lang.Object writeCapacityAutoScalingSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.writeCapacityAutoScalingSettings = software.amazon.jsii.Kernel.get(this, "writeCapacityAutoScalingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.writeCapacityAutoScalingSettings = builder.writeCapacityAutoScalingSettings;
            }

            @Override
            public final java.lang.Object getWriteCapacityAutoScalingSettings() {
                return this.writeCapacityAutoScalingSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getWriteCapacityAutoScalingSettings() != null) {
                    data.set("writeCapacityAutoScalingSettings", om.valueToTree(this.getWriteCapacityAutoScalingSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WriteProvisionedThroughputSettingsProperty.Jsii$Proxy that = (WriteProvisionedThroughputSettingsProperty.Jsii$Proxy) o;

                return this.writeCapacityAutoScalingSettings != null ? this.writeCapacityAutoScalingSettings.equals(that.writeCapacityAutoScalingSettings) : that.writeCapacityAutoScalingSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.writeCapacityAutoScalingSettings != null ? this.writeCapacityAutoScalingSettings.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.CfnGlobalTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.CfnGlobalTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.CfnGlobalTableProps.Builder();
        }

        /**
         * A list of attributes that describe the key schema for the global table and indexes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions</a>
         * @param attributeDefinitions A list of attributes that describe the key schema for the global table and indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(final software.amazon.awscdk.IResolvable attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }
        /**
         * A list of attributes that describe the key schema for the global table and indexes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions</a>
         * @param attributeDefinitions A list of attributes that describe the key schema for the global table and indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(final java.util.List<? extends java.lang.Object> attributeDefinitions) {
            this.props.attributeDefinitions(attributeDefinitions);
            return this;
        }

        /**
         * Specifies the attributes that make up the primary key for the table.
         * <p>
         * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema</a>
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(final software.amazon.awscdk.IResolvable keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }
        /**
         * Specifies the attributes that make up the primary key for the table.
         * <p>
         * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema</a>
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(final java.util.List<? extends java.lang.Object> keySchema) {
            this.props.keySchema(keySchema);
            return this;
        }

        /**
         * Specifies the list of replicas for your global table.
         * <p>
         * The list must contain at least one element, the region where the stack defining the global table is deployed. For example, if you define your table in a stack deployed to us-east-1, you must have an entry in <code>Replicas</code> with the region us-east-1. You cannot remove the replica in the stack region.
         * <p>
         * <blockquote>
         * <p>
         * Adding a replica might take a few minutes for an empty table, or up to several hours for large tables. If you want to add or remove a replica, we recommend submitting an <code>UpdateStack</code> operation containing only that change.
         * <p>
         * If you add or delete a replica during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new replica, you might need to manually delete the replica.
         * <p>
         * </blockquote>
         * <p>
         * You can create a new global table with as many replicas as needed. You can add or remove replicas after table creation, but you can only add or remove a single replica in each update. For Multi-Region Strong Consistency (MRSC), you can add or remove up to 3 replicas, or 2 replicas plus a witness Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas</a>
         * @param replicas Specifies the list of replicas for your global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final software.amazon.awscdk.IResolvable replicas) {
            this.props.replicas(replicas);
            return this;
        }
        /**
         * Specifies the list of replicas for your global table.
         * <p>
         * The list must contain at least one element, the region where the stack defining the global table is deployed. For example, if you define your table in a stack deployed to us-east-1, you must have an entry in <code>Replicas</code> with the region us-east-1. You cannot remove the replica in the stack region.
         * <p>
         * <blockquote>
         * <p>
         * Adding a replica might take a few minutes for an empty table, or up to several hours for large tables. If you want to add or remove a replica, we recommend submitting an <code>UpdateStack</code> operation containing only that change.
         * <p>
         * If you add or delete a replica during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new replica, you might need to manually delete the replica.
         * <p>
         * </blockquote>
         * <p>
         * You can create a new global table with as many replicas as needed. You can add or remove replicas after table creation, but you can only add or remove a single replica in each update. For Multi-Region Strong Consistency (MRSC), you can add or remove up to 3 replicas, or 2 replicas plus a witness Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas</a>
         * @param replicas Specifies the list of replicas for your global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(final java.util.List<? extends java.lang.Object> replicas) {
            this.props.replicas(replicas);
            return this;
        }

        /**
         * Specifies how you are charged for read and write throughput and how you manage capacity. Valid values are:.
         * <p>
         * <ul>
         * <li><code>PAY_PER_REQUEST</code></li>
         * <li><code>PROVISIONED</code></li>
         * </ul>
         * <p>
         * All replicas in your global table will have the same billing mode. If you use <code>PROVISIONED</code> billing mode, you must provide an auto scaling configuration via the <code>WriteProvisionedThroughputSettings</code> property. The default value of this property is <code>PROVISIONED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode</a>
         * @param billingMode Specifies how you are charged for read and write throughput and how you manage capacity. Valid values are:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final java.lang.String billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * Global secondary indexes to be created on the global table.
         * <p>
         * You can create up to 20 global secondary indexes. Each replica in your global table will have the same global secondary index settings. You can only create or delete one global secondary index in a single stack operation.
         * <p>
         * Since the backfilling of an index could take a long time, CloudFormation does not wait for the index to become active. If a stack operation rolls back, CloudFormation might not delete an index that has been added. In that case, you will need to delete the index manually.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes</a>
         * @param globalSecondaryIndexes Global secondary indexes to be created on the global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(final software.amazon.awscdk.IResolvable globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }
        /**
         * Global secondary indexes to be created on the global table.
         * <p>
         * You can create up to 20 global secondary indexes. Each replica in your global table will have the same global secondary index settings. You can only create or delete one global secondary index in a single stack operation.
         * <p>
         * Since the backfilling of an index could take a long time, CloudFormation does not wait for the index to become active. If a stack operation rolls back, CloudFormation might not delete an index that has been added. In that case, you will need to delete the index manually.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes</a>
         * @param globalSecondaryIndexes Global secondary indexes to be created on the global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(final java.util.List<? extends java.lang.Object> globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        /**
         * The list of witnesses of the MRSC global table.
         * <p>
         * Only one witness Region can be configured per MRSC global table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globaltablewitnesses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globaltablewitnesses</a>
         * @param globalTableWitnesses The list of witnesses of the MRSC global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalTableWitnesses(final software.amazon.awscdk.IResolvable globalTableWitnesses) {
            this.props.globalTableWitnesses(globalTableWitnesses);
            return this;
        }
        /**
         * The list of witnesses of the MRSC global table.
         * <p>
         * Only one witness Region can be configured per MRSC global table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globaltablewitnesses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globaltablewitnesses</a>
         * @param globalTableWitnesses The list of witnesses of the MRSC global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalTableWitnesses(final java.util.List<? extends java.lang.Object> globalTableWitnesses) {
            this.props.globalTableWitnesses(globalTableWitnesses);
            return this;
        }

        /**
         * Local secondary indexes to be created on the table.
         * <p>
         * You can create up to five local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes. Each replica in your global table will have the same local secondary index settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes</a>
         * @param localSecondaryIndexes Local secondary indexes to be created on the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(final software.amazon.awscdk.IResolvable localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }
        /**
         * Local secondary indexes to be created on the table.
         * <p>
         * You can create up to five local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes. Each replica in your global table will have the same local secondary index settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes</a>
         * @param localSecondaryIndexes Local secondary indexes to be created on the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(final java.util.List<? extends java.lang.Object> localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        /**
         * Specifies the consistency mode for a new global table.
         * <p>
         * You can specify one of the following consistency modes:
         * <p>
         * <ul>
         * <li><code>EVENTUAL</code> : Configures a new global table for multi-Region eventual consistency (MREC).</li>
         * <li><code>STRONG</code> : Configures a new global table for multi-Region strong consistency (MRSC).</li>
         * </ul>
         * <p>
         * If you don't specify this field, the global table consistency mode defaults to <code>EVENTUAL</code> . For more information about global tables consistency modes, see <a href="https://docs.aws.amazon.com/V2globaltables_HowItWorks.html#V2globaltables_HowItWorks.consistency-modes">Consistency modes</a> in DynamoDB developer guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-multiregionconsistency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-multiregionconsistency</a>
         * @param multiRegionConsistency Specifies the consistency mode for a new global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionConsistency(final java.lang.String multiRegionConsistency) {
            this.props.multiRegionConsistency(multiRegionConsistency);
            return this;
        }

        /**
         * Specifies the settings to enable server-side encryption.
         * <p>
         * These settings will be applied to all replicas. If you plan to use customer-managed KMS keys, you must provide a key for each replica using the <code>ReplicaSpecification.ReplicaSSESpecification</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification</a>
         * @param sseSpecification Specifies the settings to enable server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(final software.amazon.awscdk.IResolvable sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }
        /**
         * Specifies the settings to enable server-side encryption.
         * <p>
         * These settings will be applied to all replicas. If you plan to use customer-managed KMS keys, you must provide a key for each replica using the <code>ReplicaSpecification.ReplicaSSESpecification</code> property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification</a>
         * @param sseSpecification Specifies the settings to enable server-side encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.SSESpecificationProperty sseSpecification) {
            this.props.sseSpecification(sseSpecification);
            return this;
        }

        /**
         * Specifies the streams settings on your global table.
         * <p>
         * You must provide a value for this property if your global table contains more than one replica. You can only change the streams settings if your global table has only one replica. For Multi-Region Strong Consistency (MRSC), you do not need to provide a value for this property and can change the settings at any time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification</a>
         * @param streamSpecification Specifies the streams settings on your global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(final software.amazon.awscdk.IResolvable streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }
        /**
         * Specifies the streams settings on your global table.
         * <p>
         * You must provide a value for this property if your global table contains more than one replica. You can only change the streams settings if your global table has only one replica. For Multi-Region Strong Consistency (MRSC), you do not need to provide a value for this property and can change the settings at any time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification</a>
         * @param streamSpecification Specifies the streams settings on your global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.StreamSpecificationProperty streamSpecification) {
            this.props.streamSpecification(streamSpecification);
            return this;
        }

        /**
         * A name for the global table.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID as the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename</a>
         * @param tableName A name for the global table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * Specifies the time to live (TTL) settings for the table.
         * <p>
         * This setting will be applied to all replicas.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification</a>
         * @param timeToLiveSpecification Specifies the time to live (TTL) settings for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(final software.amazon.awscdk.IResolvable timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }
        /**
         * Specifies the time to live (TTL) settings for the table.
         * <p>
         * This setting will be applied to all replicas.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification</a>
         * @param timeToLiveSpecification Specifies the time to live (TTL) settings for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.props.timeToLiveSpecification(timeToLiveSpecification);
            return this;
        }

        /**
         * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
         * <p>
         * The settings can be modified using the <code>UpdateTable</code> operation to meet the throughput requirements of an upcoming peak event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-warmthroughput</a>
         * @param warmThroughput Provides visibility into the number of read and write operations your table or secondary index can instantaneously support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(final software.amazon.awscdk.IResolvable warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }
        /**
         * Provides visibility into the number of read and write operations your table or secondary index can instantaneously support.
         * <p>
         * The settings can be modified using the <code>UpdateTable</code> operation to meet the throughput requirements of an upcoming peak event.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-warmthroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-warmthroughput</a>
         * @param warmThroughput Provides visibility into the number of read and write operations your table or secondary index can instantaneously support. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WarmThroughputProperty warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }

        /**
         * Sets the write request settings for a global table or a global secondary index.
         * <p>
         * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings</a>
         * @param writeOnDemandThroughputSettings Sets the write request settings for a global table or a global secondary index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeOnDemandThroughputSettings(final software.amazon.awscdk.IResolvable writeOnDemandThroughputSettings) {
            this.props.writeOnDemandThroughputSettings(writeOnDemandThroughputSettings);
            return this;
        }
        /**
         * Sets the write request settings for a global table or a global secondary index.
         * <p>
         * You can only specify this setting if your resource uses the <code>PAY_PER_REQUEST</code> <code>BillingMode</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeondemandthroughputsettings</a>
         * @param writeOnDemandThroughputSettings Sets the write request settings for a global table or a global secondary index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeOnDemandThroughputSettings(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteOnDemandThroughputSettingsProperty writeOnDemandThroughputSettings) {
            this.props.writeOnDemandThroughputSettings(writeOnDemandThroughputSettings);
            return this;
        }

        /**
         * Specifies an auto scaling policy for write capacity.
         * <p>
         * This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings</a>
         * @param writeProvisionedThroughputSettings Specifies an auto scaling policy for write capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeProvisionedThroughputSettings(final software.amazon.awscdk.IResolvable writeProvisionedThroughputSettings) {
            this.props.writeProvisionedThroughputSettings(writeProvisionedThroughputSettings);
            return this;
        }
        /**
         * Specifies an auto scaling policy for write capacity.
         * <p>
         * This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings</a>
         * @param writeProvisionedThroughputSettings Specifies an auto scaling policy for write capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeProvisionedThroughputSettings(final software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty writeProvisionedThroughputSettings) {
            this.props.writeProvisionedThroughputSettings(writeProvisionedThroughputSettings);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.CfnGlobalTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.CfnGlobalTable build() {
            return new software.amazon.awscdk.services.dynamodb.CfnGlobalTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
