package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's Contributor Insights Mode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                 .enabled(true)
 *                 .mode(ContributorInsightsMode.ACCESSED_AND_THROTTLED_KEYS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-dynamodb-table-contributorinsightsspecification.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-dynamodb-table-contributorinsightsspecification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.466Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ContributorInsightsMode")
public enum ContributorInsightsMode {
    /**
     * Emits metrics for all read and write requests, whether successful or throttled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACCESSED_AND_THROTTLED_KEYS,
    /**
     * Emits metrics for read and write requests that were throttled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THROTTLED_KEYS,
}
