package software.amazon.awscdk.services.ec2;

/**
 * Specific hardware accelerator models supported by EC2.
 * <p>
 * Defines exact accelerator models that can be required or excluded
 * when selecting instance types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Vpc vpc;
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 // Required: CPU and memory constraints
 *                 .vCpuCountMin(2)
 *                 .vCpuCountMax(8)
 *                 .memoryMin(Size.gibibytes(4))
 *                 .memoryMax(Size.gibibytes(32))
 *                 // CPU preferences
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL, CpuManufacturer.AMD))
 *                 .instanceGenerations(List.of(InstanceGeneration.CURRENT))
 *                 // Instance type filtering
 *                 .allowedInstanceTypes(List.of("m5.*", "c5.*"))
 *                 // Performance characteristics
 *                 .burstablePerformance(BurstablePerformance.EXCLUDED)
 *                 .bareMetal(BareMetal.EXCLUDED)
 *                 // Accelerator requirements (for ML/AI workloads)
 *                 .acceleratorTypes(List.of(AcceleratorType.GPU))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .acceleratorNames(List.of(AcceleratorName.T4, AcceleratorName.V100))
 *                 .acceleratorCountMin(1)
 *                 // Storage requirements
 *                 .localStorage(LocalStorage.REQUIRED)
 *                 .localStorageTypes(List.of(LocalStorageType.SSD))
 *                 .totalLocalStorageGBMin(100)
 *                 // Network requirements
 *                 .networkInterfaceCountMin(2)
 *                 .networkBandwidthGbpsMin(10)
 *                 // Cost optimization
 *                 .onDemandMaxPricePercentageOverLowestPrice(10)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.559Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AcceleratorName")
public enum AcceleratorName {
    /**
     * NVIDIA A100 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A100,
    /**
     * NVIDIA K80 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    K80,
    /**
     * NVIDIA M60 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M60,
    /**
     * AMD Radeon Pro V520 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RADEON_PRO_V520,
    /**
     * NVIDIA T4 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T4,
    /**
     * NVIDIA V100 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    V100,
    /**
     * Xilinx VU9P FPGA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VU9P,
    /**
     * NVIDIA A10G GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A10G,
    /**
     * NVIDIA H100 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    H100,
    /**
     * AWS Inferentia chips.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENTIA,
    /**
     * NVIDIA GRID K520 GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    K520,
    /**
     * NVIDIA T4G GPUs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T4G,
}
