package software.amazon.awscdk.services.ec2;

/**
 * Hardware accelerator categories available for EC2 instances.
 * <p>
 * Defines the general type of hardware accelerator that can be attached
 * to an instance, typically used in instance requirement specifications
 * (e.g., GPUs for compute-intensive tasks, FPGAs for custom logic, or
 * inference chips for ML workloads).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Vpc vpc;
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 // Required: CPU and memory constraints
 *                 .vCpuCountMin(2)
 *                 .vCpuCountMax(8)
 *                 .memoryMin(Size.gibibytes(4))
 *                 .memoryMax(Size.gibibytes(32))
 *                 // CPU preferences
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL, CpuManufacturer.AMD))
 *                 .instanceGenerations(List.of(InstanceGeneration.CURRENT))
 *                 // Instance type filtering
 *                 .allowedInstanceTypes(List.of("m5.*", "c5.*"))
 *                 // Performance characteristics
 *                 .burstablePerformance(BurstablePerformance.EXCLUDED)
 *                 .bareMetal(BareMetal.EXCLUDED)
 *                 // Accelerator requirements (for ML/AI workloads)
 *                 .acceleratorTypes(List.of(AcceleratorType.GPU))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .acceleratorNames(List.of(AcceleratorName.T4, AcceleratorName.V100))
 *                 .acceleratorCountMin(1)
 *                 // Storage requirements
 *                 .localStorage(LocalStorage.REQUIRED)
 *                 .localStorageTypes(List.of(LocalStorageType.SSD))
 *                 .totalLocalStorageGBMin(100)
 *                 // Network requirements
 *                 .networkInterfaceCountMin(2)
 *                 .networkBandwidthGbpsMin(10)
 *                 // Cost optimization
 *                 .onDemandMaxPricePercentageOverLowestPrice(10)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.559Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AcceleratorType")
public enum AcceleratorType {
    /**
     * Graphics Processing Unit accelerators, such as NVIDIA GPUs.
     * <p>
     * Commonly used for machine learning training, graphics rendering,
     * or high-performance parallel computing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GPU,
    /**
     * Field Programmable Gate Array accelerators, such as Xilinx FPGAs.
     * <p>
     * Used for hardware-level customization and specialized workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA,
    /**
     * Inference accelerators, such as AWS Inferentia.
     * <p>
     * Purpose-built for efficient machine learning inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE,
}
