package software.amazon.awscdk.services.ec2;

/**
 * CIDR Allocated Subnet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AllocatedSubnet allocatedSubnet = AllocatedSubnet.builder()
 *         .cidr("cidr")
 *         // the properties below are optional
 *         .ipv6Cidr("ipv6Cidr")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.564Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AllocatedSubnet")
@software.amazon.jsii.Jsii.Proxy(AllocatedSubnet.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllocatedSubnet extends software.amazon.jsii.JsiiSerializable {

    /**
     * IPv4 CIDR Allocations for a Subnet.
     * <p>
     * Note this is specific to the IPv4 CIDR.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCidr();

    /**
     * IPv6 CIDR Allocations for a Subnet.
     * <p>
     * Note this is specific to the IPv6 CIDR.
     * <p>
     * Default: - no IPV6 CIDR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Cidr() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AllocatedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllocatedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllocatedSubnet> {
        java.lang.String cidr;
        java.lang.String ipv6Cidr;

        /**
         * Sets the value of {@link AllocatedSubnet#getCidr}
         * @param cidr IPv4 CIDR Allocations for a Subnet. This parameter is required.
         *             Note this is specific to the IPv4 CIDR.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link AllocatedSubnet#getIpv6Cidr}
         * @param ipv6Cidr IPv6 CIDR Allocations for a Subnet.
         *                 Note this is specific to the IPv6 CIDR.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Cidr(java.lang.String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllocatedSubnet}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllocatedSubnet build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllocatedSubnet}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllocatedSubnet {
        private final java.lang.String cidr;
        private final java.lang.String ipv6Cidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Cidr = software.amazon.jsii.Kernel.get(this, "ipv6Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            this.ipv6Cidr = builder.ipv6Cidr;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cidr", om.valueToTree(this.getCidr()));
            if (this.getIpv6Cidr() != null) {
                data.set("ipv6Cidr", om.valueToTree(this.getIpv6Cidr()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AllocatedSubnet"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllocatedSubnet.Jsii$Proxy that = (AllocatedSubnet.Jsii$Proxy) o;

            if (!cidr.equals(that.cidr)) return false;
            return this.ipv6Cidr != null ? this.ipv6Cidr.equals(that.ipv6Cidr) : that.ipv6Cidr == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cidr.hashCode();
            result = 31 * result + (this.ipv6Cidr != null ? this.ipv6Cidr.hashCode() : 0);
            return result;
        }
    }
}
