package software.amazon.awscdk.services.ec2;

/**
 * Burstable CPU performance requirements for EC2 instances.
 * <p>
 * Controls whether selected instance types must, may, or must not
 * support burstable vCPU performance (e.g., T3, T4g families).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Vpc vpc;
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 // Required: CPU and memory constraints
 *                 .vCpuCountMin(2)
 *                 .vCpuCountMax(8)
 *                 .memoryMin(Size.gibibytes(4))
 *                 .memoryMax(Size.gibibytes(32))
 *                 // CPU preferences
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL, CpuManufacturer.AMD))
 *                 .instanceGenerations(List.of(InstanceGeneration.CURRENT))
 *                 // Instance type filtering
 *                 .allowedInstanceTypes(List.of("m5.*", "c5.*"))
 *                 // Performance characteristics
 *                 .burstablePerformance(BurstablePerformance.EXCLUDED)
 *                 .bareMetal(BareMetal.EXCLUDED)
 *                 // Accelerator requirements (for ML/AI workloads)
 *                 .acceleratorTypes(List.of(AcceleratorType.GPU))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .acceleratorNames(List.of(AcceleratorName.T4, AcceleratorName.V100))
 *                 .acceleratorCountMin(1)
 *                 // Storage requirements
 *                 .localStorage(LocalStorage.REQUIRED)
 *                 .localStorageTypes(List.of(LocalStorageType.SSD))
 *                 .totalLocalStorageGBMin(100)
 *                 // Network requirements
 *                 .networkInterfaceCountMin(2)
 *                 .networkBandwidthGbpsMin(10)
 *                 // Cost optimization
 *                 .onDemandMaxPricePercentageOverLowestPrice(10)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.626Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.BurstablePerformance")
public enum BurstablePerformance {
    /**
     * Burstable-performance instance types are allowed, but non-burstable types may also be selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INCLUDED,
    /**
     * Only burstable-performance instance types are allowed.
     * <p>
     * Non-burstable types will be excluded from selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
    /**
     * Burstable-performance instance types are disallowed.
     * <p>
     * Only non-burstable types may be selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXCLUDED,
}
