package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnCapacityManagerDataExport</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityManagerDataExportProps cfnCapacityManagerDataExportProps = CfnCapacityManagerDataExportProps.builder()
 *         .outputFormat("outputFormat")
 *         .s3BucketName("s3BucketName")
 *         .schedule("schedule")
 *         // the properties below are optional
 *         .s3BucketPrefix("s3BucketPrefix")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:02.632Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnCapacityManagerDataExportProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapacityManagerDataExportProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapacityManagerDataExportProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The file format of the exported data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-outputformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutputFormat();

    /**
     * The name of the S3 bucket where export files are delivered.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-s3bucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

    /**
     * The frequency at which data exports are generated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

    /**
     * The S3 key prefix used for organizing export files within the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-s3bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-s3bucketprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketPrefix() {
        return null;
    }

    /**
     * The tags associated with the data export configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacitymanagerdataexport.html#cfn-ec2-capacitymanagerdataexport-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapacityManagerDataExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapacityManagerDataExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapacityManagerDataExportProps> {
        java.lang.String outputFormat;
        java.lang.String s3BucketName;
        java.lang.String schedule;
        java.lang.String s3BucketPrefix;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCapacityManagerDataExportProps#getOutputFormat}
         * @param outputFormat The file format of the exported data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputFormat(java.lang.String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityManagerDataExportProps#getS3BucketName}
         * @param s3BucketName The name of the S3 bucket where export files are delivered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketName(java.lang.String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityManagerDataExportProps#getSchedule}
         * @param schedule The frequency at which data exports are generated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(java.lang.String schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityManagerDataExportProps#getS3BucketPrefix}
         * @param s3BucketPrefix The S3 key prefix used for organizing export files within the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketPrefix(java.lang.String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityManagerDataExportProps#getTags}
         * @param tags The tags associated with the data export configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityManagerDataExportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapacityManagerDataExportProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapacityManagerDataExportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapacityManagerDataExportProps {
        private final java.lang.String outputFormat;
        private final java.lang.String s3BucketName;
        private final java.lang.String schedule;
        private final java.lang.String s3BucketPrefix;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3BucketPrefix = software.amazon.jsii.Kernel.get(this, "s3BucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
            this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.s3BucketPrefix = builder.s3BucketPrefix;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final java.lang.String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final java.lang.String getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.String getS3BucketPrefix() {
            return this.s3BucketPrefix;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
            data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getS3BucketPrefix() != null) {
                data.set("s3BucketPrefix", om.valueToTree(this.getS3BucketPrefix()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnCapacityManagerDataExportProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapacityManagerDataExportProps.Jsii$Proxy that = (CfnCapacityManagerDataExportProps.Jsii$Proxy) o;

            if (!outputFormat.equals(that.outputFormat)) return false;
            if (!s3BucketName.equals(that.s3BucketName)) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (this.s3BucketPrefix != null ? !this.s3BucketPrefix.equals(that.s3BucketPrefix) : that.s3BucketPrefix != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.outputFormat.hashCode();
            result = 31 * result + (this.s3BucketName.hashCode());
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.s3BucketPrefix != null ? this.s3BucketPrefix.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
