package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnLocalGatewayVirtualInterface</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnLocalGatewayVirtualInterfaceProps cfnLocalGatewayVirtualInterfaceProps = CfnLocalGatewayVirtualInterfaceProps.builder()
 *         .localAddress("localAddress")
 *         .localGatewayVirtualInterfaceGroupId("localGatewayVirtualInterfaceGroupId")
 *         .outpostLagId("outpostLagId")
 *         .peerAddress("peerAddress")
 *         .vlan(123)
 *         // the properties below are optional
 *         .peerBgpAsn(123)
 *         .peerBgpAsnExtended(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:03.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnLocalGatewayVirtualInterfaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocalGatewayVirtualInterfaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocalGatewayVirtualInterfaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The local address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-localaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-localaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalAddress();

    /**
     * The ID of the local gateway virtual interface group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-localgatewayvirtualinterfacegroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-localgatewayvirtualinterfacegroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayVirtualInterfaceGroupId();

    /**
     * The Outpost LAG ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-outpostlagid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-outpostlagid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutpostLagId();

    /**
     * The peer address.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peeraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peeraddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPeerAddress();

    /**
     * The ID of the VLAN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-vlan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-vlan</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getVlan();

    /**
     * The peer BGP ASN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peerbgpasn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peerbgpasn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPeerBgpAsn() {
        return null;
    }

    /**
     * The extended 32-bit ASN of the BGP peer for use with larger ASN values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peerbgpasnextended">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-peerbgpasnextended</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPeerBgpAsnExtended() {
        return null;
    }

    /**
     * The tags assigned to the virtual interface.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayvirtualinterface.html#cfn-ec2-localgatewayvirtualinterface-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocalGatewayVirtualInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocalGatewayVirtualInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocalGatewayVirtualInterfaceProps> {
        java.lang.String localAddress;
        java.lang.String localGatewayVirtualInterfaceGroupId;
        java.lang.String outpostLagId;
        java.lang.String peerAddress;
        java.lang.Number vlan;
        java.lang.Number peerBgpAsn;
        java.lang.Number peerBgpAsnExtended;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getLocalAddress}
         * @param localAddress The local address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localAddress(java.lang.String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getLocalGatewayVirtualInterfaceGroupId}
         * @param localGatewayVirtualInterfaceGroupId The ID of the local gateway virtual interface group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayVirtualInterfaceGroupId(java.lang.String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getOutpostLagId}
         * @param outpostLagId The Outpost LAG ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostLagId(java.lang.String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getPeerAddress}
         * @param peerAddress The peer address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAddress(java.lang.String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getVlan}
         * @param vlan The ID of the VLAN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vlan(java.lang.Number vlan) {
            this.vlan = vlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getPeerBgpAsn}
         * @param peerBgpAsn The peer BGP ASN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerBgpAsn(java.lang.Number peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getPeerBgpAsnExtended}
         * @param peerBgpAsnExtended The extended 32-bit ASN of the BGP peer for use with larger ASN values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerBgpAsnExtended(java.lang.Number peerBgpAsnExtended) {
            this.peerBgpAsnExtended = peerBgpAsnExtended;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayVirtualInterfaceProps#getTags}
         * @param tags The tags assigned to the virtual interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocalGatewayVirtualInterfaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocalGatewayVirtualInterfaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocalGatewayVirtualInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocalGatewayVirtualInterfaceProps {
        private final java.lang.String localAddress;
        private final java.lang.String localGatewayVirtualInterfaceGroupId;
        private final java.lang.String outpostLagId;
        private final java.lang.String peerAddress;
        private final java.lang.Number vlan;
        private final java.lang.Number peerBgpAsn;
        private final java.lang.Number peerBgpAsnExtended;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.localAddress = software.amazon.jsii.Kernel.get(this, "localAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayVirtualInterfaceGroupId = software.amazon.jsii.Kernel.get(this, "localGatewayVirtualInterfaceGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outpostLagId = software.amazon.jsii.Kernel.get(this, "outpostLagId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vlan = software.amazon.jsii.Kernel.get(this, "vlan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.peerBgpAsn = software.amazon.jsii.Kernel.get(this, "peerBgpAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.peerBgpAsnExtended = software.amazon.jsii.Kernel.get(this, "peerBgpAsnExtended", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.localAddress = java.util.Objects.requireNonNull(builder.localAddress, "localAddress is required");
            this.localGatewayVirtualInterfaceGroupId = java.util.Objects.requireNonNull(builder.localGatewayVirtualInterfaceGroupId, "localGatewayVirtualInterfaceGroupId is required");
            this.outpostLagId = java.util.Objects.requireNonNull(builder.outpostLagId, "outpostLagId is required");
            this.peerAddress = java.util.Objects.requireNonNull(builder.peerAddress, "peerAddress is required");
            this.vlan = java.util.Objects.requireNonNull(builder.vlan, "vlan is required");
            this.peerBgpAsn = builder.peerBgpAsn;
            this.peerBgpAsnExtended = builder.peerBgpAsnExtended;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public final java.lang.String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final java.lang.String getOutpostLagId() {
            return this.outpostLagId;
        }

        @Override
        public final java.lang.String getPeerAddress() {
            return this.peerAddress;
        }

        @Override
        public final java.lang.Number getVlan() {
            return this.vlan;
        }

        @Override
        public final java.lang.Number getPeerBgpAsn() {
            return this.peerBgpAsn;
        }

        @Override
        public final java.lang.Number getPeerBgpAsnExtended() {
            return this.peerBgpAsnExtended;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("localAddress", om.valueToTree(this.getLocalAddress()));
            data.set("localGatewayVirtualInterfaceGroupId", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupId()));
            data.set("outpostLagId", om.valueToTree(this.getOutpostLagId()));
            data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
            data.set("vlan", om.valueToTree(this.getVlan()));
            if (this.getPeerBgpAsn() != null) {
                data.set("peerBgpAsn", om.valueToTree(this.getPeerBgpAsn()));
            }
            if (this.getPeerBgpAsnExtended() != null) {
                data.set("peerBgpAsnExtended", om.valueToTree(this.getPeerBgpAsnExtended()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnLocalGatewayVirtualInterfaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocalGatewayVirtualInterfaceProps.Jsii$Proxy that = (CfnLocalGatewayVirtualInterfaceProps.Jsii$Proxy) o;

            if (!localAddress.equals(that.localAddress)) return false;
            if (!localGatewayVirtualInterfaceGroupId.equals(that.localGatewayVirtualInterfaceGroupId)) return false;
            if (!outpostLagId.equals(that.outpostLagId)) return false;
            if (!peerAddress.equals(that.peerAddress)) return false;
            if (!vlan.equals(that.vlan)) return false;
            if (this.peerBgpAsn != null ? !this.peerBgpAsn.equals(that.peerBgpAsn) : that.peerBgpAsn != null) return false;
            if (this.peerBgpAsnExtended != null ? !this.peerBgpAsnExtended.equals(that.peerBgpAsnExtended) : that.peerBgpAsnExtended != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.localAddress.hashCode();
            result = 31 * result + (this.localGatewayVirtualInterfaceGroupId.hashCode());
            result = 31 * result + (this.outpostLagId.hashCode());
            result = 31 * result + (this.peerAddress.hashCode());
            result = 31 * result + (this.vlan.hashCode());
            result = 31 * result + (this.peerBgpAsn != null ? this.peerBgpAsn.hashCode() : 0);
            result = 31 * result + (this.peerBgpAsnExtended != null ? this.peerBgpAsnExtended.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
