package software.amazon.awscdk.services.ec2;

/**
 * A reference to a EIPAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * EIPAssociationReference eIPAssociationReference = EIPAssociationReference.builder()
 *         .eipAssociationId("eipAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.050Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EIPAssociationReference")
@software.amazon.jsii.Jsii.Proxy(EIPAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EIPAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the EIPAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEipAssociationId();

    /**
     * @return a {@link Builder} of {@link EIPAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EIPAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EIPAssociationReference> {
        java.lang.String eipAssociationId;

        /**
         * Sets the value of {@link EIPAssociationReference#getEipAssociationId}
         * @param eipAssociationId The Id of the EIPAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eipAssociationId(java.lang.String eipAssociationId) {
            this.eipAssociationId = eipAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EIPAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EIPAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EIPAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EIPAssociationReference {
        private final java.lang.String eipAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eipAssociationId = software.amazon.jsii.Kernel.get(this, "eipAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eipAssociationId = java.util.Objects.requireNonNull(builder.eipAssociationId, "eipAssociationId is required");
        }

        @Override
        public final java.lang.String getEipAssociationId() {
            return this.eipAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eipAssociationId", om.valueToTree(this.getEipAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.EIPAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EIPAssociationReference.Jsii$Proxy that = (EIPAssociationReference.Jsii$Proxy) o;

            return this.eipAssociationId.equals(that.eipAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.eipAssociationId.hashCode();
            return result;
        }
    }
}
