package software.amazon.awscdk.services.ec2;

/**
 * A reference to a EIP resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * EIPReference eIPReference = EIPReference.builder()
 *         .allocationId("allocationId")
 *         .publicIp("publicIp")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.051Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EIPReference")
@software.amazon.jsii.Jsii.Proxy(EIPReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EIPReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AllocationId of the EIP resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAllocationId();

    /**
     * The PublicIp of the EIP resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicIp();

    /**
     * @return a {@link Builder} of {@link EIPReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EIPReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EIPReference> {
        java.lang.String allocationId;
        java.lang.String publicIp;

        /**
         * Sets the value of {@link EIPReference#getAllocationId}
         * @param allocationId The AllocationId of the EIP resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationId(java.lang.String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of {@link EIPReference#getPublicIp}
         * @param publicIp The PublicIp of the EIP resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicIp(java.lang.String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EIPReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EIPReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EIPReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EIPReference {
        private final java.lang.String allocationId;
        private final java.lang.String publicIp;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocationId = software.amazon.jsii.Kernel.get(this, "allocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicIp = software.amazon.jsii.Kernel.get(this, "publicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocationId = java.util.Objects.requireNonNull(builder.allocationId, "allocationId is required");
            this.publicIp = java.util.Objects.requireNonNull(builder.publicIp, "publicIp is required");
        }

        @Override
        public final java.lang.String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final java.lang.String getPublicIp() {
            return this.publicIp;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allocationId", om.valueToTree(this.getAllocationId()));
            data.set("publicIp", om.valueToTree(this.getPublicIp()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.EIPReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EIPReference.Jsii$Proxy that = (EIPReference.Jsii$Proxy) o;

            if (!allocationId.equals(that.allocationId)) return false;
            return this.publicIp.equals(that.publicIp);
        }

        @Override
        public final int hashCode() {
            int result = this.allocationId.hashCode();
            result = 31 * result + (this.publicIp.hashCode());
            return result;
        }
    }
}
