package software.amazon.awscdk.services.ec2;

/**
 * A reference to a IPAMScope resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * IPAMScopeReference iPAMScopeReference = Map.of(
 *         "ipamScopeArn", "ipamScopeArn",
 *         "ipamScopeId", "ipamScopeId");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IPAMScopeReference")
@software.amazon.jsii.Jsii.Proxy(IPAMScopeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPAMScopeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IPAMScope resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeArn();

    /**
     * The IpamScopeId of the IPAMScope resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeId();

    /**
     * @return a {@link Builder} of {@link IPAMScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IPAMScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IPAMScopeReference> {
        java.lang.String ipamScopeArn;
        java.lang.String ipamScopeId;

        /**
         * Sets the value of {@link IPAMScopeReference#getIpamScopeArn}
         * @param ipamScopeArn The ARN of the IPAMScope resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamScopeArn(java.lang.String ipamScopeArn) {
            this.ipamScopeArn = ipamScopeArn;
            return this;
        }

        /**
         * Sets the value of {@link IPAMScopeReference#getIpamScopeId}
         * @param ipamScopeId The IpamScopeId of the IPAMScope resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamScopeId(java.lang.String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IPAMScopeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IPAMScopeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IPAMScopeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPAMScopeReference {
        private final java.lang.String ipamScopeArn;
        private final java.lang.String ipamScopeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipamScopeArn = software.amazon.jsii.Kernel.get(this, "ipamScopeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamScopeId = software.amazon.jsii.Kernel.get(this, "ipamScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipamScopeArn = java.util.Objects.requireNonNull(builder.ipamScopeArn, "ipamScopeArn is required");
            this.ipamScopeId = java.util.Objects.requireNonNull(builder.ipamScopeId, "ipamScopeId is required");
        }

        @Override
        public final java.lang.String getIpamScopeArn() {
            return this.ipamScopeArn;
        }

        @Override
        public final java.lang.String getIpamScopeId() {
            return this.ipamScopeId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipamScopeArn", om.valueToTree(this.getIpamScopeArn()));
            data.set("ipamScopeId", om.valueToTree(this.getIpamScopeId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.IPAMScopeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IPAMScopeReference.Jsii$Proxy that = (IPAMScopeReference.Jsii$Proxy) o;

            if (!ipamScopeArn.equals(that.ipamScopeArn)) return false;
            return this.ipamScopeId.equals(that.ipamScopeId);
        }

        @Override
        public final int hashCode() {
            int result = this.ipamScopeArn.hashCode();
            result = 31 * result + (this.ipamScopeId.hashCode());
            return result;
        }
    }
}
