package software.amazon.awscdk.services.ec2;

/**
 * A reference to a IpPoolRouteTableAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * IpPoolRouteTableAssociationReference ipPoolRouteTableAssociationReference = IpPoolRouteTableAssociationReference.builder()
 *         .associationId("associationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.513Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.IpPoolRouteTableAssociationReference")
@software.amazon.jsii.Jsii.Proxy(IpPoolRouteTableAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IpPoolRouteTableAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AssociationId of the IpPoolRouteTableAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssociationId();

    /**
     * @return a {@link Builder} of {@link IpPoolRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IpPoolRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IpPoolRouteTableAssociationReference> {
        java.lang.String associationId;

        /**
         * Sets the value of {@link IpPoolRouteTableAssociationReference#getAssociationId}
         * @param associationId The AssociationId of the IpPoolRouteTableAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationId(java.lang.String associationId) {
            this.associationId = associationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IpPoolRouteTableAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IpPoolRouteTableAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IpPoolRouteTableAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpPoolRouteTableAssociationReference {
        private final java.lang.String associationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.associationId = software.amazon.jsii.Kernel.get(this, "associationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.associationId = java.util.Objects.requireNonNull(builder.associationId, "associationId is required");
        }

        @Override
        public final java.lang.String getAssociationId() {
            return this.associationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("associationId", om.valueToTree(this.getAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.IpPoolRouteTableAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IpPoolRouteTableAssociationReference.Jsii$Proxy that = (IpPoolRouteTableAssociationReference.Jsii$Proxy) o;

            return this.associationId.equals(that.associationId);
        }

        @Override
        public final int hashCode() {
            int result = this.associationId.hashCode();
            return result;
        }
    }
}
