package software.amazon.awscdk.services.ec2;

/**
 * Modern NAT provider which uses NAT Instances.
 * <p>
 * The instance uses Amazon Linux 2023 as the operating system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * NatInstanceProviderV2 natGatewayProvider = NatProvider.instanceV2(NatInstanceProps.builder()
 *         .instanceType(new InstanceType("t3.small"))
 *         .defaultAllowedTraffic(NatTrafficDirection.NONE)
 *         .build());
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").natGatewayProvider(natGatewayProvider).build();
 * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup")
 *         .vpc(vpc)
 *         .allowAllOutbound(false)
 *         .build();
 * securityGroup.addEgressRule(Peer.anyIpv4(), Port.tcp(443));
 * for (Object gatewayInstance : natGatewayProvider.getGatewayInstances()) {
 *     gatewayInstance.addSecurityGroup(securityGroup);
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatInstanceProviderV2")
public class NatInstanceProviderV2 extends software.amazon.awscdk.services.ec2.NatProvider implements software.amazon.awscdk.services.ec2.IConnectable {

    protected NatInstanceProviderV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NatInstanceProviderV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_USER_DATA_COMMANDS = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.NatInstanceProviderV2.class, "DEFAULT_USER_DATA_COMMANDS", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NatInstanceProviderV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.NatInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by the VPC to configure NAT.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureNat(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ConfigureNatOptions options) {
        software.amazon.jsii.Kernel.call(this, "configureNat", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Configures subnet with the gateway.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param subnet This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureSubnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PrivateSubnet subnet) {
        software.amazon.jsii.Kernel.call(this, "configureSubnet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subnet, "subnet is required") });
    }

    /**
     * Amazon Linux 2023 NAT instance user data commands Enable iptables on the instance, enable persistent IP forwarding, configure NAT on instance.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami">https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<java.lang.String> DEFAULT_USER_DATA_COMMANDS;

    /**
     * Return list of gateways spawned by the provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.GatewayConfig> getConfiguredGateways() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "configuredGateways", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayConfig.class))));
    }

    /**
     * Manage the Security Groups associated with the NAT instances.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Array of gateway instances spawned by the provider after internal configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.Instance> getGatewayInstances() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "gatewayInstances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Instance.class))));
    }

    /**
     * The Security Group associated with the NAT instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.NatInstanceProviderV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.NatInstanceProviderV2> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.NatInstanceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.NatInstanceProps.Builder();
        }

        /**
         * Instance type of the NAT instance.
         * <p>
         * @return {@code this}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * Whether to associate a public IP address to the primary network interface attached to this instance.
         * <p>
         * Default: undefined - No public IP address associated
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Whether to associate a public IP address to the primary network interface attached to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
         * <p>
         * The unlimited CPU credit option is not supported for T3 instances with dedicated host (<code>host</code>) tenancy.
         * <p>
         * Default: - T2 instances are standard, while T3, T4g, and T3a instances are unlimited.
         * <p>
         * @return {@code this}
         * @param creditSpecification Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(final software.amazon.awscdk.services.ec2.CpuCredits creditSpecification) {
            this.props.creditSpecification(creditSpecification);
            return this;
        }

        /**
         * Direction to allow all traffic through the NAT instance by default.
         * <p>
         * By default, inbound and outbound traffic is allowed.
         * <p>
         * If you set this to another value than INBOUND_AND_OUTBOUND, you must
         * configure the NAT instance's security groups in another way, either by
         * passing in a fully configured Security Group using the <code>securityGroup</code>
         * property, or by configuring it using the <code>.securityGroup</code> or
         * <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
         * <p>
         * Default: NatTrafficDirection.INBOUND_AND_OUTBOUND
         * <p>
         * @return {@code this}
         * @param defaultAllowedTraffic Direction to allow all traffic through the NAT instance by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAllowedTraffic(final software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic) {
            this.props.defaultAllowedTraffic(defaultAllowedTraffic);
            return this;
        }

        /**
         * (deprecated) Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
         * </ul>
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * The SSH keypair to grant access to the instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyPair The SSH keypair to grant access to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        /**
         * The machine image (AMI) to use.
         * <p>
         * By default, will do an AMI lookup for the latest NAT instance image.
         * <p>
         * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         * <p>
         * <blockquote><pre>
         * NatProvider.instance(NatInstanceProps.builder()
         *         .instanceType(new InstanceType("t3.micro"))
         *         .machineImage(new GenericLinuxImage(Map.of(
         *                 "us-east-2", "ami-0f9c61b5a562a16af")))
         *         .build());
         * </pre></blockquote>
         * <p>
         * Default: - Latest NAT instance image
         * <p>
         * @return {@code this}
         * @param machineImage The machine image (AMI) to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * (deprecated) Security Group for NAT instances.
         * <p>
         * Default: - A new security group will be created
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * NatInstanceProviderV2 natGatewayProvider = NatProvider.instanceV2(NatInstanceProps.builder()
         *         .instanceType(new InstanceType("t3.small"))
         *         .defaultAllowedTraffic(NatTrafficDirection.NONE)
         *         .build());
         * Vpc vpc = Vpc.Builder.create(this, "Vpc").natGatewayProvider(natGatewayProvider).build();
         * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup")
         *         .vpc(vpc)
         *         .allowAllOutbound(false)
         *         .build();
         * securityGroup.addEgressRule(Peer.anyIpv4(), Port.tcp(443));
         * for (Object gatewayInstance : natGatewayProvider.getGatewayInstances()) {
         *     gatewayInstance.addSecurityGroup(securityGroup);
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @deprecated - Cannot create a new security group before the VPC is created,
         * and cannot create the VPC without the NAT provider.
         * Set {@link defaultAllowedTraffic } to {@link NatTrafficDirection.NONE }
         * and use {@link NatInstanceProviderV2.gatewayInstances } to retrieve
         * the instances on the fly and add security groups
         * @param securityGroup Security Group for NAT instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Custom user data to run on the NAT instances.
         * <p>
         * Default: UserData.forLinux().addCommands(...NatInstanceProviderV2.DEFAULT_USER_DATA_COMMANDS);  - Appropriate user data commands to initialize and configure the NAT instances
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami">https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami</a>
         * @param userData Custom user data to run on the NAT instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.NatInstanceProviderV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.NatInstanceProviderV2 build() {
            return new software.amazon.awscdk.services.ec2.NatInstanceProviderV2(
                this.props.build()
            );
        }
    }
}
