package software.amazon.awscdk.services.ec2;

/**
 * A reference to a NetworkInsightsAccessScopeAnalysis resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NetworkInsightsAccessScopeAnalysisReference networkInsightsAccessScopeAnalysisReference = NetworkInsightsAccessScopeAnalysisReference.builder()
 *         .networkInsightsAccessScopeAnalysisArn("networkInsightsAccessScopeAnalysisArn")
 *         .networkInsightsAccessScopeAnalysisId("networkInsightsAccessScopeAnalysisId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NetworkInsightsAccessScopeAnalysisReference")
@software.amazon.jsii.Jsii.Proxy(NetworkInsightsAccessScopeAnalysisReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkInsightsAccessScopeAnalysisReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the NetworkInsightsAccessScopeAnalysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAccessScopeAnalysisArn();

    /**
     * The NetworkInsightsAccessScopeAnalysisId of the NetworkInsightsAccessScopeAnalysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsAccessScopeAnalysisId();

    /**
     * @return a {@link Builder} of {@link NetworkInsightsAccessScopeAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkInsightsAccessScopeAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkInsightsAccessScopeAnalysisReference> {
        java.lang.String networkInsightsAccessScopeAnalysisArn;
        java.lang.String networkInsightsAccessScopeAnalysisId;

        /**
         * Sets the value of {@link NetworkInsightsAccessScopeAnalysisReference#getNetworkInsightsAccessScopeAnalysisArn}
         * @param networkInsightsAccessScopeAnalysisArn The ARN of the NetworkInsightsAccessScopeAnalysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAccessScopeAnalysisArn(java.lang.String networkInsightsAccessScopeAnalysisArn) {
            this.networkInsightsAccessScopeAnalysisArn = networkInsightsAccessScopeAnalysisArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkInsightsAccessScopeAnalysisReference#getNetworkInsightsAccessScopeAnalysisId}
         * @param networkInsightsAccessScopeAnalysisId The NetworkInsightsAccessScopeAnalysisId of the NetworkInsightsAccessScopeAnalysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsAccessScopeAnalysisId(java.lang.String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkInsightsAccessScopeAnalysisReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkInsightsAccessScopeAnalysisReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkInsightsAccessScopeAnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInsightsAccessScopeAnalysisReference {
        private final java.lang.String networkInsightsAccessScopeAnalysisArn;
        private final java.lang.String networkInsightsAccessScopeAnalysisId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInsightsAccessScopeAnalysisArn = software.amazon.jsii.Kernel.get(this, "networkInsightsAccessScopeAnalysisArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInsightsAccessScopeAnalysisId = software.amazon.jsii.Kernel.get(this, "networkInsightsAccessScopeAnalysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInsightsAccessScopeAnalysisArn = java.util.Objects.requireNonNull(builder.networkInsightsAccessScopeAnalysisArn, "networkInsightsAccessScopeAnalysisArn is required");
            this.networkInsightsAccessScopeAnalysisId = java.util.Objects.requireNonNull(builder.networkInsightsAccessScopeAnalysisId, "networkInsightsAccessScopeAnalysisId is required");
        }

        @Override
        public final java.lang.String getNetworkInsightsAccessScopeAnalysisArn() {
            return this.networkInsightsAccessScopeAnalysisArn;
        }

        @Override
        public final java.lang.String getNetworkInsightsAccessScopeAnalysisId() {
            return this.networkInsightsAccessScopeAnalysisId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInsightsAccessScopeAnalysisArn", om.valueToTree(this.getNetworkInsightsAccessScopeAnalysisArn()));
            data.set("networkInsightsAccessScopeAnalysisId", om.valueToTree(this.getNetworkInsightsAccessScopeAnalysisId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NetworkInsightsAccessScopeAnalysisReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkInsightsAccessScopeAnalysisReference.Jsii$Proxy that = (NetworkInsightsAccessScopeAnalysisReference.Jsii$Proxy) o;

            if (!networkInsightsAccessScopeAnalysisArn.equals(that.networkInsightsAccessScopeAnalysisArn)) return false;
            return this.networkInsightsAccessScopeAnalysisId.equals(that.networkInsightsAccessScopeAnalysisId);
        }

        @Override
        public final int hashCode() {
            int result = this.networkInsightsAccessScopeAnalysisArn.hashCode();
            result = 31 * result + (this.networkInsightsAccessScopeAnalysisId.hashCode());
            return result;
        }
    }
}
