package software.amazon.awscdk.services.ec2;

/**
 * A reference to a NetworkInsightsPath resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NetworkInsightsPathReference networkInsightsPathReference = NetworkInsightsPathReference.builder()
 *         .networkInsightsPathArn("networkInsightsPathArn")
 *         .networkInsightsPathId("networkInsightsPathId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.561Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NetworkInsightsPathReference")
@software.amazon.jsii.Jsii.Proxy(NetworkInsightsPathReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkInsightsPathReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the NetworkInsightsPath resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsPathArn();

    /**
     * The NetworkInsightsPathId of the NetworkInsightsPath resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInsightsPathId();

    /**
     * @return a {@link Builder} of {@link NetworkInsightsPathReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkInsightsPathReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkInsightsPathReference> {
        java.lang.String networkInsightsPathArn;
        java.lang.String networkInsightsPathId;

        /**
         * Sets the value of {@link NetworkInsightsPathReference#getNetworkInsightsPathArn}
         * @param networkInsightsPathArn The ARN of the NetworkInsightsPath resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsPathArn(java.lang.String networkInsightsPathArn) {
            this.networkInsightsPathArn = networkInsightsPathArn;
            return this;
        }

        /**
         * Sets the value of {@link NetworkInsightsPathReference#getNetworkInsightsPathId}
         * @param networkInsightsPathId The NetworkInsightsPathId of the NetworkInsightsPath resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInsightsPathId(java.lang.String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkInsightsPathReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkInsightsPathReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkInsightsPathReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInsightsPathReference {
        private final java.lang.String networkInsightsPathArn;
        private final java.lang.String networkInsightsPathId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInsightsPathArn = software.amazon.jsii.Kernel.get(this, "networkInsightsPathArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInsightsPathId = software.amazon.jsii.Kernel.get(this, "networkInsightsPathId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInsightsPathArn = java.util.Objects.requireNonNull(builder.networkInsightsPathArn, "networkInsightsPathArn is required");
            this.networkInsightsPathId = java.util.Objects.requireNonNull(builder.networkInsightsPathId, "networkInsightsPathId is required");
        }

        @Override
        public final java.lang.String getNetworkInsightsPathArn() {
            return this.networkInsightsPathArn;
        }

        @Override
        public final java.lang.String getNetworkInsightsPathId() {
            return this.networkInsightsPathId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInsightsPathArn", om.valueToTree(this.getNetworkInsightsPathArn()));
            data.set("networkInsightsPathId", om.valueToTree(this.getNetworkInsightsPathId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NetworkInsightsPathReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkInsightsPathReference.Jsii$Proxy that = (NetworkInsightsPathReference.Jsii$Proxy) o;

            if (!networkInsightsPathArn.equals(that.networkInsightsPathArn)) return false;
            return this.networkInsightsPathId.equals(that.networkInsightsPathId);
        }

        @Override
        public final int hashCode() {
            int result = this.networkInsightsPathArn.hashCode();
            result = 31 * result + (this.networkInsightsPathId.hashCode());
            return result;
        }
    }
}
