package software.amazon.awscdk.services.ec2;

/**
 * A reference to a NetworkPerformanceMetricSubscription resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NetworkPerformanceMetricSubscriptionReference networkPerformanceMetricSubscriptionReference = NetworkPerformanceMetricSubscriptionReference.builder()
 *         .destination("destination")
 *         .metric("metric")
 *         .source("source")
 *         .statistic("statistic")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.562Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NetworkPerformanceMetricSubscriptionReference")
@software.amazon.jsii.Jsii.Proxy(NetworkPerformanceMetricSubscriptionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkPerformanceMetricSubscriptionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Destination of the NetworkPerformanceMetricSubscription resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestination();

    /**
     * The Metric of the NetworkPerformanceMetricSubscription resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetric();

    /**
     * The Source of the NetworkPerformanceMetricSubscription resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The Statistic of the NetworkPerformanceMetricSubscription resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

    /**
     * @return a {@link Builder} of {@link NetworkPerformanceMetricSubscriptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkPerformanceMetricSubscriptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkPerformanceMetricSubscriptionReference> {
        java.lang.String destination;
        java.lang.String metric;
        java.lang.String source;
        java.lang.String statistic;

        /**
         * Sets the value of {@link NetworkPerformanceMetricSubscriptionReference#getDestination}
         * @param destination The Destination of the NetworkPerformanceMetricSubscription resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(java.lang.String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPerformanceMetricSubscriptionReference#getMetric}
         * @param metric The Metric of the NetworkPerformanceMetricSubscription resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(java.lang.String metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPerformanceMetricSubscriptionReference#getSource}
         * @param source The Source of the NetworkPerformanceMetricSubscription resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link NetworkPerformanceMetricSubscriptionReference#getStatistic}
         * @param statistic The Statistic of the NetworkPerformanceMetricSubscription resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkPerformanceMetricSubscriptionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkPerformanceMetricSubscriptionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkPerformanceMetricSubscriptionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkPerformanceMetricSubscriptionReference {
        private final java.lang.String destination;
        private final java.lang.String metric;
        private final java.lang.String source;
        private final java.lang.String statistic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.metric = java.util.Objects.requireNonNull(builder.metric, "metric is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
        }

        @Override
        public final java.lang.String getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.String getMetric() {
            return this.metric;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("source", om.valueToTree(this.getSource()));
            data.set("statistic", om.valueToTree(this.getStatistic()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NetworkPerformanceMetricSubscriptionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkPerformanceMetricSubscriptionReference.Jsii$Proxy that = (NetworkPerformanceMetricSubscriptionReference.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (!metric.equals(that.metric)) return false;
            if (!source.equals(that.source)) return false;
            return this.statistic.equals(that.statistic);
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.metric.hashCode());
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.statistic.hashCode());
            return result;
        }
    }
}
