package software.amazon.awscdk.services.ec2;

/**
 * A reference to a PrefixList resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * PrefixListReference prefixListReference = PrefixListReference.builder()
 *         .prefixListArn("prefixListArn")
 *         .prefixListId("prefixListId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.569Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PrefixListReference")
@software.amazon.jsii.Jsii.Proxy(PrefixListReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrefixListReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PrefixList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrefixListArn();

    /**
     * The PrefixListId of the PrefixList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrefixListId();

    /**
     * @return a {@link Builder} of {@link PrefixListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrefixListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrefixListReference> {
        java.lang.String prefixListArn;
        java.lang.String prefixListId;

        /**
         * Sets the value of {@link PrefixListReference#getPrefixListArn}
         * @param prefixListArn The ARN of the PrefixList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListArn(java.lang.String prefixListArn) {
            this.prefixListArn = prefixListArn;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListReference#getPrefixListId}
         * @param prefixListId The PrefixListId of the PrefixList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListId(java.lang.String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrefixListReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrefixListReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrefixListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixListReference {
        private final java.lang.String prefixListArn;
        private final java.lang.String prefixListId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefixListArn = software.amazon.jsii.Kernel.get(this, "prefixListArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.prefixListId = software.amazon.jsii.Kernel.get(this, "prefixListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefixListArn = java.util.Objects.requireNonNull(builder.prefixListArn, "prefixListArn is required");
            this.prefixListId = java.util.Objects.requireNonNull(builder.prefixListId, "prefixListId is required");
        }

        @Override
        public final java.lang.String getPrefixListArn() {
            return this.prefixListArn;
        }

        @Override
        public final java.lang.String getPrefixListId() {
            return this.prefixListId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("prefixListArn", om.valueToTree(this.getPrefixListArn()));
            data.set("prefixListId", om.valueToTree(this.getPrefixListId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.PrefixListReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrefixListReference.Jsii$Proxy that = (PrefixListReference.Jsii$Proxy) o;

            if (!prefixListArn.equals(that.prefixListArn)) return false;
            return this.prefixListId.equals(that.prefixListId);
        }

        @Override
        public final int hashCode() {
            int result = this.prefixListArn.hashCode();
            result = 31 * result + (this.prefixListId.hashCode());
            return result;
        }
    }
}
