package software.amazon.awscdk.services.ec2;

/**
 * A reference to a RouteServerEndpoint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * RouteServerEndpointReference routeServerEndpointReference = RouteServerEndpointReference.builder()
 *         .routeServerEndpointArn("routeServerEndpointArn")
 *         .routeServerEndpointId("routeServerEndpointId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.575Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.RouteServerEndpointReference")
@software.amazon.jsii.Jsii.Proxy(RouteServerEndpointReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteServerEndpointReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RouteServerEndpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerEndpointArn();

    /**
     * The Id of the RouteServerEndpoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteServerEndpointId();

    /**
     * @return a {@link Builder} of {@link RouteServerEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteServerEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteServerEndpointReference> {
        java.lang.String routeServerEndpointArn;
        java.lang.String routeServerEndpointId;

        /**
         * Sets the value of {@link RouteServerEndpointReference#getRouteServerEndpointArn}
         * @param routeServerEndpointArn The ARN of the RouteServerEndpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerEndpointArn(java.lang.String routeServerEndpointArn) {
            this.routeServerEndpointArn = routeServerEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link RouteServerEndpointReference#getRouteServerEndpointId}
         * @param routeServerEndpointId The Id of the RouteServerEndpoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeServerEndpointId(java.lang.String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteServerEndpointReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteServerEndpointReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteServerEndpointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteServerEndpointReference {
        private final java.lang.String routeServerEndpointArn;
        private final java.lang.String routeServerEndpointId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeServerEndpointArn = software.amazon.jsii.Kernel.get(this, "routeServerEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routeServerEndpointId = software.amazon.jsii.Kernel.get(this, "routeServerEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeServerEndpointArn = java.util.Objects.requireNonNull(builder.routeServerEndpointArn, "routeServerEndpointArn is required");
            this.routeServerEndpointId = java.util.Objects.requireNonNull(builder.routeServerEndpointId, "routeServerEndpointId is required");
        }

        @Override
        public final java.lang.String getRouteServerEndpointArn() {
            return this.routeServerEndpointArn;
        }

        @Override
        public final java.lang.String getRouteServerEndpointId() {
            return this.routeServerEndpointId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeServerEndpointArn", om.valueToTree(this.getRouteServerEndpointArn()));
            data.set("routeServerEndpointId", om.valueToTree(this.getRouteServerEndpointId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.RouteServerEndpointReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteServerEndpointReference.Jsii$Proxy that = (RouteServerEndpointReference.Jsii$Proxy) o;

            if (!routeServerEndpointArn.equals(that.routeServerEndpointArn)) return false;
            return this.routeServerEndpointId.equals(that.routeServerEndpointId);
        }

        @Override
        public final int hashCode() {
            int result = this.routeServerEndpointArn.hashCode();
            result = 31 * result + (this.routeServerEndpointId.hashCode());
            return result;
        }
    }
}
