package software.amazon.awscdk.services.ec2;

/**
 * A reference to a SecurityGroupEgress resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * SecurityGroupEgressReference securityGroupEgressReference = SecurityGroupEgressReference.builder()
 *         .securityGroupEgressId("securityGroupEgressId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.580Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SecurityGroupEgressReference")
@software.amazon.jsii.Jsii.Proxy(SecurityGroupEgressReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecurityGroupEgressReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the SecurityGroupEgress resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupEgressId();

    /**
     * @return a {@link Builder} of {@link SecurityGroupEgressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityGroupEgressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityGroupEgressReference> {
        java.lang.String securityGroupEgressId;

        /**
         * Sets the value of {@link SecurityGroupEgressReference#getSecurityGroupEgressId}
         * @param securityGroupEgressId The Id of the SecurityGroupEgress resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupEgressId(java.lang.String securityGroupEgressId) {
            this.securityGroupEgressId = securityGroupEgressId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupEgressReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecurityGroupEgressReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecurityGroupEgressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityGroupEgressReference {
        private final java.lang.String securityGroupEgressId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroupEgressId = software.amazon.jsii.Kernel.get(this, "securityGroupEgressId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroupEgressId = java.util.Objects.requireNonNull(builder.securityGroupEgressId, "securityGroupEgressId is required");
        }

        @Override
        public final java.lang.String getSecurityGroupEgressId() {
            return this.securityGroupEgressId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroupEgressId", om.valueToTree(this.getSecurityGroupEgressId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.SecurityGroupEgressReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityGroupEgressReference.Jsii$Proxy that = (SecurityGroupEgressReference.Jsii$Proxy) o;

            return this.securityGroupEgressId.equals(that.securityGroupEgressId);
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroupEgressId.hashCode();
            return result;
        }
    }
}
