package software.amazon.awscdk.services.ec2;

/**
 * A reference to a TransitGateway resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * TransitGatewayReference transitGatewayReference = TransitGatewayReference.builder()
 *         .transitGatewayArn("transitGatewayArn")
 *         .transitGatewayId("transitGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.610Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.TransitGatewayReference")
@software.amazon.jsii.Jsii.Proxy(TransitGatewayReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransitGatewayReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the TransitGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayArn();

    /**
     * The Id of the TransitGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayId();

    /**
     * @return a {@link Builder} of {@link TransitGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransitGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayReference> {
        java.lang.String transitGatewayArn;
        java.lang.String transitGatewayId;

        /**
         * Sets the value of {@link TransitGatewayReference#getTransitGatewayArn}
         * @param transitGatewayArn The ARN of the TransitGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayArn(java.lang.String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        /**
         * Sets the value of {@link TransitGatewayReference#getTransitGatewayId}
         * @param transitGatewayId The Id of the TransitGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransitGatewayReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransitGatewayReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransitGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayReference {
        private final java.lang.String transitGatewayArn;
        private final java.lang.String transitGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.transitGatewayArn = software.amazon.jsii.Kernel.get(this, "transitGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.transitGatewayArn = java.util.Objects.requireNonNull(builder.transitGatewayArn, "transitGatewayArn is required");
            this.transitGatewayId = java.util.Objects.requireNonNull(builder.transitGatewayId, "transitGatewayId is required");
        }

        @Override
        public final java.lang.String getTransitGatewayArn() {
            return this.transitGatewayArn;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("transitGatewayArn", om.valueToTree(this.getTransitGatewayArn()));
            data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.TransitGatewayReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransitGatewayReference.Jsii$Proxy that = (TransitGatewayReference.Jsii$Proxy) o;

            if (!transitGatewayArn.equals(that.transitGatewayArn)) return false;
            return this.transitGatewayId.equals(that.transitGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.transitGatewayArn.hashCode();
            result = 31 * result + (this.transitGatewayId.hashCode());
            return result;
        }
    }
}
