package software.amazon.awscdk.services.ec2;

/**
 * A reference to a VPNConnection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * VPNConnectionReference vPNConnectionReference = VPNConnectionReference.builder()
 *         .vpnConnectionId("vpnConnectionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VPNConnectionReference")
@software.amazon.jsii.Jsii.Proxy(VPNConnectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VPNConnectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VpnConnectionId of the VPNConnection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpnConnectionId();

    /**
     * @return a {@link Builder} of {@link VPNConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VPNConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VPNConnectionReference> {
        java.lang.String vpnConnectionId;

        /**
         * Sets the value of {@link VPNConnectionReference#getVpnConnectionId}
         * @param vpnConnectionId The VpnConnectionId of the VPNConnection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnConnectionId(java.lang.String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VPNConnectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VPNConnectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VPNConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPNConnectionReference {
        private final java.lang.String vpnConnectionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpnConnectionId = software.amazon.jsii.Kernel.get(this, "vpnConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpnConnectionId = java.util.Objects.requireNonNull(builder.vpnConnectionId, "vpnConnectionId is required");
        }

        @Override
        public final java.lang.String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpnConnectionId", om.valueToTree(this.getVpnConnectionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.VPNConnectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VPNConnectionReference.Jsii$Proxy that = (VPNConnectionReference.Jsii$Proxy) o;

            return this.vpnConnectionId.equals(that.vpnConnectionId);
        }

        @Override
        public final int hashCode() {
            int result = this.vpnConnectionId.hashCode();
            return result;
        }
    }
}
