package software.amazon.awscdk.services.ec2;

/**
 * A reference to a VerifiedAccessInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * VerifiedAccessInstanceReference verifiedAccessInstanceReference = VerifiedAccessInstanceReference.builder()
 *         .verifiedAccessInstanceId("verifiedAccessInstanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.618Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VerifiedAccessInstanceReference")
@software.amazon.jsii.Jsii.Proxy(VerifiedAccessInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VerifiedAccessInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VerifiedAccessInstanceId of the VerifiedAccessInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVerifiedAccessInstanceId();

    /**
     * @return a {@link Builder} of {@link VerifiedAccessInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VerifiedAccessInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VerifiedAccessInstanceReference> {
        java.lang.String verifiedAccessInstanceId;

        /**
         * Sets the value of {@link VerifiedAccessInstanceReference#getVerifiedAccessInstanceId}
         * @param verifiedAccessInstanceId The VerifiedAccessInstanceId of the VerifiedAccessInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessInstanceId(java.lang.String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VerifiedAccessInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VerifiedAccessInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VerifiedAccessInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VerifiedAccessInstanceReference {
        private final java.lang.String verifiedAccessInstanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.verifiedAccessInstanceId = software.amazon.jsii.Kernel.get(this, "verifiedAccessInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.verifiedAccessInstanceId = java.util.Objects.requireNonNull(builder.verifiedAccessInstanceId, "verifiedAccessInstanceId is required");
        }

        @Override
        public final java.lang.String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("verifiedAccessInstanceId", om.valueToTree(this.getVerifiedAccessInstanceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.VerifiedAccessInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VerifiedAccessInstanceReference.Jsii$Proxy that = (VerifiedAccessInstanceReference.Jsii$Proxy) o;

            return this.verifiedAccessInstanceId.equals(that.verifiedAccessInstanceId);
        }

        @Override
        public final int hashCode() {
            int result = this.verifiedAccessInstanceId.hashCode();
            return result;
        }
    }
}
