package software.amazon.awscdk.services.ec2;

/**
 * The VPN connection type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack stack = new Stack();
 * VpcV2 myVpc = new VpcV2(this, "Vpc");
 * VPNGatewayV2 vpnGateway = myVpc.enableVpnGatewayV2(VPNGatewayV2Options.builder()
 *         .vpnRoutePropagation(List.of(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build()))
 *         .type(VpnConnectionType.IPSEC_1)
 *         .build());
 * RouteTable routeTable = RouteTable.Builder.create(stack, "routeTable")
 *         .vpc(myVpc)
 *         .build();
 * Route.Builder.create(stack, "route")
 *         .destination("172.31.0.0/24")
 *         .target(Map.of("gateway", vpnGateway))
 *         .routeTable(routeTable)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.655Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VpnConnectionType")
public enum VpnConnectionType {
    /**
     * The IPsec 1 VPN connection type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPSEC_1,
    /**
     * Dummy member TODO: remove once https://github.com/aws/jsii/issues/231 is fixed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUMMY,
}
