package software.amazon.awscdk.services.ecr;

/**
 * The tag mutability setting for your repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Make all tags immutable except for those starting with 'dev-' or 'test-'
 * // Make all tags immutable except for those starting with 'dev-' or 'test-'
 * Repository.Builder.create(this, "Repo")
 *         .imageTagMutability(TagMutability.IMMUTABLE_WITH_EXCLUSION)
 *         .imageTagMutabilityExclusionFilters(List.of(ImageTagMutabilityExclusionFilter.wildcard("dev-*"), ImageTagMutabilityExclusionFilter.wildcard("test-*")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.717Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.TagMutability")
public enum TagMutability {
    /**
     * allow image tags to be overwritten.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MUTABLE,
    /**
     * all image tags within the repository will be immutable which will prevent them from being overwritten.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IMMUTABLE,
    /**
     * all image tags within the repository will be immutable, while allowing you to define some filters for tags that can be changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IMMUTABLE_WITH_EXCLUSION,
    /**
     * allow image tags to be overwritten while allowing you to define some filters for tags that should remain unchanged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MUTABLE_WITH_EXCLUSION,
}
