package software.amazon.awscdk.services.ecs;

/**
 * Properties for AlternateTarget configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Function lambdaHook;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * ApplicationListenerRule prodListenerRule;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentStrategy(DeploymentStrategy.BLUE_GREEN)
 *         .build();
 * service.addLifecycleHook(DeploymentLifecycleLambdaTarget.Builder.create(lambdaHook, "PreScaleHook")
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.PRE_SCALE_UP))
 *         .build());
 * IEcsLoadBalancerTarget target = service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("nginx")
 *         .containerPort(80)
 *         .protocol(Protocol.TCP)
 *         .alternateTarget(AlternateTarget.Builder.create("AlternateTarget")
 *                 .alternateTargetGroup(greenTargetGroup)
 *                 .productionListener(ListenerRuleConfiguration.applicationListenerRule(prodListenerRule))
 *                 .build())
 *         .build());
 * target.attachToApplicationTargetGroup(blueTargetGroup);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.777Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AlternateTargetProps")
@software.amazon.jsii.Jsii.Proxy(AlternateTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlternateTargetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.AlternateTargetOptions {

    /**
     * The alternate target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getAlternateTargetGroup();

    /**
     * The production listener rule ARN (ALB) or listener ARN (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerRuleConfiguration getProductionListener();

    /**
     * @return a {@link Builder} of {@link AlternateTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlternateTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlternateTargetProps> {
        software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup alternateTargetGroup;
        software.amazon.awscdk.services.ecs.ListenerRuleConfiguration productionListener;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener;

        /**
         * Sets the value of {@link AlternateTargetProps#getAlternateTargetGroup}
         * @param alternateTargetGroup The alternate target group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alternateTargetGroup(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup alternateTargetGroup) {
            this.alternateTargetGroup = alternateTargetGroup;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetProps#getProductionListener}
         * @param productionListener The production listener rule ARN (ALB) or listener ARN (NLB). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionListener(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration productionListener) {
            this.productionListener = productionListener;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetProps#getRole}
         * @param role The IAM role for the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetProps#getTestListener}
         * @param testListener The test listener configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testListener(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener) {
            this.testListener = testListener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlternateTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlternateTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlternateTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlternateTargetProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup alternateTargetGroup;
        private final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration productionListener;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alternateTargetGroup = software.amazon.jsii.Kernel.get(this, "alternateTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.class));
            this.productionListener = software.amazon.jsii.Kernel.get(this, "productionListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.testListener = software.amazon.jsii.Kernel.get(this, "testListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alternateTargetGroup = java.util.Objects.requireNonNull(builder.alternateTargetGroup, "alternateTargetGroup is required");
            this.productionListener = java.util.Objects.requireNonNull(builder.productionListener, "productionListener is required");
            this.role = builder.role;
            this.testListener = builder.testListener;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup getAlternateTargetGroup() {
            return this.alternateTargetGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration getProductionListener() {
            return this.productionListener;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration getTestListener() {
            return this.testListener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alternateTargetGroup", om.valueToTree(this.getAlternateTargetGroup()));
            data.set("productionListener", om.valueToTree(this.getProductionListener()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTestListener() != null) {
                data.set("testListener", om.valueToTree(this.getTestListener()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AlternateTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlternateTargetProps.Jsii$Proxy that = (AlternateTargetProps.Jsii$Proxy) o;

            if (!alternateTargetGroup.equals(that.alternateTargetGroup)) return false;
            if (!productionListener.equals(that.productionListener)) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.testListener != null ? this.testListener.equals(that.testListener) : that.testListener == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alternateTargetGroup.hashCode();
            result = 31 * result + (this.productionListener.hashCode());
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.testListener != null ? this.testListener.hashCode() : 0);
            return result;
        }
    }
}
