package software.amazon.awscdk.services.ecs;

/**
 * The class for App Mesh proxy configurations.
 * <p>
 * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version
 * 1.26.0-1 of the ecs-init package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized
 * AMI version 20190301 or later, then they contain the required versions of the container agent and ecs-init.
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized AMIs</a>.
 * <p>
 * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * AppMeshProxyConfiguration appMeshProxyConfiguration = AppMeshProxyConfiguration.Builder.create()
 *         .containerName("containerName")
 *         .properties(AppMeshProxyConfigurationProps.builder()
 *                 .appPorts(List.of(123))
 *                 .proxyEgressPort(123)
 *                 .proxyIngressPort(123)
 *                 // the properties below are optional
 *                 .egressIgnoredIPs(List.of("egressIgnoredIPs"))
 *                 .egressIgnoredPorts(List.of(123))
 *                 .ignoredGID(123)
 *                 .ignoredUID(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:04.777Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AppMeshProxyConfiguration")
public class AppMeshProxyConfiguration extends software.amazon.awscdk.services.ecs.ProxyConfiguration {

    protected AppMeshProxyConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppMeshProxyConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the AppMeshProxyConfiguration class.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AppMeshProxyConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AppMeshProxyConfigurationConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the proxy configuration is configured on a task definition.
     * <p>
     * @param _scope This parameter is required.
     * @param _taskDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition _taskDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_taskDefinition, "_taskDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AppMeshProxyConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AppMeshProxyConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.AppMeshProxyConfigurationConfigProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.AppMeshProxyConfigurationConfigProps.Builder();
        }

        /**
         * The name of the container that will serve as the App Mesh proxy.
         * <p>
         * @return {@code this}
         * @param containerName The name of the container that will serve as the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        /**
         * The set of network configuration parameters to provide the Container Network Interface (CNI) plugin.
         * <p>
         * @return {@code this}
         * @param properties The set of network configuration parameters to provide the Container Network Interface (CNI) plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.services.ecs.AppMeshProxyConfigurationProps properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.AppMeshProxyConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AppMeshProxyConfiguration build() {
            return new software.amazon.awscdk.services.ecs.AppMeshProxyConfiguration(
                this.props.build()
            );
        }
    }
}
