package software.amazon.awscdk.services.ecs;

/**
 * Configuration for a lambda deployment lifecycle hook.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Function lambdaHook;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * ApplicationListenerRule prodListenerRule;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentStrategy(DeploymentStrategy.BLUE_GREEN)
 *         .build();
 * service.addLifecycleHook(DeploymentLifecycleLambdaTarget.Builder.create(lambdaHook, "PreScaleHook")
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.PRE_SCALE_UP))
 *         .build());
 * IEcsLoadBalancerTarget target = service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("nginx")
 *         .containerPort(80)
 *         .protocol(Protocol.TCP)
 *         .alternateTarget(AlternateTarget.Builder.create("AlternateTarget")
 *                 .alternateTargetGroup(greenTargetGroup)
 *                 .productionListener(ListenerRuleConfiguration.applicationListenerRule(prodListenerRule))
 *                 .build())
 *         .build());
 * target.attachToApplicationTargetGroup(blueTargetGroup);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentLifecycleLambdaTargetProps")
@software.amazon.jsii.Jsii.Proxy(DeploymentLifecycleLambdaTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentLifecycleLambdaTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The lifecycle stages when this hook should be executed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> getLifecycleStages();

    /**
     * The IAM role that grants permissions to invoke the lambda target.
     * <p>
     * Default: - A unique role will be generated for this lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentLifecycleLambdaTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentLifecycleLambdaTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentLifecycleLambdaTargetProps> {
        java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link DeploymentLifecycleLambdaTargetProps#getLifecycleStages}
         * @param lifecycleStages The lifecycle stages when this hook should be executed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lifecycleStages(java.util.List<? extends software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages) {
            this.lifecycleStages = (java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage>)lifecycleStages;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentLifecycleLambdaTargetProps#getRole}
         * @param role The IAM role that grants permissions to invoke the lambda target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentLifecycleLambdaTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentLifecycleLambdaTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentLifecycleLambdaTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentLifecycleLambdaTargetProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> lifecycleStages;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lifecycleStages = software.amazon.jsii.Kernel.get(this, "lifecycleStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentLifecycleStage.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lifecycleStages = (java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage>)java.util.Objects.requireNonNull(builder.lifecycleStages, "lifecycleStages is required");
            this.role = builder.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.DeploymentLifecycleStage> getLifecycleStages() {
            return this.lifecycleStages;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lifecycleStages", om.valueToTree(this.getLifecycleStages()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.DeploymentLifecycleLambdaTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentLifecycleLambdaTargetProps.Jsii$Proxy that = (DeploymentLifecycleLambdaTargetProps.Jsii$Proxy) o;

            if (!lifecycleStages.equals(that.lifecycleStages)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lifecycleStages.hashCode();
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
