package software.amazon.awscdk.services.ecs;

/**
 * The configuration for an Elastic FileSystem volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * EfsVolumeConfiguration efsVolumeConfiguration = EfsVolumeConfiguration.builder()
 *         .fileSystemId("fileSystemId")
 *         // the properties below are optional
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .accessPointId("accessPointId")
 *                 .iam("iam")
 *                 .build())
 *         .rootDirectory("rootDirectory")
 *         .transitEncryption("transitEncryption")
 *         .transitEncryptionPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.203Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.EfsVolumeConfiguration")
@software.amazon.jsii.Jsii.Proxy(EfsVolumeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EfsVolumeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon EFS file system ID to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * The authorization configuration details for the Amazon EFS file system.
     * <p>
     * Default: No configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AuthorizationConfig getAuthorizationConfig() {
        return null;
    }

    /**
     * The directory within the Amazon EFS file system to mount as the root directory inside the host.
     * <p>
     * Specifying / will have the same effect as omitting this parameter.
     * <p>
     * Default: The root of the Amazon EFS volume
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
        return null;
    }

    /**
     * Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * Transit encryption must be enabled if Amazon EFS IAM authorization is used.
     * <p>
     * Valid values: ENABLED | DISABLED
     * <p>
     * Default: DISABLED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitEncryption() {
        return null;
    }

    /**
     * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     * <p>
     * EFS mount helper uses.
     * <p>
     * Default: Port selection strategy that the Amazon EFS mount helper uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EfsVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EfsVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EfsVolumeConfiguration> {
        java.lang.String fileSystemId;
        software.amazon.awscdk.services.ecs.AuthorizationConfig authorizationConfig;
        java.lang.String rootDirectory;
        java.lang.String transitEncryption;
        java.lang.Number transitEncryptionPort;

        /**
         * Sets the value of {@link EfsVolumeConfiguration#getFileSystemId}
         * @param fileSystemId The Amazon EFS file system ID to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeConfiguration#getAuthorizationConfig}
         * @param authorizationConfig The authorization configuration details for the Amazon EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(software.amazon.awscdk.services.ecs.AuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeConfiguration#getRootDirectory}
         * @param rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host.
         *                      Specifying / will have the same effect as omitting this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDirectory(java.lang.String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeConfiguration#getTransitEncryption}
         * @param transitEncryption Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
         *                          Transit encryption must be enabled if Amazon EFS IAM authorization is used.
         *                          <p>
         *                          Valid values: ENABLED | DISABLED
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryption(java.lang.String transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        /**
         * Sets the value of {@link EfsVolumeConfiguration#getTransitEncryptionPort}
         * @param transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         *                              EFS mount helper uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryptionPort(java.lang.Number transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EfsVolumeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EfsVolumeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EfsVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EfsVolumeConfiguration {
        private final java.lang.String fileSystemId;
        private final software.amazon.awscdk.services.ecs.AuthorizationConfig authorizationConfig;
        private final java.lang.String rootDirectory;
        private final java.lang.String transitEncryption;
        private final java.lang.Number transitEncryptionPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AuthorizationConfig.class));
            this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitEncryption = software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitEncryptionPort = software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            this.authorizationConfig = builder.authorizationConfig;
            this.rootDirectory = builder.rootDirectory;
            this.transitEncryption = builder.transitEncryption;
            this.transitEncryptionPort = builder.transitEncryptionPort;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.AuthorizationConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final java.lang.String getRootDirectory() {
            return this.rootDirectory;
        }

        @Override
        public final java.lang.String getTransitEncryption() {
            return this.transitEncryption;
        }

        @Override
        public final java.lang.Number getTransitEncryptionPort() {
            return this.transitEncryptionPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getRootDirectory() != null) {
                data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
            }
            if (this.getTransitEncryption() != null) {
                data.set("transitEncryption", om.valueToTree(this.getTransitEncryption()));
            }
            if (this.getTransitEncryptionPort() != null) {
                data.set("transitEncryptionPort", om.valueToTree(this.getTransitEncryptionPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.EfsVolumeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EfsVolumeConfiguration.Jsii$Proxy that = (EfsVolumeConfiguration.Jsii$Proxy) o;

            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.rootDirectory != null ? !this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory != null) return false;
            if (this.transitEncryption != null ? !this.transitEncryption.equals(that.transitEncryption) : that.transitEncryption != null) return false;
            return this.transitEncryptionPort != null ? this.transitEncryptionPort.equals(that.transitEncryptionPort) : that.transitEncryptionPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemId.hashCode();
            result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
            result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
            result = 31 * result + (this.transitEncryption != null ? this.transitEncryption.hashCode() : 0);
            result = 31 * result + (this.transitEncryptionPort != null ? this.transitEncryptionPort.hashCode() : 0);
            return result;
        }
    }
}
