package software.amazon.awscdk.services.ecs;

/**
 * An extension for Task Definitions.
 * <p>
 * Classes that want to make changes to a TaskDefinition (such as
 * adding helper containers) can implement this interface, and can
 * then be "added" to a TaskDefinition like so:
 * <p>
 * taskDefinition.addExtension(new MyExtension("some_parameter"));
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.268Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ITaskDefinitionExtension")
@software.amazon.jsii.Jsii.Proxy(ITaskDefinitionExtension.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ITaskDefinitionExtension extends software.amazon.jsii.JsiiSerializable {

    /**
     * Apply the extension to the given TaskDefinition.
     * <p>
     * @param taskDefinition [disable-awslint:ref-via-interface]. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void extend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.ITaskDefinitionExtension.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Apply the extension to the given TaskDefinition.
         * <p>
         * @param taskDefinition [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void extend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            software.amazon.jsii.Kernel.call(this, "extend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
        }
    }

    /**
     * Internal default implementation for {@link ITaskDefinitionExtension}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ITaskDefinitionExtension {

        /**
         * Apply the extension to the given TaskDefinition.
         * <p>
         * @param taskDefinition [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void extend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            software.amazon.jsii.Kernel.call(this, "extend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
        }
    }
}
