package software.amazon.awscdk.services.ecs;

/**
 * Base class for configuring listener when registering targets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Vpc vpc;
 * FargateService service = FargateService.Builder.create(this, "Service").cluster(cluster).taskDefinition(taskDefinition).minHealthyPercent(100).build();
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB").vpc(vpc).internetFacing(true).build();
 * ApplicationListener listener = lb.addListener("Listener", BaseApplicationListenerProps.builder().port(80).build());
 * service.registerLoadBalancerTargets(EcsTarget.builder()
 *         .containerName("web")
 *         .containerPort(80)
 *         .newTargetGroupId("ECS")
 *         .listener(ListenerConfig.applicationListener(listener, AddApplicationTargetsProps.builder()
 *                 .protocol(ApplicationProtocol.HTTPS)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.273Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ListenerConfig")
public abstract class ListenerConfig extends software.amazon.jsii.JsiiObject {

    protected ListenerConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ListenerConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ListenerConfig() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create a config for adding target group to ALB listener.
     * <p>
     * @param listener This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerConfig applicationListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener listener, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ListenerConfig.class, "applicationListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), props });
    }

    /**
     * Create a config for adding target group to ALB listener.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerConfig applicationListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener listener) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ListenerConfig.class, "applicationListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Create a config for adding target group to NLB listener.
     * <p>
     * @param listener This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerConfig networkListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener listener, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ListenerConfig.class, "networkListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(listener, "listener is required"), props });
    }

    /**
     * Create a config for adding target group to NLB listener.
     * <p>
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerConfig networkListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener listener) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ListenerConfig.class, "networkListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * Create and attach a target group to listener.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param service This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.ListenerConfig {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Create and attach a target group to listener.
         * <p>
         * @param id This parameter is required.
         * @param target This parameter is required.
         * @param service This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service) {
            software.amazon.jsii.Kernel.call(this, "addTargets", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(service, "service is required") });
        }
    }
}
