package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the base QueueProcessingEc2Service or QueueProcessingFargateService service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Cluster cluster;
 * ContainerImage containerImage;
 * LogDriver logDriver;
 * Queue queue;
 * Secret secret;
 * Vpc vpc;
 * QueueProcessingServiceBaseProps queueProcessingServiceBaseProps = QueueProcessingServiceBaseProps.builder()
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("capacityProvider")
 *                 // the properties below are optional
 *                 .base(123)
 *                 .weight(123)
 *                 .build()))
 *         .circuitBreaker(DeploymentCircuitBreaker.builder()
 *                 .enable(false)
 *                 .rollback(false)
 *                 .build())
 *         .cluster(cluster)
 *         .command(List.of("command"))
 *         .cooldown(Duration.minutes(30))
 *         .cpuTargetUtilizationPercent(123)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.ECS)
 *                 .build())
 *         .disableCpuBasedScaling(false)
 *         .enableECSManagedTags(false)
 *         .enableExecuteCommand(false)
 *         .enableLogging(false)
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .family("family")
 *         .image(containerImage)
 *         .logDriver(logDriver)
 *         .maxHealthyPercent(123)
 *         .maxReceiveCount(123)
 *         .maxScalingCapacity(123)
 *         .minHealthyPercent(123)
 *         .minScalingCapacity(123)
 *         .propagateTags(PropagatedTagSource.SERVICE)
 *         .queue(queue)
 *         .retentionPeriod(Duration.minutes(30))
 *         .scalingSteps(List.of(ScalingInterval.builder()
 *                 .change(123)
 *                 // the properties below are optional
 *                 .lower(123)
 *                 .upper(123)
 *                 .build()))
 *         .secrets(Map.of(
 *                 "secretsKey", secret))
 *         .serviceName("serviceName")
 *         .visibilityTimeout(Duration.minutes(30))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.QueueProcessingServiceBaseProps")
@software.amazon.jsii.Jsii.Proxy(QueueProcessingServiceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueueProcessingServiceBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of Capacity Provider strategies used to place a service.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
        return null;
    }

    /**
     * Whether to enable the deployment circuit breaker.
     * <p>
     * If this property is defined, circuit breaker will be implicitly
     * enabled.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
        return null;
    }

    /**
     * The name of the cluster that hosts the service.
     * <p>
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     * <p>
     * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * The command that is passed to the container.
     * <p>
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     * <p>
     * Default: - CMD value built into container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * Grace period after scaling activity in seconds.
     * <p>
     * Subsequent scale outs during the cooldown period are squashed so that only
     * the biggest scale out happens.
     * <p>
     * Subsequent scale ins during the cooldown period are ignored.
     * <p>
     * Default: 300 seconds
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCooldown() {
        return null;
    }

    /**
     * The target CPU utilization percentage for CPU based scaling strategy when enabled.
     * <p>
     * Default: - 50
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuTargetUtilizationPercent() {
        return null;
    }

    /**
     * Specifies which deployment controller to use for the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
     * <p>
     * Default: - Rolling update (ECS)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
        return null;
    }

    /**
     * Flag to disable CPU based auto scaling strategy on the service.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableCpuBasedScaling() {
        return null;
    }

    /**
     * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableECSManagedTags() {
        return null;
    }

    /**
     * Whether ECS Exec should be enabled.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableExecuteCommand() {
        return null;
    }

    /**
     * Flag to indicate whether to enable logging.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableLogging() {
        return null;
    }

    /**
     * The environment variables to pass to the container.
     * <p>
     * The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
     * always be passed.
     * <p>
     * Default: 'QUEUE_NAME: queue.queueName'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The name of a family that the task definition is registered to.
     * <p>
     * A family groups multiple versions of a task definition.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return null;
    }

    /**
     * The image used to start a container.
     * <p>
     * For <code>QueueProcessingFargateService</code>, either <code>image</code> or <code>taskDefinition</code> must be specified, but not both.
     * For <code>QueueProcessingEc2Service</code>, <code>image</code> is required.
     * <p>
     * Default: - the image of the task definition is used for Fargate, required otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerImage getImage() {
        return null;
    }

    /**
     * The log driver to use.
     * <p>
     * Default: - AwsLogDriver if enableLogging is true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
        return null;
    }

    /**
     * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     * <p>
     * Default: - default from underlying service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxHealthyPercent() {
        return null;
    }

    /**
     * The maximum number of times that a message can be received by consumers.
     * <p>
     * When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
     * <p>
     * If the queue construct is specified, maxReceiveCount should be omitted.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReceiveCount() {
        return null;
    }

    /**
     * Maximum capacity to scale to.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxScalingCapacity() {
        return null;
    }

    /**
     * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     * <p>
     * Default: - default from underlying service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinHealthyPercent() {
        return null;
    }

    /**
     * Minimum capacity to scale to.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinScalingCapacity() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * Tags can only be propagated to the tasks within the service during service creation.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * A queue for which to process items from.
     * <p>
     * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
     * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
     * <p>
     * Default: 'SQSQueue with CloudFormation-generated name'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getQueue() {
        return null;
    }

    /**
     * The number of seconds that Dead Letter Queue retains a message.
     * <p>
     * If the queue construct is specified, retentionPeriod should be omitted.
     * <p>
     * Default: Duration.days(14)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getRetentionPeriod() {
        return null;
    }

    /**
     * The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
     * <p>
     * Maps a range of metric values to a particular scaling behavior. See
     * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
     * <p>
     * Default: [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
        return null;
    }

    /**
     * The secret to expose to the container as an environment variable.
     * <p>
     * Default: - No secret environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
        return null;
    }

    /**
     * The name of the service.
     * <p>
     * Default: - CloudFormation-generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * Timeout of processing a single message.
     * <p>
     * After dequeuing, the processor has this much time to handle the message and delete it from the queue
     * before it becomes visible again for dequeueing by another processor. Values must be between 0 and (12 hours).
     * <p>
     * If the queue construct is specified, visibilityTimeout should be omitted.
     * <p>
     * Default: Duration.seconds(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getVisibilityTimeout() {
        return null;
    }

    /**
     * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     * <p>
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     * <p>
     * Default: - uses the VPC defined in the cluster or creates a new VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueProcessingServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueProcessingServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueueProcessingServiceBaseProps> {
        java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        java.util.List<java.lang.String> command;
        software.amazon.awscdk.Duration cooldown;
        java.lang.Number cpuTargetUtilizationPercent;
        software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        java.lang.Boolean disableCpuBasedScaling;
        java.lang.Boolean enableEcsManagedTags;
        java.lang.Boolean enableExecuteCommand;
        java.lang.Boolean enableLogging;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.String family;
        software.amazon.awscdk.services.ecs.ContainerImage image;
        software.amazon.awscdk.services.ecs.LogDriver logDriver;
        java.lang.Number maxHealthyPercent;
        java.lang.Number maxReceiveCount;
        java.lang.Number maxScalingCapacity;
        java.lang.Number minHealthyPercent;
        java.lang.Number minScalingCapacity;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        software.amazon.awscdk.services.sqs.IQueue queue;
        software.amazon.awscdk.Duration retentionPeriod;
        java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        java.lang.String serviceName;
        software.amazon.awscdk.Duration visibilityTimeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCapacityProviderStrategies}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder capacityProviderStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCooldown}
         * @param cooldown Grace period after scaling activity in seconds.
         *                 Subsequent scale outs during the cooldown period are squashed so that only
         *                 the biggest scale out happens.
         *                 <p>
         *                 Subsequent scale ins during the cooldown period are ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getCpuTargetUtilizationPercent}
         * @param cpuTargetUtilizationPercent The target CPU utilization percentage for CPU based scaling strategy when enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuTargetUtilizationPercent(java.lang.Number cpuTargetUtilizationPercent) {
            this.cpuTargetUtilizationPercent = cpuTargetUtilizationPercent;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getDisableCpuBasedScaling}
         * @param disableCpuBasedScaling Flag to disable CPU based auto scaling strategy on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableCpuBasedScaling(java.lang.Boolean disableCpuBasedScaling) {
            this.disableCpuBasedScaling = disableCpuBasedScaling;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether ECS Exec should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getEnableLogging}
         * @param enableLogging Flag to indicate whether to enable logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getEnvironment}
         * @param environment The environment variables to pass to the container.
         *                    The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
         *                    always be passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getFamily}
         * @param family The name of a family that the task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getImage}
         * @param image The image used to start a container.
         *              For <code>QueueProcessingFargateService</code>, either <code>image</code> or <code>taskDefinition</code> must be specified, but not both.
         *              For <code>QueueProcessingEc2Service</code>, <code>image</code> is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getMaxReceiveCount}
         * @param maxReceiveCount The maximum number of times that a message can be received by consumers.
         *                        When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
         *                        <p>
         *                        If the queue construct is specified, maxReceiveCount should be omitted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceiveCount(java.lang.Number maxReceiveCount) {
            this.maxReceiveCount = maxReceiveCount;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getMaxScalingCapacity}
         * @param maxScalingCapacity Maximum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxScalingCapacity(java.lang.Number maxScalingCapacity) {
            this.maxScalingCapacity = maxScalingCapacity;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getMinScalingCapacity}
         * @param minScalingCapacity Minimum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minScalingCapacity(java.lang.Number minScalingCapacity) {
            this.minScalingCapacity = minScalingCapacity;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getQueue}
         * @param queue A queue for which to process items from.
         *              If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
         *              <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getRetentionPeriod}
         * @param retentionPeriod The number of seconds that Dead Letter Queue retains a message.
         *                        If the queue construct is specified, retentionPeriod should be omitted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         *                     Maps a range of metric values to a particular scaling behavior. See
         *                     <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scalingSteps(java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getVisibilityTimeout}
         * @param visibilityTimeout Timeout of processing a single message.
         *                          After dequeuing, the processor has this much time to handle the message and delete it from the queue
         *                          before it becomes visible again for dequeueing by another processor. Values must be between 0 and (12 hours).
         *                          <p>
         *                          If the queue construct is specified, visibilityTimeout should be omitted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(software.amazon.awscdk.Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingServiceBaseProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProcessingServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueueProcessingServiceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueueProcessingServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueProcessingServiceBaseProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.util.List<java.lang.String> command;
        private final software.amazon.awscdk.Duration cooldown;
        private final java.lang.Number cpuTargetUtilizationPercent;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Boolean disableCpuBasedScaling;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final java.lang.Boolean enableLogging;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number maxReceiveCount;
        private final java.lang.Number maxScalingCapacity;
        private final java.lang.Number minHealthyPercent;
        private final java.lang.Number minScalingCapacity;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private final software.amazon.awscdk.Duration retentionPeriod;
        private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.Duration visibilityTimeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacityProviderStrategies = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CapacityProviderStrategy.class)));
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.cpuTargetUtilizationPercent = software.amazon.jsii.Kernel.get(this, "cpuTargetUtilizationPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.disableCpuBasedScaling = software.amazon.jsii.Kernel.get(this, "disableCpuBasedScaling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableLogging = software.amazon.jsii.Kernel.get(this, "enableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxReceiveCount = software.amazon.jsii.Kernel.get(this, "maxReceiveCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxScalingCapacity = software.amazon.jsii.Kernel.get(this, "maxScalingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minScalingCapacity = software.amazon.jsii.Kernel.get(this, "minScalingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.scalingSteps = software.amazon.jsii.Kernel.get(this, "scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class)));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visibilityTimeout = software.amazon.jsii.Kernel.get(this, "visibilityTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)builder.capacityProviderStrategies;
            this.circuitBreaker = builder.circuitBreaker;
            this.cluster = builder.cluster;
            this.command = builder.command;
            this.cooldown = builder.cooldown;
            this.cpuTargetUtilizationPercent = builder.cpuTargetUtilizationPercent;
            this.deploymentController = builder.deploymentController;
            this.disableCpuBasedScaling = builder.disableCpuBasedScaling;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.enableExecuteCommand = builder.enableExecuteCommand;
            this.enableLogging = builder.enableLogging;
            this.environment = builder.environment;
            this.family = builder.family;
            this.image = builder.image;
            this.logDriver = builder.logDriver;
            this.maxHealthyPercent = builder.maxHealthyPercent;
            this.maxReceiveCount = builder.maxReceiveCount;
            this.maxScalingCapacity = builder.maxScalingCapacity;
            this.minHealthyPercent = builder.minHealthyPercent;
            this.minScalingCapacity = builder.minScalingCapacity;
            this.propagateTags = builder.propagateTags;
            this.queue = builder.queue;
            this.retentionPeriod = builder.retentionPeriod;
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)builder.scalingSteps;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)builder.secrets;
            this.serviceName = builder.serviceName;
            this.visibilityTimeout = builder.visibilityTimeout;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
            return this.capacityProviderStrategies;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Number getCpuTargetUtilizationPercent() {
            return this.cpuTargetUtilizationPercent;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Boolean getDisableCpuBasedScaling() {
            return this.disableCpuBasedScaling;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMaxReceiveCount() {
            return this.maxReceiveCount;
        }

        @Override
        public final java.lang.Number getMaxScalingCapacity() {
            return this.maxScalingCapacity;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinScalingCapacity() {
            return this.minScalingCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.queue;
        }

        @Override
        public final software.amazon.awscdk.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.Duration getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCapacityProviderStrategies() != null) {
                data.set("capacityProviderStrategies", om.valueToTree(this.getCapacityProviderStrategies()));
            }
            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getCpuTargetUtilizationPercent() != null) {
                data.set("cpuTargetUtilizationPercent", om.valueToTree(this.getCpuTargetUtilizationPercent()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getDisableCpuBasedScaling() != null) {
                data.set("disableCpuBasedScaling", om.valueToTree(this.getDisableCpuBasedScaling()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMaxReceiveCount() != null) {
                data.set("maxReceiveCount", om.valueToTree(this.getMaxReceiveCount()));
            }
            if (this.getMaxScalingCapacity() != null) {
                data.set("maxScalingCapacity", om.valueToTree(this.getMaxScalingCapacity()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getMinScalingCapacity() != null) {
                data.set("minScalingCapacity", om.valueToTree(this.getMinScalingCapacity()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getQueue() != null) {
                data.set("queue", om.valueToTree(this.getQueue()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getScalingSteps() != null) {
                data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.QueueProcessingServiceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueProcessingServiceBaseProps.Jsii$Proxy that = (QueueProcessingServiceBaseProps.Jsii$Proxy) o;

            if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) return false;
            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.cpuTargetUtilizationPercent != null ? !this.cpuTargetUtilizationPercent.equals(that.cpuTargetUtilizationPercent) : that.cpuTargetUtilizationPercent != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.disableCpuBasedScaling != null ? !this.disableCpuBasedScaling.equals(that.disableCpuBasedScaling) : that.disableCpuBasedScaling != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.maxReceiveCount != null ? !this.maxReceiveCount.equals(that.maxReceiveCount) : that.maxReceiveCount != null) return false;
            if (this.maxScalingCapacity != null ? !this.maxScalingCapacity.equals(that.maxScalingCapacity) : that.maxScalingCapacity != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.minScalingCapacity != null ? !this.minScalingCapacity.equals(that.minScalingCapacity) : that.minScalingCapacity != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.scalingSteps != null ? !this.scalingSteps.equals(that.scalingSteps) : that.scalingSteps != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.visibilityTimeout != null ? !this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0;
            result = 31 * result + (this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.cpuTargetUtilizationPercent != null ? this.cpuTargetUtilizationPercent.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.disableCpuBasedScaling != null ? this.disableCpuBasedScaling.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.maxReceiveCount != null ? this.maxReceiveCount.hashCode() : 0);
            result = 31 * result + (this.maxScalingCapacity != null ? this.maxScalingCapacity.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minScalingCapacity != null ? this.minScalingCapacity.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.scalingSteps != null ? this.scalingSteps.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
