package software.amazon.awscdk.services.efs;

/**
 * A reference to a FileSystem resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * FileSystemReference fileSystemReference = FileSystemReference.builder()
 *         .fileSystemArn("fileSystemArn")
 *         .fileSystemId("fileSystemId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.488Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.FileSystemReference")
@software.amazon.jsii.Jsii.Proxy(FileSystemReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSystemReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the FileSystem resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn();

    /**
     * The FileSystemId of the FileSystem resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * @return a {@link Builder} of {@link FileSystemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemReference> {
        java.lang.String fileSystemArn;
        java.lang.String fileSystemId;

        /**
         * Sets the value of {@link FileSystemReference#getFileSystemArn}
         * @param fileSystemArn The ARN of the FileSystem resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemArn(java.lang.String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemReference#getFileSystemId}
         * @param fileSystemId The FileSystemId of the FileSystem resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSystemReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSystemReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemReference {
        private final java.lang.String fileSystemArn;
        private final java.lang.String fileSystemId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemArn = software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemArn = java.util.Objects.requireNonNull(builder.fileSystemArn, "fileSystemArn is required");
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
        }

        @Override
        public final java.lang.String getFileSystemArn() {
            return this.fileSystemArn;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemArn", om.valueToTree(this.getFileSystemArn()));
            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.FileSystemReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemReference.Jsii$Proxy that = (FileSystemReference.Jsii$Proxy) o;

            if (!fileSystemArn.equals(that.fileSystemArn)) return false;
            return this.fileSystemId.equals(that.fileSystemId);
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemArn.hashCode();
            result = 31 * result + (this.fileSystemId.hashCode());
            return result;
        }
    }
}
