package software.amazon.awscdk.services.eks;

/**
 * Represents the authentication mode for an Amazon EKS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v33.KubectlV33Layer;
 * Vpc vpc;
 * Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .version(KubernetesVersion.V1_33)
 *         .kubectlLayer(new KubectlV33Layer(this, "KubectlLayer"))
 *         .authenticationMode(AuthenticationMode.API_AND_CONFIG_MAP)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AuthenticationMode")
public enum AuthenticationMode {
    /**
     * Authenticates using a Kubernetes ConfigMap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONFIG_MAP,
    /**
     * Authenticates using both the Kubernetes API server and a ConfigMap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API_AND_CONFIG_MAP,
    /**
     * Authenticates using the Kubernetes API server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API,
}
