package software.amazon.awscdk.services.eks;

/**
 * A reference to a FargateProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * FargateProfileReference fargateProfileReference = FargateProfileReference.builder()
 *         .clusterName("clusterName")
 *         .fargateProfileArn("fargateProfileArn")
 *         .fargateProfileName("fargateProfileName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.640Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateProfileReference")
@software.amazon.jsii.Jsii.Proxy(FargateProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ClusterName of the FargateProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The ARN of the FargateProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFargateProfileArn();

    /**
     * The FargateProfileName of the FargateProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFargateProfileName();

    /**
     * @return a {@link Builder} of {@link FargateProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateProfileReference> {
        java.lang.String clusterName;
        java.lang.String fargateProfileArn;
        java.lang.String fargateProfileName;

        /**
         * Sets the value of {@link FargateProfileReference#getClusterName}
         * @param clusterName The ClusterName of the FargateProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileReference#getFargateProfileArn}
         * @param fargateProfileArn The ARN of the FargateProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateProfileArn(java.lang.String fargateProfileArn) {
            this.fargateProfileArn = fargateProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link FargateProfileReference#getFargateProfileName}
         * @param fargateProfileName The FargateProfileName of the FargateProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fargateProfileName(java.lang.String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateProfileReference {
        private final java.lang.String clusterName;
        private final java.lang.String fargateProfileArn;
        private final java.lang.String fargateProfileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fargateProfileArn = software.amazon.jsii.Kernel.get(this, "fargateProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fargateProfileName = software.amazon.jsii.Kernel.get(this, "fargateProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.fargateProfileArn = java.util.Objects.requireNonNull(builder.fargateProfileArn, "fargateProfileArn is required");
            this.fargateProfileName = java.util.Objects.requireNonNull(builder.fargateProfileName, "fargateProfileName is required");
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getFargateProfileArn() {
            return this.fargateProfileArn;
        }

        @Override
        public final java.lang.String getFargateProfileName() {
            return this.fargateProfileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("fargateProfileArn", om.valueToTree(this.getFargateProfileArn()));
            data.set("fargateProfileName", om.valueToTree(this.getFargateProfileName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.FargateProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateProfileReference.Jsii$Proxy that = (FargateProfileReference.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!fargateProfileArn.equals(that.fargateProfileArn)) return false;
            return this.fargateProfileName.equals(that.fargateProfileName);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.fargateProfileArn.hashCode());
            result = 31 * result + (this.fargateProfileName.hashCode());
            return result;
        }
    }
}
