package software.amazon.awscdk.services.elasticache;

/**
 * A reference to a SecurityGroupIngress resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * SecurityGroupIngressReference securityGroupIngressReference = SecurityGroupIngressReference.builder()
 *         .securityGroupIngressId("securityGroupIngressId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:05.755Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.SecurityGroupIngressReference")
@software.amazon.jsii.Jsii.Proxy(SecurityGroupIngressReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecurityGroupIngressReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the SecurityGroupIngress resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupIngressId();

    /**
     * @return a {@link Builder} of {@link SecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityGroupIngressReference> {
        java.lang.String securityGroupIngressId;

        /**
         * Sets the value of {@link SecurityGroupIngressReference#getSecurityGroupIngressId}
         * @param securityGroupIngressId The Id of the SecurityGroupIngress resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIngressId(java.lang.String securityGroupIngressId) {
            this.securityGroupIngressId = securityGroupIngressId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityGroupIngressReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecurityGroupIngressReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityGroupIngressReference {
        private final java.lang.String securityGroupIngressId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroupIngressId = software.amazon.jsii.Kernel.get(this, "securityGroupIngressId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroupIngressId = java.util.Objects.requireNonNull(builder.securityGroupIngressId, "securityGroupIngressId is required");
        }

        @Override
        public final java.lang.String getSecurityGroupIngressId() {
            return this.securityGroupIngressId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroupIngressId", om.valueToTree(this.getSecurityGroupIngressId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.SecurityGroupIngressReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityGroupIngressReference.Jsii$Proxy that = (SecurityGroupIngressReference.Jsii$Proxy) o;

            return this.securityGroupIngressId.equals(that.securityGroupIngressId);
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroupIngressId.hashCode();
            return result;
        }
    }
}
